~VERSION INFORMATION 
VERS  .    2.0                                     :CWLS Log ASCII Standard - VERSION2.0
WRAP  .    NO                                      :One Line per Time step
DLM   .    SPACE                                   :Column Data section Delimiter
PROD  .    Schlumberger Technology Corp.           :LAS Producer
PROG  .    Horizon LASWriter 2.1.6903.0            :LAS Program name and version
CREA  .    03/24/2011                              :LAS Creation date {MM/DD/YYYY}
#--------------------------------------------------
~WELL INFORMATION 
#MNEM           .UNIT                      DATA            :DESCRIPTION
#----            ------          --------------            -----------------------------
STRT            .d             40622.1875000000            :START TIME(OLE Automation date)
STOP            .d             40625.6402777778            :STOP TIME(OLE Automation date)
STEP            .d                            0            :STEP TIME(30s in time)
NULL            .                       -999.25            :NULL VALUE
COMP            .                          IODP            :COMPANY
WELL            .                        U1379A            :WELL NAME
FLD             .                Expedition 334            :FIELD NAME
RIGN            .             JOIDES Resolution            :Rig Name
RIGTYP          .                    Drill Ship            :Rig Type
SON             .                     11MED0004            :Service Order Number
SRVC            .                  Schlumberger            :SERVICE COMPANY
DATE            .                    03/20/2011            :LOG DATE{MM/DD/YYYY} (Composite Date for Composite LAP)
CLAB            .                       County:            :County Label
CNTY            .                       -999.25            :COUNTY
SLAB            .                        State:            :State/Province Label
STAT            .                    Puntarenas            :STATE or PROVINCE
PROV            .                    Puntarenas            :STATE or PROVINCE
CTRY            .                    Costa Rica            :COUNTRY
CONT_REGION     .                Central America           :Continent Region
SECT            .                       -999.25            :Section
TOWN            .                       -999.25            :Township
RANG            .                       -999.25            :Range
API             .                           n/a            :API NUMBER
UWI             .                        U1379A            :UNIQUE WELL ID
LUL             .                           n/a            :Logging Unit Location
LUN             .                           n/a            :Logging Unit Number
LOC             .                         CRISP            :FIELD LOCATION
FL1             .                           n/a            :Field Location Line 1
FL2             .                           n/a            :Field Location Line 2
LATI            .deg         8 35' 24.00000" N            :LATITUDE
LONG            .deg         84 4' 48.00000" W            :LONGITUDE
PDAT            .                           MSL            :Local Permanent Datum
LMF             .                            DF            :Logging Measured From
APD             .m                         9.80            :Elevation of Depth Reference (LMF) Above Permanent Datum
EPD             .m                         0.00            :Elevation of Permanent Datum (PDAT) above Mean Sea Level
EKB             .m                      -999.25            :Elevation of Kelly Bushing Above Permanent Datum
EDF             .m                         9.80            :Elevation of Drill Floor Above Permanent Datum
EGL             .m                      -137.00            :Elevation of Ground Level Above Permanent Datum
ECF             .m                      -999.25            :Elevation of Casing Flange above Permanent Datum
#--------------------------------------------------
~CURVE INFORMATION
#MNEM           .UNIT                  API CODE            :DESCRIPTION
#----            ------          --------------            -----------------------------
TIME_1900       .d                                         :                                                        Time Index(OLE Automation date)
TIME            .s                                         :                                (30s)                   Time(hh mm ss/dd-MMM-yyyy)
ACTC            .                                          :(RT)    (DRILLING_SURFACE)                              Current rig activity
AZIM            .deg                                       :(RT)    (DnMWorkflow)                                   Measured Azimuth
BHD             .m                                         :(RT)    (DRILLING_SURFACE)                              Borehole Depth
BHPR            .psi                                       :(RM)    (Borehole)                                      Borehole Pressure
BHPR            .psi                                       :(RT)    (Borehole)                                      Borehole Pressure
BHRM            .ohm.m                                     :(RM)    (Borehole)                                      Borehole Mud Resistivity
BHRM            .ohm.m                                     :(RT)    (Borehole)                                      Borehole Mud Resistivity
BIT_CONF        .                                          :(RT)    (DRILLING_SURFACE)                              Telemetry Demodulation Bit Confidence
BLKA            .ft/s2                                     :(RT)    (DRILLING_SURFACE)                              Block Acceleration
BLKP            .m                                         :(RT)    (DRILLING_SURFACE)                              Height of block above rig floor
CDEPTH          .m                                         :(RT)    (DRILLING_SURFACE)                              Composite Depth
COBTM           .                                          :(RT)    (DRILLING_SURFACE)                              Composite On Bottom Status
DEPTH           .m                                         :(RT)    (DnMWorkflow)                                   Depth Index
DLS             .deg/100ft                                 :(RT)    (DnMWorkflow)                                   Dog Leg Severity
DRTIME          .h                                         :(RT)    (DRILLING_SURFACE)                              Drilling hours
ED              .m                                         :(RT)    (DnMWorkflow)                                   East Departure
FD_STATUS       .                                          :(RT)    (DRILLING_SURFACE)                              Frame Decoder Status
GTEM            .degC                                      :(RT)    (Borehole)                                      Generalized Borehole Temperature
GTEM            .degC                                      :(RM)    (Borehole)                                      Generalized Borehole Temperature
GTEM_GRDBOTTOM  .degC                                      :(RT)    (Borehole)                                      Borehole Temperature computed as Gradient from Bottom
GTEM_GRDSURF    .degC                                      :(RT)    (Borehole)                                      Borehole Temperature computed as Gradient from Surface
GTEM_LINEST     .degC                                      :(RT)    (Borehole)                                      Borehole Temperature computed as Linear Estimate
HDTH            .m                                         :(RT)    (DnMWorkflow)                                   Hole Depth
HKLA            .1000 lbf                                  :(RT)    (DRILLING_SURFACE)                              Average Hookload
INCL            .deg                                       :(RT)    (DnMWorkflow)                                   Hole inclination
MWTI            .g/cm3                                     :(RT)    (Borehole)                                      Measured density of mud going into hole
ND              .m                                         :(RT)    (DnMWorkflow)                                   North Departure
OBTM            .                                          :        (DnMWorkflow)                                   Status of the drill bit (On Bottom?)
PPTIME          .h                                         :(RT)    (DRILLING_SURFACE)                              Pumping hours
PVEL            .m/h                                       :(RT)    (DRILLING_SURFACE)                              Pipe Velocity
REMS            .ohm.m                                     :(RT)    (Borehole)                                      Mud Resistivity
RIG_ACT_HSPM    .                                          :(RT)    (DRILLING_SURFACE)                              Rig Activity
RIG_STATE_HSPM  .                                          :(RT)    (DRILLING_SURFACE)                              Rig State
ROAZ            .deg                                       :(RT)    (DnMWorkflow)                                   Azimuth from rotary table to target
ROP             .m/h                                       :(RT)    (DRILLING_SURFACE)                              Rate of Penetration
ROP5            .m/h                                       :(RT)    (DRILLING_SURFACE)                              Rate of penetration averaged over the last 5 ft (1.5 m)
ROPH            .m/h                                       :(RT)    (DRILLING_SURFACE)                              Rate of Penetration over the last .5 ft (.15 m)
ROPI            .min/ft                                    :(RT)    (DRILLING_SURFACE)                              Inverse ROP for last 1 ft (.3 m)
RPI5            .min/ft                                    :(RT)    (DRILLING_SURFACE)                              Inverse ROP for last 5 ft (1.5 m) / 5
RPIH            .min/ft                                    :(RT)    (DRILLING_SURFACE)                              Inverse ROP for last .5 ft (.15 m) * 2
RPM             .c/min                                     :(RT)    (DRILLING_SURFACE)                              Rotational Speed
SLIPS           .                                          :(RT)    (DRILLING_SURFACE)                              Status of the Slips (In or Out)
SPM1            .1/min                                     :(RT)    (DRILLING_SURFACE)                              Pump 1 Stroke Rate
SPM2            .1/min                                     :(RT)    (DRILLING_SURFACE)                              Pump 2 Stroke Rate
SPPA            .psi                                       :(RT)    (DRILLING_SURFACE)                              Standpipe Pressure
SPT_1S          .psi                                       :(RT)    (DRILLING_SURFACE)                              Signal Pressure Transducer 1 Signal Strength (Amplitude)
SPT_2S          .psi                                       :(RT)    (DRILLING_SURFACE)                              Signal Pressure Transducer 2 Signal Strength (Amplitude)
STOR            .1000 ft.lbf                               :(RT)    (DRILLING_SURFACE)                              Surface Torque
SWOB            .1000 lbf                                  :(RT)    (DRILLING_SURFACE)                              Surface Weight On Bit
TAS             .                                          :(RT)    (DRILLING_SURFACE)                              Tool active status
TDSP            .m                                         :(RT)    (DnMWorkflow)                                   Total Displacement (of survey measure point from vertical)
TFLO            .gal/min                                   :(RT)    (DRILLING_SURFACE)                              Total flow rate of all active pumps
TS_DIR          .                                          :        (DnMWorkflow)                                   Traveling direction of the tool string
TSI             .                                          :(RT)    (DnMWorkflow)                                   Tool sliding rotating indicator
TSTK            .                                          :(RT)    (DRILLING_SURFACE)                              Total Pump Strokes
TVD             .m                                         :(RT)    (DnMWorkflow)                                   True Vertical Depth
TVDE            .m                                         :(RT)    (DnMWorkflow)                                   True Vertical Depth
TVDSS           .m                                         :(RT)    (DnMWorkflow)                                   Sub-sea TVD  True Vertical Depth measured from Mean Sea Level
VSEC            .m                                         :(RT)    (DnMWorkflow)                                   Vertical Section
ACIE            .                                          :(RM)    (ADN6C)                                         Azimuthal Cosine Integrated Error
ACOF            .                                          :(RM)    (ADN6C)                                         Azimuthal Cosine Offset
ACPK            .                                          :(RM)    (ADN6C)                                         Azimuthal Cosine Peak
ACRI            .                                          :(RM)    (ADN6C)                                         Azimuthal Cosine Raw Input
ADIA            .in                                        :(RM)    (ADN6C)                                         Average Borehole Diameter
AFEM            .                                          :(RM)    (ADN6C)                                         Azimuth Front End Status
ANGX            .deg                                       :(RM)    (ADN6C)                                         Quadrant Calibration Angle
ASIE            .                                          :(RM)    (ADN6C)                                         Azimuthal Sine Integrated Error
ASOF            .                                          :(RM)    (ADN6C)                                         Azimuthal Sine Offset
ASPK            .                                          :(RM)    (ADN6C)                                         Azimuthal Sine Peak
ASRI            .                                          :(RM)    (ADN6C)                                         Azimuthal Sine Raw Input
BHCX            .m                                         :(RM)    (ADN6C)                                         Tool Position In Borehole Centered X Coordinate
BHCY            .m                                         :(RM)    (ADN6C)                                         Tool Position In Borehole Centered Y Coordinate
CC15            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Borehole Centered Caliper Along Axis 1 and 5
CC26            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Borehole Centered Caliper Along Axis 2 and 6
CC37            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Borehole Centered Caliper Along Axis 3 and 7
CC48            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Borehole Centered Caliper Along Axis 4 and 8
CL15            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Caliper Along Axis 1 and 5
CL15            .in                                        :(RT)    (ADN6C)                                         Ultrasonic Caliper Along Axis 1 and 5
CL26            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Caliper Along Axis 2 and 6
CL37            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Caliper Along Axis 3 and 7
CL37            .in                                        :(RT)    (ADN6C)                                         Ultrasonic Caliper Along Axis 3 and 7
CL48            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Caliper Along Axis 4 and 8
CLL2            .1/s                                       :(RM)    (ADN6C)                                         Computed Long Spacing Loop Window 2 Count Rate
CLL3            .1/s                                       :(RM)    (ADN6C)                                         Computed Long Spacing Loop Window 3 Count Rate
CSL2            .1/s                                       :(RM)    (ADN6C)                                         Computed Short Spacing Loop Window 2 Count Rate
CSL3            .1/s                                       :(RM)    (ADN6C)                                         Computed Short Spacing Loop Window 3 Count Rate
DCAV            .in                                        :(RT)    (ADN6C)                                         Density Caliper, Average
DFEM            .                                          :(RM)    (ADN6C)                                         Density Front End Status
DM15            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Tool Delta Movement Along Axis 1 and 5
DM26            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Tool Delta Movement Along Axis 2 and 6
DM37            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Tool Delta Movement Along Axis 3 and 7
DM48            .in                                        :(RM)    (ADN6C)                                         Ultrasonic Tool Delta Movement Along Axis 4 and 8
DRHO_A          .g/cm3                                     :(RT)    (ADN6C)                                         Bulk Density Correction, Computed Downhole
DSAM            .                                          :(RM)    (ADN6C)                                         Density Samples of This Frame, 0.1 ft
EFRA            .%                                         :(RM)    (ADN6C)                                         Echo-Firing Ratio
F11R            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 1 Tube 1 Count Rate
F12R            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 1 Tube 2 Count Rate
F13R            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 1 Tube 3 Count Rate
F21R            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 2 Tube 1 Count Rate
F22R            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 2 Tube 2 Count Rate
F23R            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 2 Tube 3 Count Rate
FAR             .1/s                                       :(RM)    (ADN6C)                                         Average, Far Total Count Rate
FR11            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 1 Tube 1 Count Rate
FR12            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 1 Tube 2 Count Rate
FR13            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 1 Tube 3 Count Rate
FR1B            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 1 Count Rate, Bottom
FR1U            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 1 Count Rate, Up
FR21            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 2 Tube 1 Count Rate
FR22            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 2 Tube 2 Count Rate
FR23            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 2 Tube 3 Count Rate
FR2B            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 2 Count Rate, Bottom
FR2U            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Far Bank 2 Count Rate, Up
HEHV            .V                                         :(RM)    (ADN6C)                                         Helium High Voltage
HORD            .in                                        :(RM)    (ADN6C)                                         Horizontal Hole Diameter
IBT1            .mA                                        :(RM)    (ADN6C)                                         Battery 1 Current
IBT2            .mA                                        :(RM)    (ADN6C)                                         Battery 2 Current
LSHV            .V                                         :(RM)    (ADN6C)                                         High Voltage for Long Spacing Loop
LSL1            .1/s                                       :(RM)    (ADN6C)                                         Long Spacing Loop Window 1 Count Rate
LSL2            .1/s                                       :(RM)    (ADN6C)                                         Long Spacing Loop Window 2 Count Rate
LSL3            .1/s                                       :(RM)    (ADN6C)                                         Long Spacing Loop Window 3 Count Rate
LSL4            .1/s                                       :(RM)    (ADN6C)                                         Long Spacing Loop Window 4 Count Rate
LSW1            .1/s                                       :(RM)    (ADN6C)                                         Raw Long Spacing Window 1 Count Rate
LSW2            .1/s                                       :(RM)    (ADN6C)                                         Long Spacing Window 2
LSW3            .1/s                                       :(RM)    (ADN6C)                                         Raw Long Spacing Window 3 Count Rate
LSW4            .1/s                                       :(RM)    (ADN6C)                                         Long Spacing Window 4
LSW5            .1/s                                       :(RM)    (ADN6C)                                         Raw Long Spacing Window 5 Count Rate
N11R            .1/s                                       :(RM)    (ADN6C)                                         Raw Near Bank 1 Tube 1 Count Rate
N21R            .1/s                                       :(RM)    (ADN6C)                                         Raw Near Bank 2 Tube 1 Count Rate
NEAR            .1/s                                       :(RM)    (ADN6C)                                         Average, Near Total Count Rate
NFEM            .                                          :(RM)    (ADN6C)                                         Neutron Front End Status
NLTV            .V                                         :(RM)    (ADN6C)                                         ADN Low Power Tool Bus Voltage
NR11            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Near Bank 1 Tube 1 Count Rate
NR1B            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Near Bank 1 Count Rate, Bottom
NR1U            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Near Bank 1 Count Rate, Up
NR21            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Near Bank 2 Tube 1 Count Rate
NR2B            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Near Bank 2 Count Rate, Bottom
NR2U            .1/s                                       :(RM)    (ADN6C)                                         Calibrated Near Bank 2 Count Rate, Up
NSAM            .                                          :(RM)    (ADN6C)                                         Neutron Samples of This Frame, 0.1 ft
NSWR            .                                          :(RM)    (ADN6C)                                         ADN Recorded Status Word
P20V            .V                                         :(RM)    (ADN6C)                                         20-volt Power Supply
QCDF            .                                          :(RM)    (ADN6C)                                         Quality Status Word for Ultrasonic Cumulative Distribution Function
RF1B            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 1 Count Rate, Bottom
RF1U            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 1 Count Rate, Up
RF2B            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 2 Count Rate, Bottom
RF2U            .1/s                                       :(RM)    (ADN6C)                                         Raw Far Bank 2 Count Rate, Up
RHOB_A          .g/cm3                                     :(RT)    (ADN6C)                                         Bulk Density, Computed Downhole
RLTM            .s                                         :(RM)    (ADN6C)                                         Real-Time Clock from IMPulse
RN1B            .1/s                                       :(RM)    (ADN6C)                                         Raw Near Bank 1 Count Rate, Bottom
RN1U            .1/s                                       :(RM)    (ADN6C)                                         Raw Near Bank 1 Count Rate, Up
RN2B            .1/s                                       :(RM)    (ADN6C)                                         Raw Near Bank 2 Count Rate, Bottom
RN2U            .1/s                                       :(RM)    (ADN6C)                                         Raw Near Bank 2 Count Rate, Up
RNB1            .1/s                                       :(RM)    (ADN6C)                                         Bank 1 Rejected Noise
RNB2            .1/s                                       :(RM)    (ADN6C)                                         Bank 2 Rejected Noise
RPM             .c/min                                     :(RM)    (ADN6C)                                         Rotational Speed
SHK1            .1/s                                       :(RM)    (ADN6C)                                         Shock Rate, over 50G
SHK2            .1/s                                       :(RM)    (ADN6C)                                         Shock Rate, over 200G
SHKL            .                                          :(RM)    (ADN6C)                                         Tool Shock Level
SHKL_FLOAT      .                                          :(RM)    (ADN6C)                                         Shock Level, Float
SOA1            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 1
SOA2            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 2
SOA3            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 3
SOA4            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 4
SOA5            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 5
SOA6            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 6
SOA7            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 7
SOA8            .in                                        :(RM)    (ADN6C)                                         Average Ultrasonic Standoff For Sector 8
SSHV            .V                                         :(RM)    (ADN6C)                                         High Voltage Output for SS Loop
SSL1            .1/s                                       :(RM)    (ADN6C)                                         Short Spacing Loop Window 1 Count Rate
SSL2            .1/s                                       :(RM)    (ADN6C)                                         Short Spacing Loop Window 2 Count Rate
SSL3            .1/s                                       :(RM)    (ADN6C)                                         Short Spacing Loop Window 3 Count Rate
SSL4            .1/s                                       :(RM)    (ADN6C)                                         Short Spacing Loop Window 4 Count Rate
SSW1            .1/s                                       :(RM)    (ADN6C)                                         Raw Short Spacing Window 1 Count Rate
SSW2            .1/s                                       :(RM)    (ADN6C)                                         Short Spacing Window 2
SSW3            .1/s                                       :(RM)    (ADN6C)                                         Raw Short Spacing Window 3 Count Rate
SSW4            .1/s                                       :(RM)    (ADN6C)                                         Short Spacing Window 4
SSW5            .1/s                                       :(RM)    (ADN6C)                                         Raw Short Spacing Window 5 Count Rate
TICKS_CAL       .                                          :(RM)    (ADN6C)                                         Caliper Tick Marks
TICKS_DEN       .                                          :(RM)    (ADN6C)                                         Density Tick Marks
TICKS_DEN       .                                          :(RT)    (ADN6C)                                         Density Tick Marks
TICKS_NEU       .                                          :(RT)    (ADN6C)                                         Neutron Tick Marks
TICKS_NEU       .                                          :(RM)    (ADN6C)                                         Neutron Tick Marks
TICKS_UWVF      .                                          :(RM)    (ADN6C)                                         Ultrasonic Waveform Tick Marks
TNRA_A          .                                          :(RT)    (ADN6C)                                         Unfiltered Thermal Neutron Ratio
TSTA            .                                          :(RT)    (ADN6C)                                         Tool Status
TTEM            .degC                                      :(RM)    (ADN6C)                                         Tool Temperature
UFEM            .                                          :(RM)    (ADN6C)                                         Ultrasonic Front End Status
UWVF_DET_TIME   .us                                        :(RM)    (ADN6C)                                         Ultrasonic Waveform Detect Time
VERD            .in                                        :(RM)    (ADN6C)                                         Vertical Hole Diameter
A112            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T1 at 2 MHz
A114            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T1 at 400 KHz
A122            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T2 at 2 MHz
A124            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T2 at 400 KHz
A132            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T3 at 2 MHz
A134            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T3 at 400 KHz
A142            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T4 at 2 MHz
A144            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T4 at 400 KHz
A152            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T5 at 2 MHz
A154            .mV                                        :(RM)    (ARC6)                                          Amplitude R1 from T5 at 400 KHz
A16H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity for 16 inch Spacing at 2 MHz
A16L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity 16 inch at 400 KHz
A212            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T1 at 2 MHz
A214            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T1 at 400 KHz
A222            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T2 at 2 MHz
A224            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T2 at 400 KHz
A22H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity for 22 inch Spacing at 2 MHz
A22L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity 22 inch at 400 KHz
A232            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T3 at 2 MHz
A234            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T3 at 400 KHz
A242            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T4 at 2 MHz
A244            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T4 at 400 KHz
A252            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T5 at 2 MHz
A254            .mV                                        :(RM)    (ARC6)                                          Amplitude R2 from T5 at 400 KHz
A28H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity for 28 inch Spacing at 2 MHz
A28L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity 28 inch at 400 KHz
A34H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity for 34 inch Spacing at 2 MHz
A34L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity 34 inch at 400 KHz
A40B_COND_UNC   .mS/m                                      :(RT)    (ARC6)                                          Uncorrected Blended Attenuation Conductivity 40 inch
A40B_UNC        .ohm.m                                     :(RT)    (ARC6)                                          Uncorrected Blended Attenuation Resistivity 40 inch
A40H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity 40 inch at 2 MHz
A40L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Attenuation Resistivity 40 inch at 400 KHz
AO21            .V                                         :(RM)    (ARC6)                                          2MHz Amplitude Offset for R1
AO22            .V                                         :(RM)    (ARC6)                                          2MHz Amplitude Offset for R2
AO41            .V                                         :(RM)    (ARC6)                                          400KHz Amplitude Offset for R1
AO42            .V                                         :(RM)    (ARC6)                                          400KHz Amplitude Offset for R2
ARVN_ARC        .V                                         :(RM)    (ARC6)                                          ARC Negative Analog Voltage
ARVP_ARC        .V                                         :(RM)    (ARC6)                                          ARC Positive Analog Voltage
AT12            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T1 at 2 MHz
AT14            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T1 at 400 KHz
AT16H           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 16-in. at 2 MHz
AT16L           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 16-in. at 400 KHz
AT22            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T2 at 2 MHz
AT22H           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 22-in. at 2 MHz
AT22L           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 22-in. at 400 KHz
AT24            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T2 at 400 KHz
AT28H           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 28-in. at 2 MHz
AT28L           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 28-in. at 400 KHz
AT32            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T3 at 2 MHz
AT34            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T3 at 400 KHz
AT34H           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 34-in. at 2 MHz
AT34L           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 34-in. at 400 KHz
AT40H           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 40-in. at 2 MHz
AT40L           .dB                                        :(RM)    (ARC6)                                          Compensated Attenuation for 40-in. at 400 KHz
AT42            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T4 at 2 MHz
AT44            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T4 at 400 KHz
AT52            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T5 at 2 MHz
AT54            .dB                                        :(RM)    (ARC6)                                          Raw Attenuation for T5 at 400 KHz
BATI            .A                                         :(RM)    (ARC6)                                          Battery Current
BATV            .V                                         :(RM)    (ARC6)                                          Battery Voltage
DHAP            .psi                                       :(RM)    (ARC6)                                          Downhole Annulus Pressure
DHAP            .psi                                       :(RT)    (ARC6)                                          Downhole Annulus Pressure
DHAT            .degC                                      :(RT)    (ARC6)                                          Downhole Annulus Temperature
DHAT            .degC                                      :(RM)    (ARC6)                                          Downhole Annulus Temperature
ECD             .g/cm3                                     :(RM)    (ARC6)                                          Equivalent Circulating Density
ECD             .g/cm3                                     :(RT)    (ARC6)                                          Equivalent Circulating Density
ESD             .g/cm3                                     :(RT)    (ARC6)                                          Equivalent Static Density
ESD_MAX         .g/cm3                                     :(RT)    (ARC6)                                          Maximum Equivalent Static Density
ESD_MIN         .g/cm3                                     :(RT)    (ARC6)                                          Mininum Equivalent Static Density
GRHV            .V                                         :(RM)    (ARC6)                                          SUB Gamma Ray High Voltage
GRR             .1/s                                       :(RM)    (ARC6)                                          Raw Gamma Ray
ORION_RA40B     .                                          :(RT)    (ARC6)                                          Orion-compressed Flag, Attenuation Res, 40 in, Blended
P112            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T1 at 2 MHz
P114            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T1 at 400 KHz
P122            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T2 at 2 MHz
P124            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T2 at 400 KHz
P132            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T3 at 2 MHz
P134            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T3 at 400 KHz
P142            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T4 at 2 MHz
P144            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T4 at 400 KHz
P152            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T5 at 2 MHz
P154            .deg                                       :(RM)    (ARC6)                                          Phase R1 from T5 at 400 KHz
P16H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity for 16 inch Spacing at 2 MHz
P16L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity 16 inch at 400 KHz
P212            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T1 at 2 MHz
P214            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T1 at 400 KHz
P222            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T2 at 2 MHz
P224            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T2 at 400 KHz
P22H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity for 22 inch Spacing at 2 MHz
P22L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity 22 inch at 400 KHz
P232            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T3 at 2 MHz
P234            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T3 at 400 KHz
P242            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T4 at 2 MHz
P244            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T4 at 400 KHz
P252            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T5 at 2 MHz
P254            .deg                                       :(RM)    (ARC6)                                          Phase R2 from T5 at 400 KHz
P28H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity for 28 inch Spacing at 2 MHz
P28L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity 28 inch at 400 KHz
P34H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity for 34 inch Spacing at 2 MHz
P34L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity 34 inch at 400 KHz
P40H_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity 40 inch at 2 MHz
P40L_UNC        .ohm.m                                     :(RM)    (ARC6)                                          Uncorrected Phase Shift Resistivity 40 inch at 400 KHz
PESD            .psi                                       :(RT)    (ARC6)                                          Hydrostatic pressure (ESD)
PMAT            .h                                         :(RT)    (ARC6)                                          Time between when PMAX measured and data transmitted up hole.
PMAX            .psi                                       :(RT)    (ARC6)                                          Maximum Pressure (Delta from PESD)
PMIN            .psi                                       :(RT)    (ARC6)                                          Minimum Pressure (Delta from PESD)
PMIT            .h                                         :(RT)    (ARC6)                                          Time between when PMIN measured and data transmitted up hole.
PS12            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T1 at 2 MHz
PS14            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T1 at 400 KHz
PS16H           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 16-in. at 2 MHz
PS16L           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 16-in. at 400 KHz
PS22            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T2 at 2 MHz
PS22H           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 22-in. at 2 MHz
PS22L           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 22-in. at 400 KHz
PS24            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T2 at 400 KHz
PS28H           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 28-in. at 2 MHz
PS28L           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 28-in. at 400 KHz
PS32            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T3 at 2 MHz
PS34            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T3 at 400 KHz
PS34H           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 34-in. at 2 MHz
PS34L           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 34-in. at 400 KHz
PS40H           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 40-in. at 2 MHz
PS40L           .deg                                       :(RM)    (ARC6)                                          Compensated Phase-Shift for 40-in. at 400 KHz
PS42            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T4 at 2 MHz
PS44            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T4 at 400 KHz
PS52            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T5 at 2 MHz
PS54            .deg                                       :(RM)    (ARC6)                                          Raw Phase Shift for T5 at 400 KHz
PSDT            .h                                         :(RT)    (ARC6)                                          Time between when PESD measured and data transmitted up hole.
RGR             .gAPI                                      :(RM)    (ARC6)                                          Raw Gamma Ray
SHKL            .                                          :(RM)    (ARC6)                                          Tool Shock Level
SHKL_FLOAT      .                                          :(RM)    (ARC6)                                          Shock Level, Float
SHKR            .1/s                                       :(RM)    (ARC6)                                          Shock Rate
TICKS_GR        .                                          :(RM)    (ARC6)                                          Gamma Ray Tick Marks
TICKS_PRES      .                                          :(RM)    (ARC6)                                          Pressure Tick Marks
TICKS_RES       .                                          :(RM)    (ARC6)                                          Resistivity Tick Marks
TSTA            .                                          :(RM)    (ARC6)                                          Tool Status
TSTA            .                                          :(RT)    (ARC6)                                          Tool Status
TSTA_FLOAT      .                                          :(RM)    (ARC6)                                          Tool Status (float)
TTEM            .degC                                      :(RM)    (ARC6)                                          Tool Temperature
AJAM            .                                          :(RT)    (TELE675)                                       Number of Anti-Jams Detected
AJAM            .                                          :(RM)    (TELE675)                                       Number of Anti-Jams Detected
AZIM_EU         .deg                                       :(RT)    (TELE675)                                       EU Converted Downhole-calculated Azimuth
BX_ROT          .nT                                        :(RM)    (TELE675)                                       Rotating Magnetometer, X-Axis
BY_ROT          .nT                                        :(RM)    (TELE675)                                       Non-Stationary Magnetometer, Y-Axis
BZ_ROT          .nT                                        :(RM)    (TELE675)                                       Non-Stationary Magnetometer, Z-Axis
CALST           .                                          :(RM)    (TELE675)                                       Calibration Status
CRPM            .c/min                                     :(RM)    (TELE675)                                       Collar Rotational Speed
CRPM            .c/min                                     :(RT)    (TELE675)                                       Collar Rotational Speed
CUREDT          .h                                         :(RT)    (TELE675)                                       Current Equivalent Drilling Time in 10 Hours
CURFSL          .                                          :(RT)    (TELE675)                                       Current Frame Set List
DEPTH_DNI       .m                                         :(RT)    (TELE675)                                       Depth of the Direction and Inclination Sensor
DSPSTAT         .                                          :(RM)    (TELE675)                                       DSP Status Word
DTOR_EU         .1000 ft.lbf                               :(RM)    (TELE675)                                       Uncorrected Downhole Torque in Engineering Units
DWOB_EU         .1000 lbf                                  :(RM)    (TELE675)                                       Uncorrected Downhole Weight on Bit in Engineering Units
GAMMA_10        .1/s                                       :(RM)    (TELE675)                                       Raw Gamma Ray Counts Per Second
GAMMA_CPS       .1/s                                       :(RM)    (TELE675)                                       Raw Gamma Ray Counts Per Second
GAMMA_EXT       .1/s                                       :(RM)    (TELE675)                                       Raw Gamma Ray Counts Per Second
GEN2            .                                          :(RM)    (TELE675)                                       Generic 2
GEN3            .                                          :(RM)    (TELE675)                                       Generic 3
GEN4            .                                          :(RM)    (TELE675)                                       Generic 4
GEN5            .                                          :(RM)    (TELE675)                                       Generic 5
GTF             .deg                                       :(RT)    (TELE675)                                       Gravity Toolface Angle
GTF             .deg                                       :(RM)    (TELE675)                                       Gravity Toolface Angle
GX_ROT          .ft/s2                                     :(RM)    (TELE675)                                       Continuous Rotational Gravity X-axis
GX_TEMP         .degC                                      :(RM)    (TELE675)                                       X-Axis Accelerometer Temperature
GY_ROT          .ft/s2                                     :(RM)    (TELE675)                                       Non-Stationary Accelerometer, Y-Axis
GY_TEMP         .degC                                      :(RM)    (TELE675)                                       Y-Axis Accelerometer Temperature
GZ_ROT          .ft/s2                                     :(RM)    (TELE675)                                       Non-Stationary Accelerometer, Z-Axis
GZ_TEMP         .degC                                      :(RM)    (TELE675)                                       Z-Axis Accelerometer Temperature
HSTEMP          .degC                                      :(RM)    (TELE675)                                       Heat Sink Temperature
HTEMP           .degC                                      :(RM)    (TELE675)                                       Magnetometer Temperature
HWD_ERR         .                                          :(RM)    (TELE675)                                       Hardware Error
IMOTOR          .A                                         :(RM)    (TELE675)                                       Motor Current
INCL_EU         .deg                                       :(RT)    (TELE675)                                       EU Converted Downhole-calculated Inclination
LTB_STAT        .                                          :(RM)    (TELE675)                                       Low Power Tool Bus (LTB) Status
LTBRT           .                                          :(RM)    (TELE675)                                       Low Power Tool Bus (LTB) Retries
MOT_DERR        .                                          :(RM)    (TELE675)                                       Motor Device Error
MOT_STATUS      .                                          :(RM)    (TELE675)                                       Motor Status
MTF             .deg                                       :(RT)    (TELE675)                                       Magnetic Toolface Angle
MTF             .deg                                       :(RM)    (TELE675)                                       Magnetic Toolface Angle
MWDSTAT         .                                          :(RM)    (TELE675)                                       MWD Status Word
NGX             .deg                                       :(RM)    (TELE675)                                       Angle X is the angle measured clockwise looking downhole from the projection of gravity to the projection of the magnetic field in the plane perpendicular to the tool axis
NRPM            .                                          :(RM)    (TELE675)                                       Negative Rotation Indicator
NRPM            .                                          :(RT)    (TELE675)                                       Negative Rotation Indicator
PUPGEN1         .                                          :(RM)    (TELE675)                                       TeleScope Generic 1
PUPGEN2         .                                          :(RM)    (TELE675)                                       TeleScope Generic 2
PUPSTAT         .                                          :(RM)    (TELE675)                                       TeleScope System Status
PUPSTAT2        .                                          :(RM)    (TELE675)                                       TeleScope System Status 2
SBX             .nT                                        :(RM)    (TELE675)                                       Magnetic X-Axis Reading, Stationary
SBX             .nT                                        :(RT)    (TELE675)                                       Magnetic X-Axis Reading, Stationary
SBY             .nT                                        :(RT)    (TELE675)                                       Magnetic Y-Axis Reading, Stationary
SBY             .nT                                        :(RM)    (TELE675)                                       Magnetic Y-Axis Reading, Stationary
SBZ             .nT                                        :(RT)    (TELE675)                                       Magnetic Z-Axis Reading, Stationary
SBZ             .nT                                        :(RM)    (TELE675)                                       Magnetic Z-Axis Reading, Stationary
SENST           .                                          :(RM)    (TELE675)                                       Direction and Inclination Sensor Status
SGX             .ft/s2                                     :(RT)    (TELE675)                                       Gravity X-Axis Reading, Stationary
SGX             .ft/s2                                     :(RM)    (TELE675)                                       Gravity X-Axis Reading, Stationary
SGY             .ft/s2                                     :(RM)    (TELE675)                                       Gravity Y-Axis Reading, Stationary
SGY             .ft/s2                                     :(RT)    (TELE675)                                       Gravity Y-Axis Reading, Stationary
SGZ             .ft/s2                                     :(RM)    (TELE675)                                       Gravity Z-Axis Reading, Stationary
SGZ             .ft/s2                                     :(RT)    (TELE675)                                       Gravity Z-Axis Reading, Stationary
SHK125          .                                          :(RM)    (TELE675)                                       Shocks Above 125G
SHK250          .                                          :(RM)    (TELE675)                                       Shocks Above 250G
SHK3TIME        .min                                       :(RM)    (TELE675)                                       Time at Shock Level 3
SHK3TIME        .min                                       :(RT)    (TELE675)                                       Time at Shock Level 3
SHK50           .                                          :(RM)    (TELE675)                                       Shocks Above 50G
SHKPK           .ft/s2                                     :(RM)    (TELE675)                                       Shock Peak
SHKPK           .ft/s2                                     :(RT)    (TELE675)                                       Shock Peak
SHKR            .1/s                                       :(RM)    (TELE675)                                       Shock Rate
SHKR            .1/s                                       :(RT)    (TELE675)                                       Shock Rate
SHKRSK          .                                          :(RT)    (TELE675)                                       Shock Risk
SHKRSK          .                                          :(RM)    (TELE675)                                       Shock Risk
SHOCK_RAW       .                                          :(RM)    (TELE675)                                       Combined Shock Risk and Shock Peak
SHOCKS_ACC      .                                          :(RT)    (TELE675)                                       Total Shocks accumulated over tool lifetime
SHOCKS_ACC      .                                          :(RM)    (TELE675)                                       Total Shocks accumulated over tool lifetime
STICK           .c/min                                     :(RT)    (TELE675)                                       Stick Slip Indicator
STICK           .c/min                                     :(RM)    (TELE675)                                       Stick Slip Indicator
STUCK           .                                          :(RT)    (TELE675)                                       Percent Time Stuck Below 5 RPM Indicator
STUCK           .                                          :(RM)    (TELE675)                                       Percent Time Stuck Below 5 RPM Indicator
TEMP_DNI        .degC                                      :(RM)    (TELE675)                                       Direction and Inclination Sensor Temperature
TEMP_DNI        .degC                                      :(RT)    (TELE675)                                       Direction and Inclination Sensor Temperature
TRPM            .c/min                                     :(RM)    (TELE675)                                       MWD Turbine Rotation Speed
TRPM            .c/min                                     :(RT)    (TELE675)                                       MWD Turbine Rotation Speed
TSHK            .                                          :(RM)    (TELE675)                                       Total shocks over some threshold this run
TSHK            .                                          :(RT)    (TELE675)                                       Total shocks over some threshold this run
TSTA            .                                          :(RT)    (TELE675)                                       Tool Status
VDC             .V                                         :(RM)    (TELE675)                                       Voltage of the DC Bus
VIB_LAT         .ft/s2                                     :(RM)    (TELE675)                                       Transverse RMS Vibration
VIB_LAT         .ft/s2                                     :(RT)    (TELE675)                                       Transverse RMS Vibration
VIB_TOR         .ft.lbf                                    :(RM)    (TELE675)                                       Torsional RMS Vibration
VIB_X           .ft/s2                                     :(RT)    (TELE675)                                       RMS Vibration, X-Axis
VIB_X           .ft/s2                                     :(RM)    (TELE675)                                       RMS Vibration, X-Axis
VIB_Y           .ft/s2                                     :(RM)    (TELE675)                                       RMS Vibration, Y-Axis
VIB_Z           .ft/s2                                     :(RM)    (TELE675)                                       RMS Vibration, Z-Axis
#-------------------------------------------------------------
#       TIME_1900                 TIME           ACTC           AZIM            BHD           BHPR           BHPR           BHRM           BHRM       BIT_CONF           BLKA           BLKP         CDEPTH          COBTM          DEPTH            DLS         DRTIME             ED      FD_STATUS           GTEM           GTEM GTEM_GRDBOTTOM   GTEM_GRDSURF    GTEM_LINEST           HDTH           HKLA           INCL           MWTI             ND           OBTM         PPTIME           PVEL           REMS   RIG_ACT_HSPM RIG_STATE_HSPM           ROAZ            ROP           ROP5           ROPH           ROPI           RPI5           RPIH            RPM          SLIPS           SPM1           SPM2           SPPA         SPT_1S         SPT_2S           STOR           SWOB            TAS           TDSP           TFLO         TS_DIR            TSI           TSTK            TVD           TVDE          TVDSS           VSEC           ACIE           ACOF           ACPK           ACRI           ADIA           AFEM           ANGX           ASIE           ASOF           ASPK           ASRI           BHCX           BHCY           CC15           CC26           CC37           CC48           CL15           CL15           CL26           CL37           CL37           CL48           CLL2           CLL3           CSL2           CSL3           DCAV           DFEM           DM15           DM26           DM37           DM48         DRHO_A           DSAM           EFRA           F11R           F12R           F13R           F21R           F22R           F23R            FAR           FR11           FR12           FR13           FR1B           FR1U           FR21           FR22           FR23           FR2B           FR2U           HEHV           HORD           IBT1           IBT2           LSHV           LSL1           LSL2           LSL3           LSL4           LSW1           LSW2           LSW3           LSW4           LSW5           N11R           N21R           NEAR           NFEM           NLTV           NR11           NR1B           NR1U           NR21           NR2B           NR2U           NSAM           NSWR           P20V           QCDF           RF1B           RF1U           RF2B           RF2U         RHOB_A           RLTM           RN1B           RN1U           RN2B           RN2U           RNB1           RNB2            RPM           SHK1           SHK2           SHKL     SHKL_FLOAT           SOA1           SOA2           SOA3           SOA4           SOA5           SOA6           SOA7           SOA8           SSHV           SSL1           SSL2           SSL3           SSL4           SSW1           SSW2           SSW3           SSW4           SSW5      TICKS_CAL      TICKS_DEN      TICKS_DEN      TICKS_NEU      TICKS_NEU     TICKS_UWVF         TNRA_A           TSTA           TTEM           UFEM  UWVF_DET_TIME           VERD           A112           A114           A122           A124           A132           A134           A142           A144           A152           A154       A16H_UNC       A16L_UNC           A212           A214           A222           A224       A22H_UNC       A22L_UNC           A232           A234           A242           A244           A252           A254       A28H_UNC       A28L_UNC       A34H_UNC       A34L_UNC  A40B_COND_UNC       A40B_UNC       A40H_UNC       A40L_UNC           AO21           AO22           AO41           AO42       ARVN_ARC       ARVP_ARC           AT12           AT14          AT16H          AT16L           AT22          AT22H          AT22L           AT24          AT28H          AT28L           AT32           AT34          AT34H          AT34L          AT40H          AT40L           AT42           AT44           AT52           AT54           BATI           BATV           DHAP           DHAP           DHAT           DHAT            ECD            ECD            ESD        ESD_MAX        ESD_MIN           GRHV            GRR    ORION_RA40B           P112           P114           P122           P124           P132           P134           P142           P144           P152           P154       P16H_UNC       P16L_UNC           P212           P214           P222           P224       P22H_UNC       P22L_UNC           P232           P234           P242           P244           P252           P254       P28H_UNC       P28L_UNC       P34H_UNC       P34L_UNC       P40H_UNC       P40L_UNC           PESD           PMAT           PMAX           PMIN           PMIT           PS12           PS14          PS16H          PS16L           PS22          PS22H          PS22L           PS24          PS28H          PS28L           PS32           PS34          PS34H          PS34L          PS40H          PS40L           PS42           PS44           PS52           PS54           PSDT            RGR           SHKL     SHKL_FLOAT           SHKR       TICKS_GR     TICKS_PRES      TICKS_RES           TSTA           TSTA     TSTA_FLOAT           TTEM           AJAM           AJAM        AZIM_EU         BX_ROT         BY_ROT         BZ_ROT          CALST           CRPM           CRPM         CUREDT         CURFSL      DEPTH_DNI        DSPSTAT        DTOR_EU        DWOB_EU       GAMMA_10      GAMMA_CPS      GAMMA_EXT           GEN2           GEN3           GEN4           GEN5            GTF            GTF         GX_ROT        GX_TEMP         GY_ROT        GY_TEMP         GZ_ROT        GZ_TEMP         HSTEMP          HTEMP        HWD_ERR         IMOTOR        INCL_EU       LTB_STAT          LTBRT       MOT_DERR     MOT_STATUS            MTF            MTF        MWDSTAT            NGX           NRPM           NRPM        PUPGEN1        PUPGEN2        PUPSTAT       PUPSTAT2            SBX            SBX            SBY            SBY            SBZ            SBZ          SENST            SGX            SGX            SGY            SGY            SGZ            SGZ         SHK125         SHK250       SHK3TIME       SHK3TIME          SHK50          SHKPK          SHKPK           SHKR           SHKR         SHKRSK         SHKRSK      SHOCK_RAW     SHOCKS_ACC     SHOCKS_ACC          STICK          STICK          STUCK          STUCK       TEMP_DNI       TEMP_DNI           TRPM           TRPM           TSHK           TSHK           TSTA            VDC        VIB_LAT        VIB_LAT        VIB_TOR          VIB_X          VIB_X          VIB_Y          VIB_Z 
#                                       (DRILLING_SU)  (DnMWorkflow)  (DRILLING_SU)     (Borehole)     (Borehole)     (Borehole)     (Borehole)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DnMWorkflow)  (DnMWorkflow)  (DRILLING_SU)  (DnMWorkflow)  (DRILLING_SU)     (Borehole)     (Borehole)     (Borehole)     (Borehole)     (Borehole)  (DnMWorkflow)  (DRILLING_SU)  (DnMWorkflow)     (Borehole)  (DnMWorkflow)  (DnMWorkflow)  (DRILLING_SU)  (DRILLING_SU)     (Borehole)  (DRILLING_SU)  (DRILLING_SU)  (DnMWorkflow)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DRILLING_SU)  (DnMWorkflow)  (DRILLING_SU)  (DnMWorkflow)  (DnMWorkflow)  (DRILLING_SU)  (DnMWorkflow)  (DnMWorkflow)  (DnMWorkflow)  (DnMWorkflow)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)        (ADN6C)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)         (ARC6)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675)      (TELE675) 
#                                                (RT)           (RT)           (RT)           (RM)           (RT)           (RM)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RM)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)                          (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RT)                          (RT)           (RT)           (RT)           (RT)           (RT)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RT)           (RM)           (RM)           (RT)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RT)           (RM)           (RM)           (RT)           (RT)           (RT)           (RT)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RT)           (RT)           (RT)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RT)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RT)           (RT)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RM)           (RM)           (RM)           (RT)           (RT)           (RM)           (RT)           (RM)           (RM)           (RT)           (RM)           (RM)           (RT)           (RM)           (RT)           (RM)           (RM)           (RM)           (RT)           (RM)           (RM)           (RT)           (RM)           (RT)           (RT)           (RM)           (RM)           (RT)           (RM)           (RT)           (RM)           (RT)           (RM)           (RM)           (RT)           (RM)           (RT)           (RM)           (RT)           (RT)           (RM)           (RM)           (RT)           (RM)           (RT)           (RM)           (RM)           (RM) 
#                                (30s)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
~ASCII
 40622.1875000000 04:30:00/20-Mar-2011        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1963.00000     2033.00000       12.00000     2027.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       16.00000     2087.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      227.20000       88.40000     1338.14000        1.99000       16.78000       15.58000        0.99000        8.83000       68.17000       49.17000       42.33000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000        -999.25        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        7.39000       84.32000       75.33000        5.19000      103.00000      277.00000      432.00000      228.00000        1.19000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3485.81800     3433.97900     1129.61600     1307.85100     3812.67700     2888.23400      247.79600       90.76416     3782.13900     3431.21700        -999.25        -999.25     1706.49200     1648.93200     3586.15900     2424.44300        -999.25        -999.25     2088.21300     1530.85600      302.53570       85.79285     2063.61100     1859.87800        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00015        0.00015        0.00013        0.00012       -9.94000        9.81200        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.24080       18.54600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.39000        -999.25      170.97910       21.10668      219.83340      423.05930      234.85690       27.70197       16.78728      217.23930      275.42220      397.60830        -999.25        -999.25      538.48810      382.93350      164.19850       49.02050        -999.25        -999.25      233.11580      387.47080      413.43240      238.58310      270.98330       37.17204        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1878472222 04:30:30/20-Mar-2011        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1963.00000     2033.00000       12.00000     2041.00000        -999.25        0.00000        -999.25     1937.00000     2086.00000       15.00000     2095.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.40000     1338.14000        1.80000       20.80000       13.80000        0.80000        8.60000       62.20000       47.40000       41.00000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000        -999.25        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.00000       82.60000       82.00000        6.00000      104.00000      294.00000      465.00000      223.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3397.40700     3348.40700     1621.16500     1457.90200     3934.53300     3015.99500       86.23779       27.30499     3806.42800     3567.13200        -999.25        -999.25     1766.15700     1701.30300     3024.88000     2296.73600        -999.25        -999.25     2122.66100     1592.29600      137.15610       18.85773     2064.44500     1915.44600        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00016        0.00014        0.00012        0.00011       -9.94000        9.81200        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.23420       18.50200        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.53000        -999.25      179.61540       22.92855      211.26870      418.24010      232.41470       27.02151       23.03138      213.09610      273.38800      397.00980        -999.25        -999.25      181.53290      383.30560      182.78850       54.24652        -999.25        -999.25      230.80090      386.70880      437.68430      263.43990      270.26330       36.73577        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1881944444 04:31:00/20-Mar-2011        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1963.00000     2032.00000       12.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2086.00000       13.00000     2095.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.40000     1338.14000        0.99000       17.98000       15.58000        0.79000        6.33000       69.00000       52.17000       46.50000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000        -999.25        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.18000       80.33000       75.13000        5.39000      106.00000      285.00000      448.00000      226.00000        1.39000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3372.53100     3273.05100     1659.28900     1470.23400     3957.79600     3029.92600       74.49707        7.32483     3842.62600     3590.00000        -999.25        -999.25     1767.78700     1696.92900     2881.47800     2153.06300        -999.25        -999.25     2132.78100     1601.67200      113.41920        5.46906     2083.16100     1925.79400        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00016        0.00014        0.00012        0.00012       -9.94000        9.81200        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.24660       18.55700        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.03000        -999.25      180.60030       23.77128      212.01040      418.11720      231.54060       26.91661       21.47766      204.72010      271.92000      396.76140        -999.25        -999.25      181.58640      383.61150      187.17910       58.47789        -999.25        -999.25      229.84150      386.51890      436.13210      344.95540      269.05650       36.50274        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1885416667 04:31:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       15.21584       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.55367        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85670        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       13.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2089.00000       15.00000     2090.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.19940       16.60060       72.26540       73.93460        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        1.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.20000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.40000     1338.14000        2.80000       15.40000       22.00000        1.20000        6.80000       69.60000       53.80000       42.40000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.20000        0.20000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.20000       89.80000       77.80000        7.60000      105.00000      280.00000      431.00000      225.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3395.20200     3603.63300     2504.66900     1685.51600     3604.26800     3027.98300      161.33580       80.77606     3794.98100     3574.81700      200.00000      200.00000     1910.45800     1952.66100     3463.50200     2338.86600      300.00000      300.00000     2051.48700     1665.70700      213.36210      114.07230     2168.05200     1981.34100      500.00000      500.00000      500.00000      500.00000        -999.25        -999.25      700.00000        2.59240        0.00016        0.00015        0.00012        0.00012       -9.94000        9.81200        4.99534        5.32717        4.03199        4.23415        2.76214        3.93038        4.11532        2.81893        3.75261        4.06596        4.89123        5.18553        3.61366        4.05555        3.58969        4.01464        2.30436        2.91856        4.86035        5.12476        0.24100       18.53500        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.36000        -999.25      190.09430       25.57854      199.72490      407.44470      242.47210       29.33512      195.86410       39.86953      271.79920      395.36680        4.52876     5000.00000      190.40130      384.73830      185.06900       50.49232        5.91028     5000.00000      241.55840      388.38140      539.68100      405.11940      270.66820       34.61762        6.89987     5000.00000        7.36504     5000.00000        8.18475     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.32741       -0.82173        7.63517       -2.10418       14.39743        7.05650       -2.13252       -3.35109        6.97630       -2.60334       -0.90430       -0.93724        7.14657       -3.02233        7.06886       -2.94700       15.17883       -5.23425       -1.08472       -0.74394        -999.25        6.04800        0.00000        0.00000        0.00000        1.00000        -999.25        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1888888889 04:32:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       15.21584       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.46698        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85567        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       12.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2086.00000       13.00000     2089.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       13.45620       14.72380       65.07180       75.20820        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        5.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.39000       15.38000       16.18000        0.99000        8.66000       63.67000       50.33000       42.00000        0.59000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.79000       74.33000       82.93000        6.19000      105.00000      296.00000      460.00000      227.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3360.63800     3600.58900     2474.86900     1671.51800     3550.40600     3025.12400      166.60340       83.07404     3722.26700     3570.43300      200.00000      200.00000     1891.58000     1950.51200     3416.98900     2318.17600      300.00000      300.00000     2021.25700     1664.74600      219.36710      117.41880     2126.96000     1978.97900      500.00000      500.00000      500.00000      500.00000        -999.25        -999.25      700.00000        2.29005        0.00016        0.00014        0.00012        0.00012       -9.95000        9.81200        4.99194        5.32450        4.04880        4.24244        2.80183        3.94985        4.12613        2.84071        3.78483        4.09431        4.89313        5.18790        3.65699        4.09980        3.63237        4.05812        2.38975        3.00545        4.86096        5.12560        0.23380       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      191.09220       25.87625      199.30250      407.47930      243.85170       29.75198      194.93230       39.41940      273.26250      395.92350        4.53811     5000.00000      191.44210      385.04710      184.94910       50.64833        5.92263     5000.00000      242.97170      388.80760      539.77700      404.77800      272.14430       35.20552        6.90695     5000.00000        7.38713     5000.00000        8.26414     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.34990       -0.82909        7.62393       -2.01689       14.35338        7.04618       -2.04513       -3.16905        6.97156       -2.59249       -0.87996       -0.94439        7.13249       -3.07979        7.02588       -2.98790       15.15524       -5.35858       -1.11820       -0.71797        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1892361111 04:32:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.01990       15.22069       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.29879        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86948        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       14.00000     2030.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       14.00000     2088.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.13300       16.06700       66.79780       72.20220        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       11.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.40000     1338.14000        2.40000       17.20000       17.80000        1.40000        8.20000       68.20000       49.60000       44.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.80000       76.40000       79.60000        5.20000      104.00000      292.00000      442.00000      216.00000        1.20000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3363.39600     3614.93000     2472.54100     1696.99300     3555.69000     3018.48300      159.26820      101.86070     3763.92700     3525.22800      200.00000      200.00000     1893.97500     1958.15200     3440.21500     2389.26000      300.00000      300.00000     2024.36700     1666.28500      213.07280      150.06530     2151.03500     1967.45800      500.00000      500.00000      500.00000      500.00000        -999.25        -999.25       55.02427        1.62695        0.00015        0.00014        0.00012        0.00012       -9.94000        9.81200        4.98808        5.32507        4.07952        4.31512        2.86884        3.98228        4.18498        2.97167        3.83593        4.20350        4.89269        5.16079        3.72572        4.25804        3.70078        4.19994        2.52798        3.36548        4.85988        5.06563        0.24240       18.53500        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.36000        -999.25      191.31370       25.84081      199.60560      406.60450      244.13730       29.77935      195.59590       39.88229      273.34010      395.54850        4.45654     5000.00000      191.64000      385.04420      185.04090       49.10789        5.81842     5000.00000      243.21150      388.84350      539.65410      402.70750      272.19340       34.76744        6.58191     5000.00000        6.82818     5000.00000        7.59775     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.32631       -0.79665        7.72331       -1.66186       14.56464        7.13446       -1.70204       -2.50337        7.19811       -1.78846       -0.92577       -0.93584        7.50721       -1.82675        7.40925       -1.77069       15.94183       -2.82522       -1.14670       -0.78108        -999.25        6.52800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1895833333 04:33:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.08833       19.15273       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      112.99822        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85387        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2031.00000       13.00000     2036.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       13.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.78960       16.19040       70.87727       67.21273        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       17.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.40000     1338.14000        1.79000       17.18000       17.18000        0.59000        9.66000       64.00000       43.00000       46.00000        0.59000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.18000       80.33000       73.93000        3.99000      101.00000      286.00000      440.00000      213.00000        1.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3734.25900     2253.06300     1742.48900     1195.22200     3673.98500     1426.04900     1210.65500      331.80390     3238.19200     1166.77000        8.09520        2.14747     1330.63900      809.04660     3652.02700     2501.85500        9.27778        2.46782     1912.13600      748.93860     2132.50700      575.71900     1973.71800      717.31170        7.24828        1.91088        6.13765        1.61982        -999.25        -999.25        6.57873        1.72859        0.00015        0.00014        0.00012        0.00013       -9.94000        9.81200        8.96289        8.89600        8.64493        8.60738        6.42728        6.95012        6.90826        6.41628        5.71273        5.63641        5.67237        5.59376        4.97547        4.86682        4.28093        4.17219        4.91741        4.78658        4.30035        4.22555        0.24800       18.52400        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        6.13000        -999.25      124.68680        9.28026      501.09870      376.39580      132.02520        8.17388      130.13240       13.98519      504.04700      381.77070     2352.03400     1939.31600      483.36670      370.64870      139.72230       17.71513     5000.00000      335.98090      490.61890      369.58880      488.68600      375.25360      142.65680       23.11079     3229.72000      213.09070     1934.20000      280.18010     1890.07300     1366.49200        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32018        1.36839        0.01446       -0.03374        1.37637        0.00857        0.01893       -1.31932        0.03691        0.07213       -1.40633        1.41489        0.07848        0.06962        0.09905        0.01090        1.44640       -1.26841       -1.39018        1.34007        -999.25       29.42400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1899305556 04:33:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.45810       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.06519        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.89096        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       13.00000     2038.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       15.00000     2081.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       13.73320       14.46680       66.33060       66.06940        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       23.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      224.80000       89.40000     1338.14000        2.20000       15.80000       16.40000        1.80000        7.60000       63.80000       47.00000       49.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.80000       76.40000       73.40000        4.60000      108.00000      295.00000      461.00000      215.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3750.74400     2262.48400     1957.55500     1308.39400     3738.47300     1447.93700     2516.62900      550.55630     3359.46500     1204.53800       47.42076       18.87998     1350.70600      818.69960     3937.92700     2649.86100       60.76476       43.05357     1984.60300      773.59410     3980.48000      876.38520     2106.12800      759.70090       68.13447     5000.00000       74.77792     5000.00000        -999.25        -999.25       81.41439       87.50427        0.00016        0.00014        0.00012        0.00012       -9.94000        9.80100        8.87113        8.82922        8.44100        8.45126        6.07107        6.70609        6.71101        6.12969        5.30393        5.30307        5.50041        5.44473        4.40378        4.39970        3.67290        3.66860        3.98233        4.03787        4.05571        4.00356        0.24220       18.56800        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        5.53000        -999.25      124.68960        9.28300      501.01520      376.18730      132.01160        8.14532      128.98320       12.42037      504.01840      381.72480     5000.00000     5000.00000      483.36510      370.65330      139.66500       17.58549     5000.00000     5000.00000      490.62300      369.50850      487.67060      373.88130      142.60820       23.09145     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32447        1.37029       -0.00633       -0.05883        1.35013       -0.00118       -0.03296       -1.39821        0.00580       -0.02158       -1.38854        1.36320        0.01102       -0.03292        0.01267       -0.05251        1.31261       -1.46095       -1.41023        1.36666        -999.25       26.54400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1902777778 04:34:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.45810       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.38282        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87631        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2036.00000       13.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       14.00000     2081.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.85600       14.72400       69.80500       68.47501        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       29.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.40000     1338.14000        2.19000       19.38000       15.58000        0.19000        8.00000       67.17000       48.83000       48.67000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.59000       79.73000       76.73000        6.59000      109.00000      285.00000      446.00000      224.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.76600     2261.93000     1957.01200     1308.32100     3738.91000     1447.59100     1783.51800      550.29300     3349.80200     1205.26700       47.62843       18.17971     1351.27800      818.42250     3938.04000     2649.73400       58.28774       41.40493     1984.35400      773.38010     2821.39100      875.69640     2099.75300      759.89140       65.46059     5000.00000       72.17815     5000.00000        -999.25        -999.25       79.71616       76.93664        0.00017        0.00014        0.00012        0.00013       -9.94000        9.81200        8.86982        8.83003        8.44082        8.45182        6.07373        6.70762        6.71133        6.12976        5.30599        5.30258        5.50251        5.44506        4.40533        4.39922        3.67405        3.66949        3.98372        4.03519        4.05702        4.00664        0.24060       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        5.09000        -999.25      124.67780        9.28070      500.99710      376.18150      131.99530        8.10764      128.61710       12.40264      504.14700      381.72640     5000.00000     5000.00000      483.35140      370.61370      139.64830       17.57927     5000.00000     5000.00000      490.58940      369.50980      487.28220      373.85140      142.73930       23.08285     5000.00000      984.49870     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32641        1.33298       -0.00410       -0.09636        1.34882       -0.00666       -0.03235       -1.39781        0.00238        0.00106       -1.40590        1.40218        0.01850       -0.01964        0.03011       -0.06384        1.33498       -1.44874       -1.40768        1.35640        -999.25       24.43200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1906250000 04:34:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.45810       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.37371        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.88414        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       15.00000     2091.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.99940       17.00060       79.99799       65.80200        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       35.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      225.30000       87.90000     1338.14000        2.40000       17.80000       18.20000        0.60000        6.40000       60.80000       43.40000       46.60000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.20000       90.20000       74.00000        6.20000      101.00000      289.00000      453.00000      213.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3751.95800     2262.18000     1957.60800     1307.99400     3739.21100     1447.56900     1783.35900      550.24900     3349.88100     1205.45500       48.75965       24.11115     1351.63400      819.05360     3939.33100     2649.79500       59.36137       42.69242     1984.79800      773.36880     2821.71700      876.07640     2099.82100      760.00820       65.62176       77.33560       71.26582       84.15213        -999.25        -999.25       78.07706       60.80907        0.00017        0.00014        0.00013        0.00012       -9.94000        9.81200        8.86798        8.82430        8.43985        8.44870        6.07394        6.70695        6.71108        6.13213        5.30587        5.30429        5.50127        5.44505        4.40589        4.40145        3.67519        3.67173        3.98549        4.03965        4.05694        4.00665        0.23760       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        4.93000        -999.25      124.67910        9.28147      500.98150      376.16690      131.98960        8.14278      128.62310       12.46163      504.17130      381.71470     5000.00000     5000.00000      483.31860      370.61910      139.63800       17.57407     5000.00000     5000.00000      490.59310      369.50720      487.28930      373.85230      142.75390       23.11302     5000.00000     1465.27500     5000.00000      991.28620     5000.00000     1781.75200        -999.25        -999.25        -999.25        -999.25        -999.25       -1.36054        1.33761       -0.03471       -0.08811        1.34352       -0.01549       -0.04530       -1.40714        0.00548       -0.00564       -1.39647        1.36439        0.01787        0.01046        0.01994        0.00613        1.33383       -1.39064       -1.41734        1.39836        -999.25       23.66400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1909722222 04:35:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.45810       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        -999.25       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.41590        -999.25        1.03000       -0.07210        1.00000       33.86410        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87042        -999.25        -999.25        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       13.00000     2037.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       14.00000     2086.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.18980       17.39020       74.52740       73.54260        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       41.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.40000     1338.14000        2.19000       18.18000       19.18000        1.59000        7.00000       69.83000       50.50000       44.17000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.59000       83.52000       79.93000        3.79000       96.00000      280.00000      443.00000      221.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3752.11400     2264.25200     1956.91100     1309.46300     3737.66200     1447.97600     1783.89600      548.23790     3348.79800     1205.07100       45.33732      200.00000     1351.05400      821.10810     3938.35300     2650.71900       56.20121      300.00000     1983.49900      772.72890     2822.69100      874.64690     2098.11700      760.09250       63.89680       32.65798       68.96546       33.47656        -999.25        -999.25       74.11877       46.64462        0.00017        0.00014        0.00020        0.00019       -9.94000        9.81200        8.87206        8.81049        8.44286        8.43258        6.07487        6.70896        6.70668        6.12541        5.30724        5.31183        5.50336        5.45469        4.40766        4.41174        3.67804        3.67533        3.98588        4.05727        4.06118        4.00292        0.23540       18.55700        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1548.00000        5.73000        -999.25      124.65950        9.26706      500.97100      376.25010      131.99640        8.06683      128.58760       12.46799      504.15510      381.82940     5000.00000     3329.85300      483.28810      370.61570      139.63760       17.59878     5000.00000     5000.00000      490.57150      369.37590      487.28710      373.88780      142.74620       23.26340     5000.00000     5000.00000     5000.00000     4678.22900     5000.00000      667.97600        -999.25        -999.25        -999.25        -999.25        -999.25       -1.37145        1.34866       -0.04079       -0.03676        1.33347       -0.03036       -0.02712       -1.34866       -0.01963       -0.02596       -1.42496        1.30912       -0.00385       -0.00906        0.01667        0.03206        1.30042       -1.41985       -1.40892        1.43399        -999.25       27.50400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1913194444 04:35:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.45810       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        5.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.41973        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84801        0.00292        0.00278        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       15.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       16.00000     2086.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.46640       16.73360       67.86440       68.33560        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       47.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.51453        -999.25        0.63529        0.63529        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.80000       87.40000     1338.14000        2.00000       18.20000       18.20000        1.20000        8.00000       70.00000       50.60000       46.40000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.60000       77.20000       75.40000        4.80000      101.00000      279.00000      441.00000      222.00000        1.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3751.58500     2262.10700     1957.65700     1308.46900     3739.62400     1447.89300     2517.41000      550.13610     3360.28900     1205.47700     5000.00000       32.26155     1351.72500      818.92430     3939.24400     2649.46000       60.21275       47.33051     1984.97700      773.17900     3981.90800      876.31260     2106.32800      759.62040       66.51807       54.19569       73.43103       49.05174        -999.25        -999.25       80.04484       44.62800        0.00018        0.00016        0.00019        0.00018       -9.94000        9.81200        8.86653        8.82539        8.43851        8.44638        6.07353        6.70643        6.71025        6.12788        5.30517        5.30630        5.50145        5.44913        4.40458        4.40568        3.67383        3.67622        3.98275        4.04378        4.05701        4.01125        0.24100       18.44700        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        5.56000        -999.25      124.66470        9.27461      500.96660      376.18170      131.98400        8.13294      128.97760       12.39086      504.03140      381.73700     5000.00000     5000.00000      483.33890      370.64870      139.62550       17.56305     5000.00000     1146.02000      490.59720      369.53270      487.65630      373.86540      142.61070       23.06973     5000.00000     1188.25200     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32575        1.37404       -0.01221       -0.05674        1.34116       -0.00555       -0.01448       -1.38138        0.00660       -0.00252       -1.38680        1.39971        0.01318       -0.03909        0.00869       -0.09388        1.32132       -1.47459       -1.42078        1.33276        -999.25       26.68800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1916666667 04:36:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.45810       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        5.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.77486        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85328        0.00192        0.00198        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       12.00000     2035.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       17.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.85660       17.32340       70.81007       71.87994        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       53.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       88.40000     1338.14000        1.59000       16.38000       18.78000        1.39000        8.66000       62.00000       44.33000       42.17000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       14.38000       81.93000       79.73000        4.59000      120.00000      280.00000      437.00000      220.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.90900     2262.31300     1957.65800     1308.49100     3739.59400     1447.66100     2516.92600      550.47090     3360.70000     1205.49600       48.02094       24.87551     1351.50000      818.94900     3939.34900     2649.69300       59.47458       55.54953     1985.15200      773.52940     3981.82400      875.93720     2106.49200      760.27680       66.50397      500.00000       72.37880      500.00000        -999.25        -999.25       78.25118      103.88060        0.00020        0.00016        0.00017        0.00017       -9.94000        9.80100        8.86872        8.82592        8.44048        8.44842        6.07375        6.70688        6.70936        6.12850        5.30518        5.30154        5.50062        5.44380        4.40521        4.39800        3.67507        3.66753        3.98423        4.03477        4.05740        4.00388        0.25000       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        5.46000        -999.25      124.65650        9.27045      500.96980      376.17060      131.97270        8.15097      128.94720       12.41375      504.00810      381.78190     5000.00000     5000.00000      483.31750      370.60270      139.62170       17.56019     5000.00000     5000.00000      490.57320      369.48210      487.64450      373.82940      142.59320       23.17699     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     3035.27800        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33897        1.33227       -0.01548       -0.07505        1.34810       -0.00856       -0.04618       -1.38963       -0.00268       -0.02413       -1.39951        1.33118        0.00215       -0.01120        0.00694       -0.00057        1.30269       -1.41569       -1.41492        1.39507        -999.25       26.20800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1920138889 04:36:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.45810       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        5.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.03622        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86959        0.00259        0.00115        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2027.00000       13.00000     2026.00000        -999.25        0.00000        -999.25     1937.00000     2067.00000       16.00000     2074.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.80020       14.79980       66.46440       69.53560        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       59.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.40000       15.40000       17.60000        3.00000        8.60000       65.20000       45.60000       43.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.20000       75.40000       76.20000        4.40000       97.80000      291.00000      450.00000      213.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3751.34100     2262.47400     1956.85800     1308.55000     3738.29700     1447.86700     2516.82000      550.19320     3358.99100     1205.49200       47.00287       22.07952     1351.16400      818.82350     3938.01000     2649.79200       58.57047       47.90508     1984.41700      773.51840     3980.06300      876.07360     2105.21400      759.72630       67.30667       92.17092       74.85956       67.24136        -999.25        -999.25       79.90865       48.02892        0.00020        0.00015        0.00018        0.00016       -9.94000        9.81200        8.86957        8.82787        8.44137        8.44951        6.07435        6.70744        6.71015        6.12843        5.30456        5.30363        5.50082        5.44516        4.40374        4.40278        3.67392        3.67475        3.98076        4.04051        4.05825        4.01014        0.24000       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        4.43000        -999.25      124.64790        9.28951      500.99460      376.20220      131.99590        8.14809      128.95640       12.46395      504.02740      381.73810     5000.00000     5000.00000      483.31520      370.68130      139.63730       17.59512     5000.00000     1572.07900      490.57440      369.53800      487.65500      373.90620      142.61780       23.11169     5000.00000     1168.70200     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33262        1.39183       -0.00058       -0.04672        1.35736       -0.00784       -0.01827       -1.39294       -0.01168       -0.00224       -1.42151        1.38991       -0.00267       -0.01517        0.01577       -0.04463        1.30141       -1.44228       -1.40962        1.37362        -999.25       21.26400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1923611111 04:37:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.49870       27.29823       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        5.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      119.62646        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85038        0.00170        0.00210        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2030.00000        -999.25        0.00000        -999.25     1937.00000     2085.00000       15.00000     2086.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.32340       16.45660       59.68827       73.60173        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       65.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.19000        0.00000        0.19000        0.16921        -999.25        -999.25        0.41436        0.41436        0.31800        0.49513        0.37017        0.74702        0.74702     1675.10400        -999.25      222.80000       87.40000     1338.14000        1.59000       15.98000       18.18000        1.79000        7.66000       61.17000       45.17000       41.83000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.19000        0.19000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.98000       69.94000       82.12000        6.79000      102.00000      297.00000      455.00000      218.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3752.07300     2262.27000     1957.05500     1308.41100     3738.45700     1447.65700     2515.97500      549.92250     3358.72700     1205.10300       43.60601       22.87835     1350.69100      818.66820     3938.41500     2649.27900       56.00289       45.43010     1984.08600      773.19550     3979.06700      875.45780     2105.59200      759.23190       65.88565       79.91196       74.40704       64.32832        -999.25        -999.25       82.52810       46.54259        0.00020        0.00015        0.00017        0.00016       -9.94000        9.81200        8.87430        8.82873        8.44447        8.44918        6.07437        6.70909        6.71058        6.12767        5.30566        5.30417        5.50264        5.44753        4.40400        4.40317        3.67215        3.67538        3.98150        4.03867        4.05601        4.01299        0.24780       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        6.86000        -999.25      124.66540        9.29235      500.98830      376.22180      131.99120        8.15449      128.95420       12.43274      504.01870      381.74030     5000.00000     5000.00000      483.32910      370.65210      139.63600       17.58415     5000.00000     1159.89900      490.56450      369.52980      487.65200      373.90360      142.60980       23.10880     5000.00000     1938.60700     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33630        1.35972       -0.00454       -0.05189        1.35237       -0.01256       -0.01466       -1.36238       -0.01534       -0.00901       -1.42671        1.37535       -0.00340       -0.03436        0.01801       -0.05911        1.30219       -1.47083       -1.40889        1.36850        -999.25       32.92800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1927083333 04:37:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       22.35859       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967        5.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.89774        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84601        0.00288        0.00246        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2029.00000        -999.25        0.00000        -999.25     1937.00000     2088.00000       12.00000     2083.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.59960       15.00040       70.66440       62.73560        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       71.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.40000       18.60000       16.60000        1.20000        8.80000       60.80000       44.60000       43.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.80000       80.20000       70.00000        5.00000      105.00000      307.00000      460.00000      222.00000        0.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3750.12600     2261.73100     1953.96700     1306.55800     3732.47100     1445.12700     2505.94200      547.89580     3343.87700     1199.97900       42.74735       16.60608     1349.98400      818.26350     3934.76900     2647.81400       49.43341       25.63106     1979.04400      771.33090     3968.73000      873.63530     2094.47700      755.38730       55.83559       31.05401       62.72141       30.21027        -999.25        -999.25       69.48504       28.31041        0.00021        0.00016        0.00017        0.00015       -9.92000        9.81200        8.87435        8.83096        8.44529        8.45316        6.08004        6.71398        6.71633        6.13518        5.31420        5.31243        5.51082        5.45331        4.41397        4.41337        3.68178        3.68623        3.99361        4.05264        4.06349        4.02008        0.24060       18.55700        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000       11.39000        -999.25      124.65580        9.27861      500.97830      376.21520      131.99120        8.15858      128.97000       12.50522      504.03850      381.74370     5000.00000     5000.00000      483.29670      370.65980      139.63570       17.59811     5000.00000     1000.93700      490.58810      369.56270      487.66400      373.89180      142.62570       23.12418     5000.00000      489.97160     5000.00000      753.23290     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.35915        1.38115       -0.03247       -0.05327        1.34256       -0.01729       -0.01236       -1.38290       -0.00507        0.02132       -1.40315        1.40414        0.00339        0.01796        0.01107       -0.01520        1.30594       -1.38654       -1.41280        1.38044        -999.25       54.67200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1930555556 04:38:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       22.35859       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.27707        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85637        0.00321        0.00355        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       13.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       18.00000     2088.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.52340       14.05660       69.07220       76.39780        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       77.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       87.90000     1338.14000        1.39000       15.98000       15.58000        1.59000        8.50000       62.33000       43.33000       42.67000        0.59000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        9.59000       77.53000       83.72000        6.19000      101.00000      284.00000      439.00000      217.00000        1.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3750.51900     2261.37100     1954.03100     1306.48900     3731.67700     1445.21300     2505.78500      548.01240     3344.35300     1199.15800       41.72522       18.87702     1349.88600      818.15160     3934.56100     2647.39700       49.59532       24.32521     1978.82500      770.91520     3968.35500      873.59590     2093.95500      754.88710       56.59343       28.11292       62.25888       29.97760        -999.25        -999.25       67.26701       30.78412        0.00021        0.00017        0.00017        0.00015       -9.94000        9.81200        8.87588        8.83076        8.44629        8.45126        6.07930        6.71377        6.71713        6.13427        5.31350        5.31424        5.50993        5.45850        4.41446        4.41350        3.68442        3.68367        3.99334        4.05040        4.06690        4.01989        0.24040       18.50200        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000       10.60000        -999.25      124.66760        9.28766      500.98870      376.21990      132.00270        8.17340      128.97190       12.47672      504.04110      381.73350     5000.00000     5000.00000      483.32930      370.63040      139.63710       17.60068     5000.00000     5000.00000      490.59970      369.53880      487.66230      373.89730      142.61830       23.07985     5000.00000     1510.96700     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33825        1.34277       -0.01229       -0.07129        1.35162       -0.00751       -0.03059       -1.38077       -0.00184       -0.00604       -1.40305        1.36536        0.00276       -0.01725        0.00539       -0.04806        1.30960       -1.42056       -1.42278        1.34639        -999.25       50.88000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1934027778 04:38:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.41022       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.26603        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85113        0.00403        0.00171        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       15.00000     2040.00000        -999.25        0.00000        -999.25     1937.00000     2085.00000       13.00000     2083.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.99960       19.00040       72.39740       63.00260        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       83.00000       80.00000        0.00000        0.00000        0.20000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.80000       87.40000     1338.14000        2.20000       18.80000       20.40000        1.00000        9.40000       64.60000       44.40000       45.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.20000        0.20000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.40000       83.20000       71.20000        5.60000      105.00000      284.00000      438.00000      216.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3748.90300     2260.50000     1946.84100     1300.67900     3728.57200     1443.17900     1760.88000      543.66550     3329.58500     1197.77600       32.47474       11.72693     1348.03900      817.45540     3926.43100     2640.46900       41.20042       14.68069     1974.66900      769.22730     2794.40500      868.60930     2081.57600      752.51220       46.02809       17.27457       49.84303       18.11256        -999.25        -999.25       55.29465       17.78491        0.00020        0.00017        0.00016        0.00015       -9.94000        9.81200        8.88403        8.83481        8.45667        8.46057        6.09335        6.72559        6.72782        6.15022        5.32699        5.32649        5.52096        5.46531        4.42942        4.42926        3.70038        3.70471        4.01120        4.06986        4.07996        4.03724        0.23860       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000       10.43000        -999.25      124.65330        9.29258      500.95910      376.20650      131.98870        8.15731      128.61510       12.44684      504.16000      381.75820     5000.00000     5000.00000      483.32030      370.62150      139.63130       17.60548     5000.00000     5000.00000      490.60540      369.55460      487.30800      373.90280      142.74250       23.16949     5000.00000     1260.76300     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33295        1.32894       -0.02515       -0.09874        1.32782       -0.01315       -0.03516       -1.39896        0.00146       -0.00349       -1.38332        1.39726        0.00775       -0.01076        0.00314       -0.02507        1.30711       -1.45596       -1.41754        1.41128        -999.25       50.06400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1937500000 04:39:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.02766       21.39339       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.96736        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85815        0.00269        0.00231        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       12.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       14.00000     2087.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.32260       15.25740       75.86687       72.81313        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       89.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       88.90000     1338.14000        3.19000       16.78000       16.98000        0.99000        6.66000       65.17000       46.33000       44.67000        0.59000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.38000       85.12000       78.93000        2.99000      108.00000      282.00000      439.00000      220.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3750.18600     2260.97400     1949.60400     1303.42300     3730.56700     1445.01000     2487.57800      543.77660     3344.91800     1199.95800       34.02328       13.39100     1348.55100      817.81340     3929.65200     2644.65400       43.58459       16.67733     1976.55300      770.40860     3948.33500      869.19400     2092.56400      755.14310       47.51673       17.94810       50.94761       19.04878        -999.25        -999.25       57.13960       21.20537        0.00019        0.00016        0.00016        0.00014       -9.94000        9.81200        8.88371        8.83283        8.45474        8.45739        6.08815        6.72200        6.72447        6.14567        5.32426        5.32521        5.51733        5.46300        4.42783        4.42709        3.69770        3.69644        4.01275        4.07393        4.07414        4.02274        0.23360       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000       10.36000        -999.25      124.64910        9.26238      500.98450      376.20590      131.98180        8.14304      128.94910       12.46619      504.01740      381.77930     5000.00000     5000.00000      483.30710      370.63890      139.62860       17.58907     5000.00000      935.01080      490.58450      369.55670      487.65260      373.90960      142.60370       23.12705     5000.00000      641.25410     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34196        1.37648       -0.01442       -0.05928        1.35582       -0.00489       -0.01126       -1.38314       -0.00116        0.01183       -1.39728        1.41370       -0.00005       -0.01623        0.00423       -0.07051        1.29657       -1.44338       -1.41371        1.34779        -999.25       49.72800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1940972222 04:39:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.29399       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.86298        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83406        0.00109        0.00147        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       12.00000     2039.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       15.00000     2083.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.79960       13.60040       67.99740       67.20260        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25       95.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      223.30000       87.90000     1338.14000        2.00000       19.40000       14.80000        0.80000        7.20000       66.20000       49.40000       44.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.20000       77.60000       74.20000        4.40000       99.80000      287.00000      447.00000      218.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3749.88700     2260.79100     1949.16100     1302.98100     3729.65000     1444.66500     2486.52100      543.82720     3343.01400     1200.35800       34.44907       12.61818     1348.75700      817.69320     3929.62500     2644.03200       43.30361       16.64016     1976.10500      770.41720     3947.22600      869.27760     2090.93200      755.17640       47.12515       18.41178       50.15830       19.00501        -999.25        -999.25       55.73012       19.86066        0.00020        0.00016        0.00015        0.00014       -9.94000        9.81200        8.88169        8.83340        8.45423        8.45881        6.09007        6.72242        6.72452        6.14658        5.32497        5.32436        5.51716        5.46083        4.42887        4.42719        3.69974        3.69888        4.01400        4.07395        4.07597        4.02525        0.24080       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        9.73000        -999.25      124.63740        9.27068      500.96420      376.19740      131.99160        8.15018      128.97510       12.47996      504.05910      381.76020     5000.00000     5000.00000      483.30120      370.64250      139.62020       17.59498     5000.00000     5000.00000      490.59010      369.54070      487.65750      373.89990      142.65220       23.11125     5000.00000      917.48120     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33616        1.37180       -0.01493       -0.06421        1.34401       -0.01039       -0.02543       -1.39756       -0.00094        0.00251       -1.40143        1.39053        0.01112       -0.00948        0.02089       -0.05055        1.31757       -1.41992       -1.40688        1.35103        -999.25       46.70400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       27.50000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1944444444 04:40:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.29399       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.00782        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87825        0.00246        0.00316        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       12.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       14.00000     2080.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.85620       14.52380       74.66160       70.40840        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      101.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      224.80000       87.40000     1338.14000        2.59000       18.98000       16.18000        1.19000        7.83000       62.17000       44.83000       42.83000        0.99000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.79000       84.72000       78.73000        6.59000      103.00000      294.00000      453.00000      208.00000        0.79000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3749.98400     2261.01200     1949.43200     1303.67600     3730.04100     1444.86500     2486.22300      543.99870     3343.27500     1199.76500       34.61350       17.75513     1348.60600      818.28060     3929.50700     2644.58800       43.35439       17.75329     1975.98400      770.09890     3947.15400      869.08050     2091.30400      754.88680       46.81055       18.12858       49.82513       19.63120        -999.25        -999.25       56.12081       22.33186        0.00020        0.00017        0.00015        0.00014       -9.95000        9.81200        8.88289        8.82801        8.45403        8.45217        6.08860        6.72234        6.72297        6.14377        5.32555        5.32488        5.51861        5.46562        4.42946        4.42580        3.69917        3.69461        4.01488        4.06924        4.07510        4.02429        0.24160       18.54600       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000       10.33000        -999.25      124.66210        9.26333      500.98200      376.19400      131.99040        8.14266      128.98360       12.45463      504.04080      381.75420     5000.00000     5000.00000      483.33190      370.65730      139.63390       17.59105     5000.00000     1233.24300      490.58770      369.54970      487.65690      373.90350      142.63610       23.14102     5000.00000      869.71670     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33021        1.39392       -0.00813       -0.05148        1.34805       -0.00720       -0.01549       -1.39702        0.00171        0.00368       -1.40273        1.40708        0.01593       -0.01086        0.02745       -0.04229        1.32674       -1.44888       -1.40468        1.38687        -999.25       49.58400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1947916667 04:40:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.29399       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.00350        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87699        0.00210        0.00273        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       15.00000     2030.00000        -999.25        0.00000        -999.25     1937.00000     2085.00000       15.00000     2083.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.19980       13.60020       74.39760       70.80240        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      107.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.20000       21.20000       15.40000        1.60000        8.40000       59.40000       42.40000       36.40000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.20000       85.20000       79.20000        6.00000      108.00000      284.00000      433.00000      223.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3750.44300     2260.71400     1949.52500     1303.23600     3729.76700     1444.95800     2487.18800      543.85160     3343.15100     1200.00900       32.24993       11.52473     1348.33600      817.45730     3930.51000     2644.67700       42.23006       16.32562     1975.77300      770.68080     3948.31800      869.19130     2091.18500      755.05000       46.59562       18.86802       49.96018       19.54164        -999.25        -999.25       56.36082       20.43301        0.00019        0.00016        0.00015        0.00013       -9.94000        9.81200        8.88569        8.83561        8.45696        8.46098        6.09041        6.72402        6.72498        6.14699        5.32594        5.32355        5.51890        5.45961        4.42917        4.42599        3.69882        3.69775        4.01407        4.07270        4.07527        4.02417        0.24060       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        7.53000        -999.25      124.63650        9.26408      500.96160      376.20330      131.98030        8.15492      128.96400       12.51135      504.01380      381.75150     5000.00000     5000.00000      483.31860      370.63340      139.62030       17.59205     5000.00000     5000.00000      490.58610      369.52620      487.65460      373.90310      142.60980       23.10228     5000.00000      934.75050     5000.00000     1771.20400     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31783        1.36931       -0.00434       -0.05686        1.34135       -0.00531       -0.02647       -1.38877       -0.00001        0.00211       -1.39415        1.37127        0.00956       -0.00028        0.01712       -0.03184        1.30939       -1.39176       -1.40402        1.35078        -999.25       36.14400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1951388889 04:41:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.13815       21.25691       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.85707        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85161        0.00182        0.00245        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       11.00000     2032.00000        -999.25        0.00000        -999.25     1937.00000     2079.00000       16.00000     2077.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.38940       19.59060       68.53820       67.14180        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      113.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       87.40000     1338.14000        2.59000       16.38000       20.98000        0.79000        7.50000       70.67000       50.50000       41.17000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.79000       78.53000       75.33000        6.39000      100.00000      290.00000      453.00000      223.00000        1.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3749.39100     2261.13300     1949.67300     1303.54700     3729.94700     1444.57600     2486.42700      543.81010     3343.06400     1199.90000       37.49424       13.08636     1348.98800      817.71150     3930.19200     2643.57700       43.41088       19.07619     1975.33800      770.69670     3948.42400      868.98830     2091.23200      754.90880       45.76291       20.99791       49.06803       20.06510        -999.25        -999.25       55.98482       20.11059        0.00019        0.00017        0.00015        0.00013       -9.94000        9.81200        8.87905        8.83452        8.45072        8.45794        6.08904        6.72226        6.72125        6.14131        5.32749        5.32055        5.52123        5.45714        4.43109        4.42490        3.69937        3.69832        4.01696        4.07133        4.07485        4.02501        0.24160       18.51300       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        6.63000        -999.25      124.63740        9.28193      500.96890      376.22710      131.97990        8.16911      128.96170       12.48165      504.02570      381.77250     3152.39400     1037.85300      483.32900      370.66910      139.62670       17.59964     5000.00000     2127.96300      490.57260      369.51190      487.65130      373.90440      142.60950       23.10880     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.30833        1.38720        0.00646       -0.02824        1.34215       -0.00581       -0.02103       -1.37259       -0.00610       -0.01584       -1.40723        1.34280        0.00374       -0.02654        0.01175       -0.05112        1.31038       -1.42280       -1.41621        1.33627        -999.25       31.82400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1954861111 04:41:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.25548       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.74622        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85761        0.00236        0.00139        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       13.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       15.00000     2081.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.73300       16.86700       71.26500       77.13500        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      119.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.60000       15.00000       18.80000        1.60000        6.00000       58.80000       41.80000       44.80000        0.20000        0.00000        0.20000        0.20000        0.00000        0.20000       36.84730       36.84730       36.84730       25.27360       25.27360       25.27360        -999.25        0.00000       18.50000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.60000       80.20000       84.40000        5.60000      104.00000      283.00000      447.00000      216.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3749.79800     2261.11600     1948.95900     1303.18300     3730.14400     1444.59200     2485.35700      544.37470     3342.84000     1199.91900       35.09678       12.68622     1348.81500      817.65380     3929.23200     2643.51600       43.15287       17.52931     1976.04600      770.42880     3947.18900      869.37160     2090.60800      754.82390       46.19549       20.21908       48.90751       21.17693        -999.25        -999.25       54.17616       21.60258        0.00018        0.00017        0.00014        0.00013       -9.95000        9.81200        8.88111        8.83507        8.45346        8.45868        6.09010        6.72264        6.72328        6.14353        5.32668        5.32137        5.51857        5.46026        4.43144        4.42337        3.70205        3.69578        4.01798        4.06615        4.07686        4.02613        0.23860       18.55700        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        5.66000        -999.25      124.64930        9.28561      500.97990      376.21930      131.99010        8.16854      128.99480       12.46933      504.06700      381.73850     3340.64000     5000.00000      483.33510      370.66220      139.62140       17.59948     5000.00000     1683.95200      490.60670      369.54520      487.67340      373.87780      142.66330       23.11504     5000.00000      905.30000     5000.00000     1851.83200     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31412        1.37662        0.00437       -0.04842        1.35857        0.00691       -0.01898       -1.38015        0.01267        0.00279       -1.38341        1.37669        0.01835       -0.00086        0.02073       -0.02225        1.32141       -1.40851       -1.40366        1.37655        -999.25       27.16800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1958333333 04:42:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.25548       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.61912        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86739        0.00189        0.00269        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       13.00000     2043.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       15.00000     2090.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       20.25640       18.12360       76.26200       75.40800        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      125.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.30000       87.90000     1338.14000        1.79000       21.78000       19.38000        0.99000        8.00000       62.50000       45.50000       46.83000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        9.79000       84.72000       82.53000        5.79000      103.00000      279.00000      429.00000      223.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3749.42200     2260.84100     1948.14800     1302.93100     3729.40200     1444.50600     2484.23600      543.41460     3341.95900     1200.10600       33.51064       12.86509     1348.53700      817.82620     3929.28400     2643.82800       41.34493       17.41705     1975.07400      770.55210     3945.52500      868.76100     2089.60400      753.88980       44.99029       18.95373       48.34557       17.58636        -999.25        -999.25       53.57990       16.10459        0.00016        0.00017        0.00014        0.00012       -9.94000        9.81200        8.88203        8.83218        8.45537        8.45835        6.09383        6.72537        6.72343        6.14624        5.32895        5.32340        5.52112        5.45835        4.43267        4.43053        3.70296        3.70996        4.01824        4.07538        4.07874        4.03824        0.23960       18.50200       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        4.46000        -999.25      124.65830        9.27692      500.97700      376.20800      131.98440        8.16736      128.96890       12.44467      504.02900      381.76020     5000.00000     5000.00000      483.30720      370.65430      139.62900       17.59154     5000.00000     2835.71200      490.57870      369.53430      487.65290      373.91060      142.62060       23.12857     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.35110        1.37735       -0.02306       -0.04714        1.34804       -0.01317       -0.02293       -1.38353       -0.00247       -0.01727       -1.40569        1.36695        0.00887       -0.03403        0.02003       -0.05465        1.31593       -1.46589       -1.40836        1.36835        -999.25       21.40800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1961805556 04:42:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.09589       21.26868       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.84345        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84343        0.00181        0.00206        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       14.00000     2038.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       14.00000     2091.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.26620       15.53380       68.99860       70.40141        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      131.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        3.20000       19.00000       17.80000        1.80000        6.80000       68.60000       50.00000       38.80000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.20000       77.80000       77.80000        6.00000      102.00000      284.00000      450.00000      237.00000        0.20000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3748.20600     2259.65700     1944.58500     1299.53500     3725.36600     1442.26600     2490.90700      543.86990     3335.71100     1197.64600       32.30418       10.31202     1347.47700      816.55430     3922.21400     2638.57800       39.59899       12.95259     1971.46500      767.89640     3948.12500      868.53090     2083.67800      753.11070       45.56366       15.27258       51.11347       18.79854        -999.25        -999.25       56.33628       22.45776        0.00016        0.00017        0.00017        0.00015       -9.94000        9.77900        8.88604        8.84115        8.45689        8.46365        6.09409        6.72812        6.73250        6.15164        5.32786        5.33061        5.52760        5.47485        4.42761        4.42766        3.69886        3.69441        4.00067        4.06580        4.08716        4.02940        0.24240       18.49100       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.56000        -999.25      124.65220        9.25589      500.99430      376.24280      131.98310        8.15924      128.97680       12.44942      504.03460      381.76620     3813.47000     5000.00000      483.33710      370.60940      139.63330       17.62074     5000.00000     1749.24900      490.61200      369.55330      487.66180      373.89690      142.64330       23.13672     5000.00000      927.27230     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31513        1.35348        0.00173       -0.06903        1.36095        0.01093       -0.01934       -1.37798        0.01782        0.00228       -1.37109        1.39405        0.02134       -0.01750        0.02377       -0.05059        1.31502       -1.44744       -1.39124        1.37049        -999.25       17.08800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1965277778 04:43:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.43660       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.51326        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87821        0.00228        0.00320        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2033.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       14.00000     2086.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        9.66640       16.32360       68.47140       72.80860        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      137.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.19000       11.59000       17.98000        1.39000        6.83000       67.17000       49.00000       44.33000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.39000       77.93000       80.33000        5.59000       99.84000      283.00000      435.00000      214.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3749.82400     2260.41000     1949.40400     1303.42200     3730.09300     1444.66300     1763.02300      544.15440     3333.97800     1199.85400       35.45546       12.89442     1348.81300      817.09380     3929.60900     2644.42500       43.59531       14.49043     1976.10600      769.21840     2798.42400      869.39730     2085.83700      755.18550       47.11832       15.69220       50.73838       18.81845        -999.25        -999.25       57.42289       24.96476        0.00016        0.00017        0.00016        0.00014      -10.20000        9.81200        8.88119        8.83831        8.45304        8.45829        6.08895        6.72199        6.72831        6.14493        5.32498        5.32970        5.51819        5.47434        4.42810        4.42762        3.69730        3.69067        4.01311        4.06992        4.07365        4.02149        0.23360       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1547.00000        3.63000        -999.25      124.64540        9.28975      500.97510      376.19180      131.98690        8.18378      128.62460       12.42570      504.15950      381.77220     5000.00000     5000.00000      483.30030      370.65510      139.62460       17.59363     5000.00000     5000.00000      490.57340      369.53200      487.29030      373.87620      142.75220       23.15840     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34509        1.36531       -0.01538       -0.06063        1.35049       -0.01239       -0.03976       -1.40183       -0.00114       -0.02734       -1.41347        1.34823        0.01640       -0.02652        0.03198       -0.02884        1.33437       -1.45046       -1.40730        1.38624        -999.25       17.42400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1968750000 04:43:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.43660       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.24903        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.88506        0.00196        0.00374        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       12.00000     2035.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       16.00000     2079.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.46600       15.33400       62.86440       71.53560        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      143.00000       80.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        0.16921        -999.25        -999.25        0.41436        0.41436        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.40000       19.20000       16.40000        0.40000       11.60000       66.00000       49.00000       42.60000        0.60000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.20000        0.20000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.20000       72.80000       79.20000        5.40000      105.00000      286.00000      457.00000      222.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3749.56600     2260.76100     1949.36300     1302.86100     3730.73000     1444.73000     2486.65200      543.25290     3345.03300     1200.92700       33.85786       10.66153     1348.70500      817.44170     3930.52200     2644.41000       43.33056       16.25668     1977.11500      770.84200     3948.37700      868.33590     2092.64700      755.44530       47.21882       19.40257       50.09349       19.43465        -999.25        -999.25       55.65667       19.21283        0.00015        0.00017        0.00015        0.00014       -9.94000        9.81200        8.88128        8.83596        8.45495        8.46285        6.09115        6.72238        6.72508        6.14862        5.32480        5.32261        5.51524        5.45643        4.42896        4.42623        3.69985        3.70063        4.01607        4.07372        4.07409        4.02627        0.25960       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.90000        -999.25      124.63890        9.26527      500.98790      376.18080      131.96490        8.12849      128.95810       12.52378      504.01010      381.71880     5000.00000     5000.00000      483.30060      370.61720      139.62870       17.57334     5000.00000     5000.00000      490.57350      369.51220      487.63590      373.94720      142.59430       23.08105     5000.00000     1064.66400     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33832        1.35195       -0.01147       -0.07489        1.35922       -0.00080       -0.02959       -1.39256        0.00907       -0.00052       -1.39136        1.38371        0.01375       -0.01013        0.01405       -0.04220        1.32225       -1.42339       -1.41577        1.36220        -999.25       18.72000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       27.40000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1972222222 04:44:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.90936       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.74013        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86717        0.00255        0.00163        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       12.00000     2033.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       15.00000     2080.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.38980       17.59020       71.93880       62.55120        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      149.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       88.90000     1338.14000        1.39000       17.58000       18.58000        0.79000        7.83000       63.33000       44.17000       47.50000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        9.99000       80.73000       70.14000        6.39000       97.50000      295.00000      454.00000      219.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3748.36600     2259.72000     1888.46500     1264.03900     3723.85100     1442.36200     2484.91700      547.01810     3331.34200     1195.25200       18.57593        4.83159     1346.51500      815.92160     3844.07100     2588.00100       23.49321        6.25747     1968.09800      766.98910     3904.47700      864.62430     2075.98900      748.91820       42.17519       14.82111       85.74419      500.00000        -999.25        -999.25       80.15470       68.49960        0.00016        0.00017        0.00015        0.00013       -9.95000        9.81200        8.89262        8.84812        8.49878        8.50239        6.17365        6.77237        6.77318        6.22408        5.33450        5.33182        5.53891        5.48570        4.39780        4.39351        3.67375        3.67038        3.92502        3.97651        4.10788        4.06050        0.24200       18.54600       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.90000        -999.25      124.64810        9.28619      501.09770      376.29700      131.97460        8.18080      129.86700       13.01228      504.01350      381.75890     3580.71700     5000.00000      483.30350      370.64800      139.70500       17.65873     5000.00000      773.56730      490.57470      369.58050      488.49780      374.49680      142.60050       23.11599     4889.29600     1041.23000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34461        1.36185        0.00271       -0.05604        1.39275        0.01225       -0.00769       -1.36170        0.02492       -0.00008       -1.39989        1.39973        0.03577       -0.03796        0.04168       -0.08061        1.36920       -1.48451       -1.41307        1.35708        -999.25       18.72000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1975694444 04:44:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.90936       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.20130        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87515        0.00279        0.00184        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       14.00000     2083.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.60000       15.80000       67.53080       68.26920        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      155.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        1.60000       17.20000       17.40000        1.60000        9.00000       73.60000       57.60000       49.60000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.60000       77.60000       75.80000        5.00000      100.00000      276.00000      435.00000      213.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3735.97200     2252.98700     1546.47600     2041.83100     3690.40600     1430.27200     1920.29500      600.94090     3272.73300     1178.41200      200.00000      200.00000     1328.47600      805.94120     2874.75500     3817.43200      300.00000      300.00000     1918.13900      748.62400     3087.13000      973.38870     1996.96900      724.12870      500.00000      500.00000       17.87153        4.30513        -999.25        -999.25       18.55436        4.44829        0.00015        0.00018        0.00015        0.00013       -9.94000        9.81200        8.98100        8.92911        8.13457        8.13425        5.38515        6.43647        6.43325        5.43503        5.25954        5.25640        5.68388        5.62310        4.57912        4.57643        3.87405        3.86917        4.12374        4.18909        4.29079        4.22963        0.24060       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        4.50000        -999.25      124.65480        9.30191      499.37660      375.09530      132.02560        8.17974      127.93960       12.78082      504.20430      381.82980     1586.65600     5000.00000      483.36590      370.71770      137.99720       16.52172     2564.87500      611.93520      490.66480      369.67680      486.76980      374.22190      142.87240       23.28279     5000.00000      314.98690     5000.00000      519.05470     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.28896        1.41583        0.02804       -0.07224        1.37946        0.02928       -0.00222       -1.42642       -0.00874        0.04325       -1.36084        1.49705       -0.03390        0.03204       -0.00693       -0.01133        1.16976       -1.44110       -1.33191        1.45295        -999.25       21.60000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1979166667 04:45:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.90936       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.82056        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84478        0.00232        0.00395        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2031.00000       15.00000     2036.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       18.00000     2076.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       11.45640       17.72360       77.79460       67.67541        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      161.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.19000       13.38000       19.38000        1.39000        8.33000       66.33000       50.17000       44.33000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.19000       86.92000       74.73000        4.99000      105.00000      292.00000      450.00000      223.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3735.57100     2252.87100     1575.62000     2031.82700     3690.41800     1430.30800     1964.04600      618.40210     3272.74300     1179.36000      200.00000      200.00000     1328.57400      806.36200     2924.43900     3799.92500      300.00000      300.00000     1918.58300      749.56360     3162.62400     1004.39000     1997.60900      725.16200      500.00000      500.00000       17.42660        4.14854        -999.25        -999.25       18.17395        4.25858        0.00016        0.00018        0.00014        0.00013       -9.94000        9.81200        8.97942        8.92413        8.12722        8.13455        5.37182        6.42891        6.43070        5.43776        5.25876        5.25763        5.68190        5.61242        4.58503        4.58417        3.87956        3.87956        4.13792        4.21263        4.28803        4.22423        0.23860       18.44700       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        4.33000        -999.25      124.66660        9.29455      498.17830      374.76140      132.02540        8.18000      129.03860       11.79140      504.23850      381.79810     5000.00000     5000.00000      483.37490      370.73130      136.86200       16.21669     4190.77000     5000.00000      490.73940      369.59590      487.95340      373.14330      142.95580       23.24821     5000.00000      537.23020     5000.00000      338.29950     5000.00000      450.87280        -999.25        -999.25        -999.25        -999.25        -999.25       -1.29172        1.43671       -0.02432       -0.05072        1.31628        0.01572       -0.03170       -1.45525       -0.00824        0.01777       -1.28600        1.41592       -0.04514        0.05563       -0.03097        0.05141        1.08524       -1.35194       -1.28267        1.45012        -999.25       20.78400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1982638889 04:45:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       21.90936       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.12815        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86063        0.00274        0.00181        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2031.00000       13.00000     2041.00000        -999.25        0.00000        -999.25     1937.00000     2094.00000       17.00000     2101.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.73360       16.66640       67.13219       71.46780        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      167.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.30000       87.90000     1338.14000        1.20000       17.20000       18.40000        2.00000        9.40000       56.20000       41.00000       39.40000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.20000       77.20000       80.40000        7.80000       96.60000      298.00000      461.00000      227.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3735.91400     2253.08000     1586.59300     1972.84200     3689.67000     1430.55700     1949.10100      637.65200     3271.73200     1180.01500      200.00000      200.00000     1327.80000      805.91890     2943.39400     3695.34200      300.00000      300.00000     1917.49700      750.21150     3136.82500     1037.66700     1996.37400      725.95280      500.00000      500.00000       17.49642        4.03579        -999.25        -999.25       18.25394        4.14521        0.00016        0.00017        0.00013        0.00013       -9.95000        9.81200        8.98528        8.92971        8.12874        8.14698        5.36766        6.42908        6.43734        5.45125        5.25810        5.26222        5.68506        5.60643        4.58409        4.58994        3.87839        3.88600        4.13312        4.22949        4.29072        4.21958        0.23420       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        4.53000        -999.25      124.65890        9.28850      498.06700      375.13320      132.02510        8.17891      128.86480       11.24100      504.23160      381.78180     2642.62200     5000.00000      483.39740      370.72530      136.73350       16.61504     2734.35400     5000.00000      490.72060      369.62410      487.76560      372.49410      142.94940       23.18984     5000.00000      281.79030     5000.00000      199.67020     5000.00000      381.90520        -999.25        -999.25        -999.25        -999.25        -999.25       -1.26157        1.43679        0.01152       -0.07127        1.33347        0.02720       -0.03768       -1.48186       -0.00974        0.05043       -1.30457        1.44514       -0.04270        0.10182       -0.01902        0.06196        1.09917       -1.25314       -1.28221        1.40807        -999.25       21.74400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1986111111 04:46:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.25993       23.80768       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.81949        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82086        0.00206        0.00304        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2030.00000       15.00000     2024.00000        -999.25        0.00000        -999.25     1937.00000     2097.00000       16.00000     2091.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.25600       13.72400       72.01028       68.87973        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      173.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.30000       87.40000     1338.14000        3.39000       21.98000       15.78000        1.39000        9.16000       65.00000       49.33000       46.17000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.78000       82.73000       76.53000        4.59000       98.00000      279.00000      448.00000      221.00000        0.79000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3749.56700     2261.05400     1950.80700     1304.35800     3728.55900     1444.35700     2498.26400      546.25430     3339.49600     1198.22800       35.23666       13.69477     1348.68300      817.60130     3932.95200     2646.06200       42.84119       15.67080     1974.85000      769.47360     3962.56700      871.99620     2086.86400      752.92080       47.29977       17.93357       50.86187       19.42588        -999.25        -999.25       54.73748       19.88380        0.00016        0.00017        0.00014        0.00013       -9.94000        9.81200        8.88142        8.83539        8.45329        8.45685        6.09008        6.72310        6.72596        6.14407        5.32466        5.32524        5.52014        5.46962        4.42794        4.42625        3.70121        3.69882        4.00677        4.06240        4.08374        4.03580        0.24060       18.50200        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.46000        -999.25      124.63990        9.27863      500.96910      376.22400      131.97100        8.14555      128.94230       12.44901      504.00660      381.75370     3487.83200     3137.47800      483.32380      370.66340      139.62370       17.58961     5000.00000      798.11040      490.55980      369.52760      487.64710      373.88230      142.58620       23.08629     5000.00000      900.19230     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31610        1.38479        0.00325       -0.03637        1.34540       -0.00713       -0.00833       -1.36561       -0.01108        0.00291       -1.41122        1.38204       -0.00588       -0.02289        0.00204       -0.06894        1.29521       -1.43325       -1.42038        1.33256        -999.25       11.80800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       27.40000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1989583333 04:46:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       25.15464       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.68191        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81422        0.00186        0.00216        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       15.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2092.00000       14.00000     2099.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       13.33260       17.46740       73.06460       67.93540        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      179.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        3.20000       15.80000       19.20000        1.00000        8.60000       65.80000       46.00000       41.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.60000       82.60000       75.40000        5.40000      106.00000      287.00000      450.00000      216.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.00600     2261.85300     1956.09700     1307.44000     3737.17000     1446.92700     2512.30100      549.12630     3356.07000     1203.80000       40.98158       17.15555     1350.24400      818.35300     3937.72300     2649.14400       51.78659       28.28855     1982.64300      772.51590     3976.57000      874.96670     2101.89700      758.17500       60.78324       40.73639       66.03518       41.02839        -999.25        -999.25       69.95692       36.14812        0.00016        0.00017        0.00014        0.00013       -9.94000        9.76800        8.87702        8.83048        8.44704        8.45268        6.07710        6.71196        6.71483        6.13367        5.30982        5.30923        5.50597        5.45078        4.41055        4.40851        3.68123        3.68045        3.98874        4.04639        4.06439        4.01570        0.24200       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.56000        -999.25      124.65010        9.28306      500.96660      376.19990      131.98220        8.15685      128.96710       12.44570      504.05550      381.73460     5000.00000      919.13210      483.31810      370.69550      139.62870       17.59664     5000.00000     2248.64000      490.60200      369.52090      487.65910      373.93350      142.65940       23.10938     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33206        1.41243       -0.02024       -0.02672        1.33789       -0.00710       -0.02148       -1.39675        0.00577       -0.02749       -1.38016        1.36409        0.01435       -0.04410        0.01887       -0.06005        1.30800       -1.48783       -1.39610        1.37483        -999.25       12.28800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1993055556 04:47:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       25.39148       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.31817        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83394        0.00146        0.00215        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       14.00000     2037.00000        -999.25        0.00000        -999.25     1937.00000     2091.00000       12.00000     2086.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.98920       17.39080       67.41207       70.47793        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      185.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      224.30000       87.90000     1338.14000        3.79000       19.98000       19.58000        1.39000        9.66000       64.17000       45.50000       47.50000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.98000       78.13000       79.93000        8.19000      107.00000      276.00000      437.00000      226.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.49400     2261.90500     1956.59700     1307.63300     3736.34600     1446.96300     1780.95800      549.99600     3344.17100     1203.90500       43.92352       18.03942     1350.69400      818.49580     3938.12700     2649.39000       55.48301       30.57386     1982.98200      772.70600     2819.22700      875.73060     2094.34800      758.11000       62.98505       51.63212       66.38902       50.30156        -999.25        -999.25       68.63912       38.90380        0.00028        0.00027        0.00014        0.00013       -9.95000        9.81200        8.87295        8.82916        8.44417        8.45194        6.07577        6.70943        6.71378        6.13320        5.30798        5.30660        5.50257        5.44886        4.41019        4.40532        3.68278        3.67897        3.98953        4.04022        4.06479        4.01720        0.23340       18.46900       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.79000        -999.25      124.63860        9.28614      500.96510      376.22810      131.95030        8.15144      128.57050       12.43625      504.11990      381.77410     5000.00000     5000.00000      483.30330      370.63790      139.61170       17.60244     5000.00000     2480.01900      490.53370      369.52870      487.26340      373.88970      142.70850       23.13049     5000.00000     1586.81200     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33533        1.35177       -0.00583       -0.06432        1.35339       -0.00927       -0.02217       -1.37438       -0.00878       -0.00672       -1.41657        1.37725        0.00096       -0.02823        0.01604       -0.05999        1.30708       -1.45343       -1.41141        1.35635        -999.25       13.39200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.1996527778 04:47:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       25.39148       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.41334        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85384        0.00223        0.00152        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       13.00000     2035.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       15.00000     2076.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.86660       14.53340       71.86520       71.73480        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      191.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        1.80000       18.60000       16.20000        1.60000        7.60000       62.80000       47.00000       43.80000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.00000       81.40000       79.80000        6.60000      105.00000      282.00000      442.00000      214.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.30100     2262.01100     1956.62300     1308.17000     3736.41300     1447.11600     1781.13100      549.51170     3343.97400     1204.17400       41.39460       19.89779     1350.43200      818.47140     3937.81500     2649.34200       55.03828       37.25409     1983.19300      772.75420     2818.88400      875.67440     2094.36300      758.53300       64.29170       46.61933       67.68408       41.73910        -999.25        -999.25       69.64949       36.50745        0.00026        0.00026        0.00013        0.00014       -9.94000        9.81200        8.87650        8.82983        8.44662        8.45048        6.07497        6.70973        6.71218        6.12948        5.30692        5.30764        5.50180        5.44924        4.40891        4.40824        3.68159        3.68025        3.98763        4.04731        4.06422        4.01430        0.24160       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.00000        -999.25      124.63560        9.27823      500.98210      376.20640      131.97610        8.15379      128.59420       12.45663      504.16400      381.72250     2354.42500     5000.00000      483.32230      370.63650      139.62290       17.59483     5000.00000     5000.00000      490.55630      369.53520      487.28390      373.89970      142.74210       23.08284     5000.00000     1453.04300     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31324        1.35828        0.01443       -0.06751        1.35921       -0.00163       -0.02650       -1.38841       -0.00813       -0.00553       -1.41974        1.38146       -0.00087       -0.02101        0.01057       -0.05289        1.31024       -1.44309       -1.42186        1.36033        -999.25        9.60000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2000000000 04:48:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       25.39148       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.19462        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83370        0.00285        0.00237        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       13.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2075.00000       13.00000     2079.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.58980       15.19020       69.93920       71.14080        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      197.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.30000       87.90000     1338.14000        1.59000       13.98000       16.38000        0.99000        5.33000       62.00000       45.67000       43.00000        0.79000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        9.19000       78.33000       78.73000        6.79000      104.00000      289.00000      437.00000      213.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.90400     2262.31300     1956.28900     1307.56300     3737.42000     1447.06400     2512.05700      549.78520     3355.99300     1204.19300       42.94658       21.34934     1350.53900      818.81960     3937.77100     2649.29200       53.12932       29.52171     1982.80700      772.47770     3976.26700      875.46510     2102.17500      758.54220       61.02940       43.68790       66.31351       48.84624        -999.25        -999.25       71.07396       44.28785        0.00025        0.00024        0.00014        0.00013       -9.94000        9.80100        8.87489        8.82729        8.44510        8.44981        6.07635        6.71102        6.71418        6.13334        5.30961        5.30840        5.50583        5.45204        4.41027        4.40575        3.68035        3.67637        3.98892        4.04092        4.06305        4.01433        0.24180       18.55700       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.20000        -999.25      124.64410        9.27268      500.98070      376.18800      131.95950        8.14385      128.93710       12.46605      503.98970      381.72670     3343.65500     5000.00000      483.31910      370.62480      139.61270       17.59582     5000.00000     5000.00000      490.56230      369.54460      487.62340      373.89850      142.58550       23.08998     5000.00000      942.64440     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32501        1.35210        0.00434       -0.08667        1.36800        0.00547       -0.03291       -1.40780        0.00625        0.00194       -1.39713        1.40080        0.01096       -0.01013        0.01992       -0.05019        1.31375       -1.43248       -1.40419        1.36330        -999.25       10.56000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2003472222 04:48:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       25.39148       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.35955        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87676        0.00227        0.00192        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       14.00000     2032.00000        -999.25        0.00000        -999.25     1937.00000     2077.00000       13.00000     2080.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       22.13380       15.86620       66.99799       78.00200        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      203.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.80000       87.90000     1338.14000        1.40000       24.00000       18.20000        2.80000        8.20000       60.60000       43.20000       44.60000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.20000       77.20000       86.20000        6.20000      106.00000      282.00000      441.00000      220.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3751.65200     2262.08000     1956.50700     1307.79300     3738.33800     1446.86100     2512.81700      549.00730     3356.53700     1204.40500       46.34657       24.37674     1350.85500      818.89130     3937.57700     2649.43200       54.37992       35.09689     1982.84200      772.57140     3977.04400      875.38700     2102.68100      758.25380       60.54577       38.53751       66.45373       32.62019        -999.25        -999.25       73.00959       28.23904        0.00024        0.00022        0.00013        0.00013       -9.94000        9.81200        8.87228        8.82563        8.44195        8.44860        6.07496        6.71017        6.71267        6.13228        5.31002        5.30988        5.50781        5.44977        4.41013        4.41215        3.67887        3.68632        3.98799        4.05244        4.06236        4.01916        0.24040       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.43000        -999.25      124.63990        9.28560      500.96330      376.22050      131.95480        8.14715      128.95710       12.42179      503.99770      381.75600     5000.00000     5000.00000      483.31450      370.67070      139.61610       17.58217     5000.00000      524.87590      490.56300      369.56280      487.64190      373.88710      142.58640       23.11347     5000.00000      623.98860     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32546        1.38505       -0.00771       -0.04259        1.34721       -0.00371        0.00211       -1.36165        0.00406        0.01267       -1.39183        1.41562        0.01120       -0.02431        0.01394       -0.07470        1.31517       -1.46535       -1.41135        1.35749        -999.25       11.66400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2006944444 04:49:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.09559       25.87150       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.46962        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86311        0.00114        0.00256        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       12.00000     2042.00000        -999.25        0.00000        -999.25     1937.00000     2078.00000       13.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.98960       15.59040       76.60107       67.47893        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      209.00000       80.00000        0.19000        0.00000        0.00000        0.00000        0.00000        0.00000        0.19000        0.15771        0.29964        -999.25        0.40331        0.40331        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.19000       18.78000       16.98000        0.99000        7.66000       58.33000       43.50000       37.67000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.98000       87.32000       75.93000        6.19000      108.00000      282.00000      442.00000      222.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.99400     2261.74800     1956.64000     1308.28900     3738.20800     1447.24100     2514.05900      549.51140     3358.30200     1204.41000       45.03103       33.24316     1350.89300      818.89070     3937.96100     2649.33400       54.95555       47.92145     1983.36800      772.91500     3978.42100      875.14950     2103.91200      758.59740       62.40738       60.41803       67.89207       49.25246        -999.25        -999.25       73.51200       39.56540        0.00025        0.00023        0.00013        0.00013       -9.94000        9.81200        8.87283        8.82437        8.44314        8.44624        6.07521        6.70978        6.71015        6.12866        5.30846        5.30560        5.50521        5.44818        4.40870        4.40562        3.67849        3.67863        3.98671        4.04211        4.06185        4.01526        0.24100       18.48000       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.03000        -999.25      124.63020        9.28052      500.97280      376.19070      131.94940        8.14433      128.93750       12.44922      504.00180      381.72330     5000.00000     5000.00000      483.30670      370.64480      139.61530       17.59006     5000.00000     5000.00000      490.55360      369.52370      487.63350      373.90900      142.57280       23.11618     5000.00000     3148.11100     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32347        1.36425       -0.00010       -0.06796        1.35747        0.00092       -0.03099       -1.39933        0.00184       -0.01348       -1.39580        1.37935        0.00021       -0.02172       -0.00388       -0.03626        1.30399       -1.45975       -1.42897        1.39291        -999.25        9.74400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2010416667 04:49:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.31747       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.87757        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86065        0.00253        0.00328        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       12.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       14.00000     2088.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.93260       19.86740       73.06440       74.13560        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      215.00000       80.00000        0.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        3.00000       19.20000       21.40000        0.80000        7.00000       66.80000       46.40000       46.40000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.20000        0.20000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.20000       84.00000       82.80000        6.40000      106.00000      277.00000      428.00000      213.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.23000     2261.89100     1956.49500     1307.59500     3737.95900     1447.17500     2513.14000      549.17720     3357.46300     1203.93400       44.82464       28.29459     1350.86500      818.87240     3937.54400     2648.81200       54.57249       34.61285     1983.03900      772.52410     3976.98300      875.59140     2103.02900      758.17020       61.96273       35.82088       67.28044       33.31723        -999.25        -999.25       72.30466       30.95271        0.00029        0.00028        0.00013        0.00012       -9.94000        9.80100        8.87355        8.82511        8.44333        8.44725        6.07493        6.71004        6.71278        6.13156        5.30883        5.31074        5.50606        5.45218        4.40931        4.41181        3.67940        3.68356        3.98674        4.05178        4.06332        4.01672        0.23480       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.53000        -999.25      124.63030        9.27550      500.96250      376.20270      131.95140        8.15475      128.94300       12.44763      503.99720      381.74030     3494.68700     5000.00000      483.31300      370.63480      139.61110       17.59162     5000.00000     5000.00000      490.54860      369.51100      487.63870      373.87730      142.57970       23.12688     5000.00000     3751.17700     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31736        1.35933        0.00321       -0.06068        1.35140       -0.00234       -0.03279       -1.38892       -0.00312       -0.01489       -1.40283        1.35630        0.00145       -0.01404        0.00659       -0.02023        1.30426       -1.42969       -1.41754        1.38656        -999.25       12.14400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2013888889 04:50:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.18589       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.54065        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82700        0.00279        0.00102        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2037.00000       14.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       15.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.12300       19.85700       66.94347       70.94653        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      221.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        1.79000       17.58000       20.98000        0.79000        7.16000       63.17000       45.83000       44.50000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.78000       77.53000       78.33000        4.19000      113.00000      285.00000      443.00000      214.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.74700     2261.52000     1956.79700     1307.48200     3736.72300     1447.03600     1780.14800      548.58610     3346.68900     1203.58400       43.60113       25.04083     1350.36000      818.71250     3937.46000     2648.67200       55.38850       37.02579     1982.66900      772.72060     2818.15500      875.36770     2095.99600      757.91660       62.14249       34.81702       65.58401       28.72020        -999.25        -999.25       69.02707       26.79381        0.00028        0.00026        0.00013        0.00012       -9.94000        9.80100        8.87568        8.82538        8.44447        8.44836        6.07341        6.70949        6.71223        6.13185        5.30868        5.31108        5.50481        5.44913        4.41100        4.41471        3.68232        3.68818        3.99017        4.05892        4.06450        4.01710        0.24060       18.51300       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.36000        -999.25      124.62440        9.27919      500.96220      376.19190      131.94970        8.14131      128.57470       12.44228      504.13290      381.73190     5000.00000     5000.00000      483.29530      370.64210      139.60970       17.59468     5000.00000     5000.00000      490.54560      369.52350      487.26140      373.88260      142.72090       23.08596     5000.00000     1770.01300     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32911        1.36293       -0.00475       -0.07140        1.35245       -0.00508       -0.03234       -1.40278       -0.00124       -0.00806       -1.40414        1.38222        0.00707       -0.02100        0.01565       -0.05640        1.31337       -1.44032       -1.41197        1.35405        -999.25       16.12800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2017361111 04:50:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.14066       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.12413        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86095        0.00244        0.00155        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2037.00000       14.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       15.00000     2085.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.13300       15.26700       65.73060       70.26940        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      227.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.40000       17.20000       17.00000        1.40000        7.20000       67.80000       49.00000       42.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.60000       75.60000       77.40000        4.40000      109.00000      291.00000      457.00000      229.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3751.27900     2262.09500     1956.66000     1306.97700     3737.24100     1446.96900     2512.18700      549.30510     3356.19400     1203.28100       45.25231       14.37666     1350.67100      818.29680     3937.99100     2648.65300       55.03139       28.31425     1982.83800      772.94040     3975.76300      875.16940     2102.02800      757.90620       62.16708       48.65904       66.94499       45.68172        -999.25        -999.25       70.80362       35.74372        0.00027        0.00024        0.00013        0.00012       -9.94000        9.81200        8.87259        8.83200        8.44294        8.45569        6.07519        6.70973        6.71482        6.13514        5.30866        5.30713        5.50528        5.44627        4.40964        4.40681        3.68055        3.68067        3.98737        4.04557        4.06417        4.01504        0.24180       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.73000        -999.25      124.63550        9.28126      500.95120      376.22720      131.95510        8.17007      128.94290       12.44176      503.99650      381.74470     5000.00000     5000.00000      483.29990      370.67430      139.59600       17.59258     5000.00000      526.42830      490.53730      369.58480      487.62770      373.88650      142.57660       23.09351     5000.00000      557.20230     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33564        1.39309       -0.00484       -0.03822        1.35524       -0.00873        0.00202       -1.36541       -0.00693        0.01645       -1.41780        1.41474        0.00257       -0.01639        0.01406       -0.07068        1.31514       -1.44471       -1.41983        1.34878        -999.25       13.10400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2020833333 04:51:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.14066       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.29889        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85669        0.00327        0.00262        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       11.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       14.00000     2087.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.85640       17.52360       71.21047       71.67953        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      233.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        1.39000       16.98000       18.38000        0.59000        8.83000       61.17000       45.00000       40.83000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.18000       81.53000       79.13000        4.59000      104.00000      284.00000      442.00000      219.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.71400     2261.77800     1956.61600     1307.63800     3737.33100     1447.12300     2512.27700      549.74950     3357.18400     1203.76100       44.35875       19.46352     1350.50000      818.45000     3937.24700     2649.05700       55.28584       30.57038     1982.85900      772.59060     3976.57900      875.04300     2102.55600      757.90830       62.09158       50.71974       66.08509       53.75118        -999.25        -999.25       69.68590       41.04219        0.00026        0.00023        0.00013        0.00012       -9.94000        9.81200        8.87470        8.82916        8.44376        8.45081        6.07374        6.70956        6.71379        6.13207        5.30872        5.30672        5.50540        5.45112        4.41050        4.40474        3.68155        3.67790        3.98884        4.03729        4.06455        4.01847        0.23380       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1548.00000        2.59000        -999.25      124.62710        9.26966      500.95620      376.20650      131.94500        8.13769      128.93850       12.45079      503.99690      381.72890     5000.00000     5000.00000      483.27970      370.64540      139.61270       17.59191     5000.00000     1587.41100      490.55730      369.52820      487.62780      373.90140      142.59170       23.10481     5000.00000     1163.48000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34744        1.37576       -0.02708       -0.05515        1.34349       -0.01003       -0.01837       -1.38540        0.00406       -0.00216       -1.38771        1.39047        0.01149       -0.01864        0.01520       -0.04725        1.31065       -1.45064       -1.40529        1.37590        -999.25       12.43200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       27.40000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2024305556 04:51:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.14066       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.61788        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82993        0.00127        0.00157        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       13.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       15.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.19940       18.80060       71.19720       76.20280        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      239.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.40000     1338.14000        2.60000       17.20000       20.20000        0.80000        5.80000       74.60000       56.60000       49.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.20000       80.60000       82.80000        3.80000      104.00000      276.00000      440.00000      222.00000        1.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3751.63700     2261.97800     1957.14000     1307.71000     3736.67500     1447.46500     1780.24000      549.58500     3346.13600     1204.06000       45.08530       22.64062     1350.44200      818.62150     3937.33900     2649.12000       57.19767       29.89208     1982.72900      772.55770     2817.87500      875.28170     2096.12700      758.39660       63.30987       41.15640       66.82199       45.20996        -999.25        -999.25       71.17151       42.49915        0.00024        0.00023        0.00013        0.00012       -9.94000        9.80100        8.87490        8.82810        8.44309        8.44928        6.07162        6.70831        6.71399        6.13180        5.30772        5.30910        5.50444        5.45354        4.40976        4.40697        3.68027        3.67720        3.98886        4.04226        4.06252        4.01504        0.24460       18.54600       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.86000        -999.25      124.62150        9.27348      500.98460      376.20820      131.96530        8.15919      128.56230       12.42907      504.12810      381.74870     5000.00000     1155.40800      483.28360      370.67280      139.62410       17.59607     5000.00000     2895.43700      490.55720      369.51250      487.26490      373.88970      142.70170       23.11921     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33790        1.39928       -0.00637       -0.02948        1.36041       -0.00429       -0.02303       -1.38791       -0.00521       -0.02384       -1.40810        1.35335       -0.00549       -0.03425       -0.00213       -0.04698        1.29744       -1.46061       -1.42638        1.37052        -999.25       13.72800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2027777778 04:52:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.15629       27.35053       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.86207        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84453        0.00291        0.00312        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       12.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       15.00000     2086.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.52340       18.05660       69.40500       76.06500        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      245.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        1.59000       19.18000       19.78000        1.79000        9.33000       65.00000       48.50000       43.67000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.39000       79.13000       84.12000        6.39000      104.00000      284.00000      448.00000      218.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.82700     2261.64600     1957.38400     1308.00300     3738.99100     1447.54000     2515.52400      550.17580     3360.36500     1205.05500       45.33351       30.59949     1350.88000      819.03780     3938.53100     2649.59200       58.15054       45.55957     1984.67400      773.24370     3979.76400      876.02690     2106.14900      759.15070       66.13939       67.56294       71.58643       59.68379        -999.25        -999.25       77.66347       43.03085        0.00023        0.00022        0.00013        0.00012       -9.94000        9.81200        8.87252        8.82241        8.44286        8.44662        6.07316        6.70771        6.71056        6.13141        5.30546        5.30489        5.50130        5.44628        4.40569        4.40382        3.67548        3.67695        3.98458        4.04032        4.05795        4.01358        0.24160       18.54600       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.43000        -999.25      124.62780        9.26534      500.96820      376.21640      131.95110        8.14568      128.93870       12.42308      503.98680      381.73100     5000.00000     5000.00000      483.29770      370.61880      139.62610       17.59930     5000.00000     4285.37200      490.53440      369.52590      487.62710      373.89270      142.56330       23.12226     5000.00000     2463.64500     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33003        1.35350       -0.00750       -0.06803        1.34207       -0.01363       -0.02523       -1.38287       -0.01053       -0.01139       -1.41667        1.38026        0.00017       -0.02686        0.00923       -0.04269        1.31162       -1.46966       -1.42354        1.39125        -999.25       11.66400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2031250000 04:52:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00736       27.05818       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.92734        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85068        0.00264        0.00279        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2031.00000       13.00000     2032.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       12.00000     2081.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.66620       16.33380       74.93120       74.46880        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      251.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       89.40000     1338.14000        1.80000       18.00000       17.20000        0.40000        6.80000       68.60000       50.60000       43.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.40000       84.20000       81.60000        5.00000      109.00000      288.00000      449.00000      225.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.62500     2261.94300     1957.29600     1307.48400     3738.43000     1447.01300     2514.92700      549.90750     3359.56800     1204.83900       45.40213       21.52959     1351.09800      819.03780     3938.68700     2649.74900       56.20967       35.60798     1983.67600      773.05910     3978.63700      875.19130     2105.40700      759.18670       64.09576       76.67857       70.26305       91.10831        -999.25        -999.25       77.97292       51.00230        0.00022        0.00022        0.00013        0.00013       -9.94000        9.81200        8.87297        8.82356        8.44280        8.44973        6.07390        6.70895        6.71255        6.13537        5.30708        5.30432        5.50437        5.44519        4.40651        4.40103        3.67526        3.67372        3.98418        4.03627        4.05895        4.01161        0.24060       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.09000        -999.25      124.62090        9.27307      500.95630      376.20480      131.95740        8.16312      128.93670       12.45844      504.00260      381.70630     5000.00000     5000.00000      483.27320      370.61670      139.61410       17.58921     5000.00000     5000.00000      490.54590      369.50600      487.63100      373.86990      142.59100       23.04550     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34773        1.34360       -0.02198       -0.06686        1.34224       -0.01668       -0.03782       -1.38441       -0.00938       -0.01593       -1.41148        1.34286        0.00149       -0.02012        0.01394       -0.04326        1.30568       -1.41147       -1.41158        1.33923        -999.25       14.83200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2034722222 04:53:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.88307        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84521        0.00139        0.00334        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2038.00000        -999.25        0.00000        -999.25     1937.00000     2085.00000       14.00000     2095.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.18980       12.19020       69.60520       74.87480        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      257.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.39000       19.38000       14.18000        1.79000        6.50000       66.67000       45.67000       45.00000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.59000       78.73000       82.53000        6.19000      102.00000      285.00000      441.00000      225.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.59300     2261.82100     1957.16200     1307.73500     3738.68000     1447.25600     2515.14700      549.04750     3359.21700     1204.48700       46.28429       21.47207     1350.89800      818.76650     3938.37800     2649.61700       56.81750       34.39290     1983.87800      772.92940     3978.65000      875.72050     2105.96700      758.65050       64.53839       38.24807       72.28989       32.75367        -999.25        -999.25       81.91505       29.22671        0.00022        0.00021        0.00013        0.00013       -9.94000        9.81200        8.87186        8.82596        8.44200        8.44976        6.07381        6.70856        6.71283        6.13327        5.30673        5.30997        5.50407        5.44811        4.40526        4.41208        3.67256        3.68511        3.98345        4.05511        4.05573        4.01521        0.24060       18.51300       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.03000        -999.25      124.63220        9.26865      500.95800      376.19710      131.94750        8.13348      128.93360       12.47023      503.97620      381.73070     5000.00000     5000.00000      483.30860      370.63650      139.60380       17.58314     5000.00000     1420.58900      490.54450      369.53790      487.61930      373.88130      142.56320       23.09529     5000.00000      588.47360     5000.00000     1540.01100     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32356        1.36783        0.00002       -0.06490        1.35420       -0.00255       -0.01717       -1.38602       -0.00004        0.01457       -1.40308        1.40445        0.00754        0.00182        0.01511       -0.03944        1.31426       -1.41106       -1.41293        1.36457        -999.25       14.54400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2038194444 04:53:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.25623        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82893        0.00320        0.00203        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       13.00000     2027.00000        -999.25        0.00000        -999.25     1937.00000     2087.00000       13.00000     2086.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.46660       12.93340       66.73140       71.66860        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      263.00000       80.00000        0.00000        0.00000        0.20000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        1.60000       17.00000       14.40000        1.40000        7.20000       64.20000       46.60000       41.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.20000        0.20000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.00000       76.80000       79.80000        6.20000      108.00000      293.00000      456.00000      215.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.02600     2261.84500     1956.83400     1307.94900     3738.99700     1447.85800     2514.68100      550.02410     3359.44100     1204.73100       42.96584       29.40805     1350.78600      818.74690     3939.18400     2649.32700       53.98597       31.18903     1984.20200      772.57350     3979.00000      875.72300     2105.10900      759.13180       63.22583       40.38300       69.33376       50.19426        -999.25        -999.25       75.53141       55.85566        0.00021        0.00020        0.00013        0.00013       -9.94000        9.80100        8.87358        8.82626        8.44508        8.44690        6.07705        6.71044        6.71362        6.13089        5.30778        5.30933        5.50339        5.45572        4.40731        4.40534        3.67701        3.67269        3.98582        4.03970        4.05985        4.01146        0.23440       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.79000        -999.25      124.62280        9.27453      500.96990      376.18860      131.95660        8.13111      128.92720       12.41769      503.99930      381.72600     3031.13800     5000.00000      483.31130      370.63940      139.61990       17.57841     5000.00000     3570.28300      490.54790      369.51610      487.63450      373.87250      142.58230       23.07587     5000.00000     1631.32800     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31149        1.36488        0.00838       -0.06415        1.34999       -0.00305       -0.02470       -1.38984       -0.00930       -0.00708       -1.40872        1.38495       -0.00567       -0.02862        0.00265       -0.06750        1.29273       -1.45481       -1.41707        1.34982        -999.25       13.39200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2041666667 04:54:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.06667        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83471        0.00202        0.00281        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       14.00000     2037.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       14.00000     2085.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.78960       15.99040       65.20499       74.67500        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      269.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.59000       18.98000       17.78000        1.39000        8.00000       65.34000       47.00000       39.67000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.59000       75.13000       82.93000        6.59000      102.00000      280.00000      431.00000      210.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3752.44800     2261.73300     1957.19400     1307.95800     3738.95100     1447.44200     2514.67800      549.79980     3359.92400     1205.14600       45.51291       35.44833     1351.21100      818.84430     3938.90300     2649.04500       56.37479       37.50087     1984.21500      772.57810     3978.81000      875.70740     2105.91000      758.92330       64.13925       42.74526       70.19709       43.05777        -999.25        -999.25       77.91480       38.74355        0.00021        0.00019        0.00014        0.00012       -9.95000        9.80100        8.87183        8.82480        8.44270        8.44595        6.07483        6.70885        6.71213        6.12991        5.30705        5.30866        5.50322        5.45318        4.40655        4.40775        3.67531        3.67905        3.98542        4.04309        4.05779        4.01684        0.24060       18.51300       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.66000        -999.25      124.61840        9.26756      500.96920      376.20640      131.94470        8.14071      128.92510       12.41906      503.97180      381.70970     3096.63600     5000.00000      483.29670      370.66020      139.60910       17.58864     5000.00000     1148.96000      490.53010      369.52330      487.61930      373.86230      142.55900       23.08714     5000.00000     1256.40400     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32172        1.39266        0.00727       -0.03892        1.36017       -0.00200       -0.01452       -1.38222       -0.00645       -0.00344       -1.41464        1.38264        0.00045       -0.01651        0.01388       -0.04042        1.30579       -1.44325       -1.41278        1.37746        -999.25       12.76800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2045138889 04:54:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.87564        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86613        0.00325        0.00159        3.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       14.00000     2033.00000        -999.25        0.00000        -999.25     1937.00000     2080.00000       14.00000     2079.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.19980       12.60020       73.19820       73.80180        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      275.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.20000       17.20000       14.40000        1.60000        7.20000       61.80000       46.40000       46.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.40000       82.80000       81.60000        6.00000       99.20000      272.00000      419.00000      216.00000        1.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3751.94200     2261.80200     1956.90400     1308.01100     3739.06200     1447.29900     2515.22200      549.52550     3360.10500     1204.77000       42.95500       20.97197     1350.56500      818.66180     3938.67500     2649.15100       54.31179       47.04046     1984.06200      773.34900     3978.58100      875.48980     2105.99600      759.12320       64.05592       74.36491       71.70122       50.99577        -999.25        -999.25       79.83953       39.28657        0.00020        0.00019        0.00014        0.00013       -9.92000        9.81200        8.87481        8.82700        8.44509        8.44997        6.07561        6.71022        6.71030        6.12991        5.30711        5.30444        5.50415        5.44365        4.40562        4.40520        3.67397        3.67878        3.98304        4.04527        4.05791        4.01184        0.24160       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.43000        -999.25      124.62070        9.28640      500.96060      376.21900      131.95590        8.16248      128.94260       12.42811      503.99450      381.71770     3130.14500     5000.00000      483.31520      370.64070      139.62320       17.58672     5000.00000     1667.40000      490.54640      369.53690      487.64690      373.86980      142.56950       23.11099     5000.00000     1262.46700     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.30550        1.35435        0.00677       -0.05834        1.33740       -0.00804       -0.01888       -1.36769       -0.01211       -0.00351       -1.40950        1.37445       -0.00641       -0.01384       -0.00167       -0.02575        1.29562       -1.44170       -1.42502        1.39325        -999.25       11.66400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2048611111 04:55:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.54523        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82810        0.00267        0.00375        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       13.00000     2032.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       14.00000     2079.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.65560       16.72440       72.60480       61.88520        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      281.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       87.90000     1338.14000        3.99000       19.58000       18.58000        0.79000        9.16000       66.00000       49.83000       39.50000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.99000       81.73000       69.14000        5.39000      107.00000      285.00000      435.00000      222.00000        0.79000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3752.85700     2261.75100     1956.88900     1308.25800     3738.94700     1447.09800     2514.99100      549.54190     3360.12400     1204.36000       41.09193       32.12371     1350.43100      818.83790     3938.45000     2649.46200       53.25601       42.13718     1983.82700      772.63060     3978.86300      875.31950     2106.57200      758.96330       63.28483       48.25183       71.18810       49.10606        -999.25        -999.25       81.64780       46.86584        0.00020        0.00019        0.00015        0.00012       -9.94000        9.81200        8.87780        8.82494        8.44693        8.44640        6.07518        6.71094        6.71119        6.12929        5.30774        5.30723        5.50491        5.45052        4.40594        4.40566        3.67274        3.67524        3.98445        4.04332        4.05558        4.01071        0.23340       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.56000        -999.25      124.61040        9.26659      500.96250      376.18940      131.93950        8.16583      128.92790       12.47882      503.97530      381.70830     3171.48400     5000.00000      483.29190      370.64060      139.60490       17.58252     5000.00000     5000.00000      490.53350      369.52080      487.61550      373.86650      142.55740       23.06889     5000.00000     1519.72100     5000.00000     1718.41700     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.31850        1.37404        0.00620       -0.05143        1.35753       -0.00035       -0.03157       -1.39316       -0.00113       -0.00612       -1.40598        1.35492        0.00465        0.00014        0.01122       -0.01837        1.31238       -1.38763       -1.41783        1.36054        -999.25       12.28800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2052083333 04:55:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      118.04105        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82646        0.00131        0.00329        7.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       15.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       13.39960       12.40040       75.39780       76.80220        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      287.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.40000       15.40000       14.00000        1.20000        7.20000       64.80000       45.80000       41.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.60000       84.80000       84.00000        5.00000       97.20000      305.00000      458.00000      231.00000        1.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.19900     2261.92700     1957.60300     1307.94700     3738.73500     1447.16200     2515.16500      549.78730     3360.10200     1204.72300       46.06700       34.13405     1350.97100      819.09520     3938.79500     2649.21600       57.27947       44.94146     1983.91900      772.89090     3978.72800      875.52980     2105.54000      758.96240       64.86481       58.34830       70.57136       53.46318        -999.25        -999.25       77.40083       43.03735        0.00018        0.00018        0.00014        0.00012       -9.94000        9.81200        8.87280        8.82288        8.44220        8.44612        6.07278        6.70826        6.71067        6.13054        5.30647        5.30583        5.50402        5.44798        4.40632        4.40479        3.67567        3.67695        3.98356        4.04152        4.05978        4.01334        0.25900       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.06000        -999.25      124.62060        9.26286      500.95970      376.19460      131.95340        8.16916      128.93810       12.43217      503.99130      381.71160     5000.00000     1163.89400      483.29580      370.66380      139.61070       17.57983     5000.00000     1619.34400      490.55400      369.53330      487.62280      373.90190      142.57550       23.08592     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.32482        1.40099       -0.00441       -0.02956        1.34903       -0.00455       -0.01858       -1.38525        0.00072       -0.02009       -1.39948        1.36411        0.00823       -0.03520        0.01258       -0.05141        1.31528       -1.46978       -1.41579        1.37431        -999.25       14.68800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2055555556 04:56:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.92714        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82437        0.00147        0.00333        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2037.00000       13.00000     2027.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       15.00000     2090.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.25660       16.92340       77.00187       70.67813        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      293.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      226.20000       88.40000     1338.14000        1.39000       18.58000       18.18000        1.19000        6.16000       67.00000       49.67000       47.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.98000       87.52000       79.73000        7.59000      105.00000      285.00000      439.00000      219.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.82400     2262.01100     1957.19300     1308.13700     3738.65500     1447.37600     2513.96600      549.39270     3359.08600     1204.50000       42.73538       21.30044     1350.31000      818.59010     3938.71800     2649.11400       54.35674       42.88237     1983.64400      773.09230     3977.98500      875.44280     2105.41100      759.27890       62.94056       54.31970       69.33438       48.29939        -999.25        -999.25       78.20438       45.20795        0.00018        0.00018        0.00013        0.00013       -9.94000        9.81200        8.87618        8.82857        8.44530        8.44983        6.07442        6.71018        6.71105        6.12895        5.30802        5.30628        5.50504        5.44700        4.40731        4.40593        3.67510        3.67596        3.98608        4.04690        4.05769        4.00811        0.24160       18.54600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.63000        -999.25      124.61480        9.26959      500.92470      376.19270      131.93230        8.15007      128.92700       12.43570      503.96920      381.72050     5000.00000     5000.00000      483.26870      370.65040      139.59470       17.58522     5000.00000     5000.00000      490.53270      369.51620      487.61740      373.86440      142.56510       23.07652     5000.00000     2265.72100     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34617        1.38080       -0.02986       -0.04886        1.33008       -0.01940       -0.02679       -1.39257       -0.00553       -0.01066       -1.39961        1.36611        0.00825       -0.01874        0.01851       -0.04511        1.30953       -1.42871       -1.40408        1.35600        -999.25       12.62400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2059027778 04:56:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.79826        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84856        0.00242        0.00391        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       14.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       14.00000     2077.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.06640       13.73360       66.19780       73.60220        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      299.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        0.38737        0.41436        0.41436        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       88.40000     1338.14000        1.60000       17.40000       14.80000        0.80000        7.00000       64.80000       46.60000       43.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.00000       77.00000       82.20000        6.40000      104.00000      302.00000      465.00000      211.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.55800     2261.81400     1956.82500     1307.92600     3738.60200     1447.25000     1782.69200      549.73910     3350.14800     1204.81100       46.05280       26.07603     1351.45600      818.85280     3938.33400     2649.22400       57.07448       42.60503     1984.31600      773.00350     2820.82700      875.53220     2099.12100      759.12720       64.61870       59.57467       69.43103       54.09660        -999.25        -999.25       74.22255       43.81002        0.00017        0.00016        0.00013        0.00013       -9.95000        9.81200        8.87051        8.82502        8.44221        8.44799        6.07521        6.70839        6.71110        6.13071        5.30666        5.30569        5.50197        5.44724        4.40722        4.40469        3.67797        3.67659        3.98600        4.04231        4.06053        4.01209        0.24280       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.76000        -999.25      124.62230        9.27440      500.97590      376.19090      131.95200        8.15280      128.57050       12.42973      504.14320      381.74170     5000.00000     5000.00000      483.28590      370.64440      139.62920       17.58757     5000.00000     5000.00000      490.54680      369.52900      487.26760      373.85220      142.73030       23.10920     5000.00000     1404.21400     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33640        1.37001       -0.01281       -0.06154        1.34674       -0.01002       -0.02902       -1.39669       -0.00582       -0.00507       -1.40518        1.37623        0.00130       -0.01023        0.00994       -0.03592        1.30283       -1.42251       -1.41290        1.36750        -999.25       13.24800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2062500000 04:57:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.62170        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83112        0.00163        0.00300        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       11.00000     2032.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       18.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.92280       13.85720       71.47747       77.80253        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      305.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       88.90000     1338.14000        2.19000       20.58000       14.98000        0.59000        8.00000       66.50000       48.83000       43.83000        0.59000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.58000       81.53000       85.32000        4.99000      106.00000      290.00000      448.00000      220.00000        0.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3752.12200     2261.93000     1956.16100     1308.12200     3738.95700     1447.29000     2514.06100      549.48610     3359.64000     1204.66900       42.10444       23.02747     1350.76300      818.79460     3938.31000     2649.42300       53.12266       46.52390     1984.20800      773.25870     3978.71900      875.39120     2105.91700      758.87510       62.51065       67.77950       69.30346       48.69734        -999.25        -999.25       77.37090       37.06853        0.00017        0.00016        0.00013        0.00013       -9.94000        9.81200        8.87396        8.82608        8.44592        8.44912        6.07811        6.71103        6.71039        6.13006        5.30837        5.30487        5.50326        5.44462        4.40734        4.40580        3.67569        3.67994        3.98735        4.04491        4.05703        4.01395        0.23840       18.49100        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.56000        -999.25      124.61740        9.27086      500.96130      376.19680      131.94190        8.15258      128.92880       12.42884      503.98020      381.73740     5000.00000     5000.00000      483.27530      370.62560      139.60930       17.58484     5000.00000     5000.00000      490.52860      369.54080      487.61850      373.89460      142.56790       23.08612     5000.00000     1721.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34206        1.35472       -0.01241       -0.07169        1.35197       -0.01085       -0.02553       -1.38806       -0.00672       -0.00773       -1.41330        1.38822        0.00315       -0.03356        0.01619       -0.07464        1.31024       -1.46575       -1.41222        1.34869        -999.25       17.08800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2065972222 04:57:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       26.97865       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.12764        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83512        0.00279        0.00311        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2033.00000       15.00000     2035.00000        -999.25        0.00000        -999.25     1937.00000     2093.00000       14.00000     2090.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.19960       14.20040       72.79840       71.80161        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      311.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.00000       17.80000       15.40000        0.80000        8.60000       67.00000       47.80000       48.60000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.20000       81.40000       78.80000        5.40000      108.00000      284.00000      447.00000      212.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.73900     2261.83300     1956.49700     1307.69600     3738.76700     1447.80400     2515.05400      549.77330     3359.81500     1204.95500       42.86005       22.84632     1351.19000      818.69420     3938.86600     2649.64200       54.37037       28.81385     1984.46200      772.74260     3979.00600      875.37930     2105.49000      759.08290       64.41174       41.40638       70.92117       49.27690        -999.25        -999.25       76.46392       47.06443        0.00017        0.00016        0.00013        0.00013       -9.94000        9.81200        8.87264        8.82678        8.44518        8.44919        6.07784        6.71018        6.71455        6.13361        5.30683        5.30903        5.50171        5.45350        4.40610        4.40561        3.67634        3.67515        3.98455        4.04025        4.05924        4.01363        0.23400       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.26000        -999.25      124.61350        9.27438      500.96260      376.18820      131.94990        8.13711      128.94350       12.44250      503.99740      381.74810     5000.00000     5000.00000      483.26720      370.66790      139.61140       17.59077     5000.00000     1412.49100      490.53290      369.54910      487.63280      373.86320      142.57400       23.09577     5000.00000      641.44530     5000.00000     2790.14200     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34625        1.39353       -0.01500       -0.05577        1.35120       -0.01322       -0.01711       -1.40253       -0.00867        0.01182       -1.41704        1.41203       -0.00036       -0.00533        0.00896       -0.05881        1.31068       -1.42069       -1.42340        1.34769        -999.25       10.84800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       27.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2069444444 04:58:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       27.31418       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.74026        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83869        0.00161        0.00137        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       14.00000     2029.00000        -999.25        0.00000        -999.25     1937.00000     2085.00000       12.00000     2096.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.52280       14.65720       70.54407       76.53593        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      317.00000       80.00000        0.00000        0.00000        0.19000        0.00000        0.00000        0.00000        0.19000        -999.25        -999.25        0.37648        0.40331        0.40331        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.39000       17.38000       15.98000        0.79000        8.00000       65.33000       49.17000       45.17000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.18000       81.13000       84.52000        5.39000      108.00000      279.00000      440.00000      222.00000        0.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3752.53600     2261.63800     1957.88000     1308.48300     3739.52700     1448.05400     1782.96900      550.03140     3349.81000     1205.34500       44.65921       34.49706     1350.80800      818.71370     3939.38000     2649.17000       56.34653       49.13113     1984.23200      773.22540     2821.46900      875.70500     2100.18800      759.23950       63.59592       64.72115       69.82787       55.52737        -999.25        -999.25       80.25511       44.06326        0.00016        0.00016        0.00013        0.00013       -9.94000        9.81200        8.87463        8.82582        8.44348        8.44607        6.07284        6.70886        6.70995        6.12684        5.30748        5.30517        5.50448        5.44957        4.40684        4.40446        3.67368        3.67647        3.98663        4.03941        4.05524        4.01465        0.24040       18.49100        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        3.03000        -999.25      124.61670        9.26864      500.95890      376.19530      131.93690        8.14582      128.57300       12.41822      504.11620      381.71700     5000.00000     5000.00000      483.26230      370.65850      139.60870       17.57943     5000.00000     1254.58000      490.53150      369.53030      487.24690      373.87520      142.69440       23.08926     5000.00000     1554.15500     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.35440        1.38990       -0.02456       -0.04242        1.35011       -0.01290       -0.01571       -1.38415        0.00071       -0.00644       -1.40544        1.38449        0.01063       -0.02424        0.01492       -0.05170        1.32610       -1.45702       -1.42186        1.37222        -999.25       14.54400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2072916667 04:58:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.09967       26.95300       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      118.59944        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85128        0.00178        0.00322        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       14.00000     2079.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.39940       16.20060       68.66500       73.13499        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      323.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.60000       20.40000       17.60000        0.80000        8.80000       61.00000       46.80000       45.00000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.80000       77.80000       80.60000        5.80000      100.00000      283.00000      445.00000      219.00000        1.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3752.69500     2261.59200     1957.47100     1307.84100     3739.21100     1447.37800     2515.42600      549.74240     3360.02200     1204.75200       43.83871       18.41885     1350.68200      818.40820     3938.55500     2649.25000       55.72697       38.20319     1983.96100      773.21810     3979.34000      875.63140     2105.44400      758.99540       64.13472       63.67929       69.85521       52.12148        -999.25        -999.25       77.22291       40.27168        0.00020        0.00019        0.00013        0.00013       -9.95000        9.81200        8.87580        8.82889        8.44425        8.45163        6.07283        6.70927        6.71198        6.13136        5.30705        5.30527        5.50494        5.44560        4.40681        4.40501        3.67579        3.67828        3.98399        4.04324        4.05997        4.01317        0.24160       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        2.43000        -999.25      124.60710        9.26106      500.94440      376.20390      131.93060        8.13150      128.93310       12.42388      503.98850      381.73620     5000.00000     5000.00000      483.26770      370.64560      139.60340       17.58010     5000.00000     1315.32600      490.54020      369.50320      487.62230      373.85750      142.57930       23.08339     5000.00000     1397.17400     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.33939        1.38457       -0.02162       -0.03926        1.34099       -0.00994       -0.01629       -1.37625        0.00212       -0.00501       -1.39040        1.37168        0.00988       -0.02199        0.01297       -0.05557        1.31075       -1.43357       -1.40921        1.34715        -999.25       11.66400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2076388889 04:59:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.19955       23.04178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      118.20671        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.80269        0.00173        0.00340        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       14.00000     2035.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       16.00000     2075.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.39000       11.99000       69.87100       66.80900        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      329.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       88.40000     1338.14000        1.99000       17.38000       13.98000        1.99000        6.66000       67.17000       48.50000       42.17000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.99000       78.53000       73.13000        3.99000      105.00000      279.00000      442.00000      207.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3751.17900     2260.70900     1954.40700     1306.58100     3729.13700     1444.16500     1778.19400      548.86570     3325.44300     1196.97700       40.45464       23.25445     1349.64200      818.15220     3936.06400     2647.96400       46.96994       22.89249     1975.77800      770.02320     2815.49400      874.10130     2079.90000      752.75420       52.69094       28.02388       59.27908       32.14194        -999.25        -999.25       63.91932       29.27201        0.00021        0.00019        0.00013        0.00013       -9.94000        9.81200        8.87898        8.82821        8.44757        8.44903        6.08094        6.71724        6.71806        6.13551        5.31719        5.31431        5.51740        5.46226        4.41773        4.41238        3.68857        3.68506        3.99151        4.04191        4.07614        4.02865        0.23320       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1548.00000        3.13000        -999.25      124.62150        9.26726      500.94090      376.20010      131.93830        8.13511      128.56890       12.44561      504.13410      381.72300     5000.00000     5000.00000      483.27320      370.64290      139.60780       17.57968     5000.00000     1458.17700      490.53380      369.51780      487.25660      373.87830      142.72370       23.05687     5000.00000     1044.83600     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.34832        1.37569       -0.02873       -0.05035        1.33313       -0.01963       -0.01745       -1.37961       -0.00651       -0.00015       -1.40448        1.38265        0.00682       -0.02213        0.01636       -0.06782        1.31226       -1.43272       -1.41040        1.33391        -999.25       15.02400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2079861111 04:59:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.27354       15.20200       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.11280        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82076        0.00394        0.00255        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2030.00000       12.00000     2030.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       14.00000     2074.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.86640       13.93360       69.26320       68.53680        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      335.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.20000       17.80000       15.60000        1.40000        8.40000       65.80000       48.80000       43.60000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.20000        0.20000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       15.80000       81.60000       77.40000        5.40000      105.00000      279.00000      429.00000      223.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3548.61900     3183.44600     2120.10300     1498.65300     2970.78700     2902.04200      120.84530       38.67188     3116.57300     3488.38800      200.00000      200.00000     1831.41900     1608.10000     3237.56700     2255.30300      300.00000      300.00000     1615.10800     1541.87900      222.20430       76.32233     1711.02400     1887.11000      500.00000      500.00000        3.80075        0.49714        -999.25        -999.25        2.08110        0.32246        0.00020        0.00018        0.00012        0.00012       -9.94000        9.81200        5.74543        5.93169        4.95156        4.97622        3.67724        4.67600        4.70891        3.55008        4.92900        5.14915        5.29340        5.49307        5.29427        5.67867        5.24325        5.58989        5.29045        5.90513        5.20843        5.33656        0.23520       18.54600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.46000        -999.25      161.07160       19.32837      192.25640      412.83290      196.92950       19.76341      157.02990       18.07967      237.11880      389.29670        6.07829     5000.00000      521.04660      379.57000      180.80580       53.95277        8.92891     5000.00000      195.03640      379.42270      506.43940      382.61050      235.25500       29.31736       12.50867     5000.00000       15.05305     5000.00000       16.65064     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -0.02501        0.24164        6.14466       -0.34020       11.45062        5.24778       -0.60196       -1.11992        4.59809       -1.57144       -1.89314       -0.34071        4.41041       -2.33035        4.43755       -2.17096       10.59050       -4.53086       -1.86386        0.02070        -999.25        7.00800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2083333333 05:00:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       15.23937       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.03978        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84344        0.00233        0.00242        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2028.00000       12.00000     2034.00000        -999.25        0.00000        -999.25     1937.00000     2088.00000       12.00000     2085.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.92240       17.25760       64.67160       71.20840        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      341.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.80000       88.40000     1338.14000        3.19000       21.18000       18.58000        0.39000        8.66000       62.83000       46.17000       49.50000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.88000       10.19000       73.13000       77.93000        4.99000       99.17000      291.00000      455.00000      224.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3570.15400     3308.88600     2328.25100     1616.40200     3041.49900     2985.00100      113.51560       41.40900     3293.02400     3556.51800      200.00000      200.00000     1906.86500     1737.88300     3183.23800     2285.69700      300.00000      300.00000     1668.55400     1604.47000      159.93440       63.86932     1825.79900     1936.65700      500.00000      500.00000      500.00000        4.46958        -999.25        -999.25       10.95311        0.96442        0.00020        0.00018        0.00013        0.00012       -9.94000        9.81200        5.44734        5.59322        4.26738        4.47723        2.71679        4.10163        4.32874        3.00939        4.07147        4.42828        5.21494        5.39226        4.09690        4.56860        4.04232        4.50167        2.97772        3.76395        5.12284        5.27945        0.24020       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      163.84960       20.12842      193.02000      409.88600      202.72440       21.04626      163.44640       25.59354      239.55610      388.49730       16.82598     5000.00000      522.42150      379.52810      186.60960       54.08203       27.13639     5000.00000      200.16840      380.25600      516.39380      392.97620      236.97870       27.93347       34.53724     5000.00000       36.35047     5000.00000       41.51567     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.42807       -0.60028        2.73798       -2.39729        6.41042        2.21119       -2.46286       -4.19598        2.12213       -3.27816       -2.55602       -0.79025        2.29735       -4.01475        2.29913       -3.92289        7.05263       -7.38263       -2.57747       -0.56388        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2086805556 05:00:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       15.23937       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.56830        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85819        0.00194        0.00159        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2029.00000       14.00000     2037.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       16.00000     2082.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.39960       15.60040       74.46420       77.33580        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      347.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.80000       88.40000     1338.14000        2.40000       18.40000       17.20000        1.20000        8.80000       63.00000       48.00000       44.60000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.88000       11.60000       83.60000       84.00000        4.20000      116.00000      284.00000      441.00000      215.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3568.62200     3314.78700     2323.24200     1618.94400     3039.35300     2989.22800      110.21270       39.14581     3295.75600     3562.81400      200.00000      200.00000     1904.84400     1739.97900     3202.54400     2296.80400      300.00000      300.00000     1667.38400     1606.36200      157.53660       60.79437     1827.94300     1939.14800      500.00000      500.00000      500.00000        3.84747        -999.25        -999.25        9.42466        0.92313        0.00018        0.00017        0.00013        0.00012       -9.97000        9.81200        5.45282        5.59823        4.30711        4.49470        2.78801        4.13861        4.34474        3.03785        4.12058        4.45133        5.21491        5.39431        4.15878        4.59997        4.10272        4.53411        3.10300        3.82356        5.11985        5.28364        0.23880       18.55700        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.13000        -999.25      164.12490       20.12164      193.06370      409.96310      202.76990       21.11643      163.45620       25.85846      239.83860      388.46120       14.96437     5000.00000      522.77290      379.52430      186.19180       53.97262       23.71331     5000.00000      200.23750      380.34400      515.35780      393.45450      237.24510       27.88867       27.95767     5000.00000       27.78011     5000.00000       31.83120     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.35205       -0.59735        3.01986       -2.30629        6.87195        2.46687       -2.36443       -4.00949        2.51077       -3.27600       -2.53239       -0.77246        2.82214       -4.11917        2.80409       -4.04049        8.09840       -7.59604       -2.59349       -0.57248        -999.25        5.42400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2090277778 05:01:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       15.23937       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.07289        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86037        0.00167        0.00226        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2031.00000       13.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2082.00000       13.00000     2089.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.58960       14.39040       76.80148       70.27853        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      353.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.79000       18.98000       16.38000        1.59000        6.16000       73.67000       52.67000       42.00000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.18000       87.12000       78.73000        6.59000      100.00000      296.00000      462.00000      231.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3583.85200     3319.42900     2323.96900     1623.52800     3038.78100     2996.71900       96.37054       36.62994     3276.64800     3562.38500      200.00000      200.00000     1915.21700     1744.39500     3193.77000     2300.65000      300.00000      300.00000     1664.39900     1608.96000      139.51320       56.73401     1815.09000     1937.61600      500.00000      500.00000      500.00000        4.00323        -999.25        -999.25        8.30008        0.93472        0.00019        0.00016        0.00013        0.00012       -9.94000        9.81200        5.44264        5.58837        4.28272        4.48037        2.76147        4.12627        4.33919        3.02782        4.14852        4.44682        5.22884        5.40202        4.22017        4.59164        4.16253        4.52484        3.21342        3.80014        5.13063        5.28946        0.24060       18.51300        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.16000        -999.25      164.26210       20.12882      193.91070      410.20050      203.70860       21.27578      164.06850       26.99995      240.43760      388.78500       15.94311     5000.00000      522.81650      379.51730      187.21490       54.18966       25.13775     5000.00000      201.16580      380.50610      516.23730      393.35460      237.78230       28.21297       29.72009     5000.00000       29.93002     5000.00000       34.73994     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.44560       -0.61154        2.86421       -2.30748        6.69580        2.35282       -2.35713       -3.98919        2.39475       -2.95920       -2.54276       -0.76967        2.67048       -3.49768        2.62667       -3.42017        7.83119       -6.35470       -2.65537       -0.57201        -999.25        5.56800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2093750000 05:01:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       15.23937       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.69292        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81600        0.00224        0.00305        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2030.00000       13.00000     2025.00000        -999.25        0.00000        -999.25     1937.00000     2085.00000       15.00000     2083.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.66660       14.53340       81.73200       70.06800        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      359.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        1.40000       19.00000       15.80000        1.20000        6.40000       63.20000       45.80000       45.80000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.40000       90.80000       77.80000        6.40000      105.00000      291.00000      452.00000      216.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3554.19400     3312.93400     2316.67500     1624.38400     3011.33500     2991.77200       97.09503       38.85712     3235.08900     3555.20500      200.00000      200.00000     1899.00500     1742.17700     3185.40300     2304.04300      300.00000      300.00000     1649.47600     1606.11100      140.49840       60.26245     1791.62400     1933.95400      500.00000      500.00000      500.00000        3.89632        -999.25        -999.25        8.30372        0.92893        0.00018        0.00016        0.00012        0.00013       -9.94000        9.81200        5.44430        5.58241        4.28637        4.47975        2.76599        4.12880        4.34207        3.03604        4.14837        4.45224        5.22826        5.40306        4.21859        4.59732        4.16232        4.52945        3.20949        3.81152        5.13279        5.28837        0.24000       18.52400        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.43000        -999.25      164.74180       20.34686      194.25920      410.24190      204.72120       21.56132      163.95280       26.50420      241.39000      389.14170       15.59387     5000.00000      523.31320      379.73320      187.47070       54.12598       24.41687     5000.00000      202.20080      380.79890      516.11920      393.36550      238.75650       28.55479       29.16850     5000.00000       29.74570     5000.00000       34.52939     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.42853       -0.61362        2.91775       -2.25828        6.78848        2.40903       -2.30328       -3.88406        2.42972       -3.05594       -2.52034       -0.76243        2.68273       -3.75289        2.63863       -3.68646        7.83357       -6.86128       -2.63353       -0.58693        -999.25        6.86400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2097222222 05:02:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       15.23937       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.21696        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82256        0.00196        0.00267        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       12.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2085.00000       14.00000     2092.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.58960       16.99040       71.01027       71.07973        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      365.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       88.40000     1338.14000        2.79000       16.98000       18.98000        1.59000        8.00000       65.00000       44.17000       48.83000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       14.18000       82.13000       79.13000        4.99000      101.00000      279.00000      443.00000      213.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3547.12500     3311.33100     2315.81200     1620.04500     2994.16000     2987.96300      104.02620       38.92059     3222.08500     3554.88500      200.00000      200.00000     1894.47400     1739.38800     3190.55900     2296.30300      300.00000      300.00000     1641.05100     1604.78400      150.28900       60.15900     1785.70700     1934.44500      500.00000      500.00000      500.00000        4.21097        -999.25        -999.25        8.48596        0.94895        0.00017        0.00016        0.00013        0.00012       -9.95000        9.81200        5.44776        5.59212        4.29890        4.48500        2.78327        4.13701        4.34053        3.03005        4.14664        4.44152        5.22306        5.39917        4.20883        4.58105        4.15204        4.51363        3.19569        3.78242        5.12654        5.28539        0.23560       18.61200        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.33000        -999.25      164.75270       20.37446      193.79500      410.15100      204.73750       21.62450      163.73670       25.93032      241.46300      389.19560       15.13781     5000.00000      523.36280      379.77810      186.93150       54.14692       23.92216     5000.00000      202.18980      380.84830      515.74720      393.65880      238.83130       28.63114       28.49852     5000.00000       28.70704     5000.00000       33.07677     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -1.38986       -0.59632        2.99108       -2.29780        6.86350        2.44938       -2.35832       -3.99593        2.47381       -3.30758       -2.54764       -0.77620        2.75433       -4.18430        2.72478       -4.09976        7.98952       -7.72844       -2.63173       -0.56448        -999.25        6.38400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2100694444 05:02:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.05870       15.21106       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      119.39180        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84031        0.00273        0.00387        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2031.00000       14.00000     2040.00000        -999.25        0.00000        -999.25     1937.00000     2086.00000       12.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.39960       14.80040       69.79860       70.60140        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      371.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        3.00000       18.00000       17.00000        1.80000        9.20000       62.40000       43.80000       41.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.60000       80.00000       79.40000        7.40000      108.00000      285.00000      443.00000      204.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3604.53100     3372.52000     2335.87600     1659.08800     3027.28100     2994.63400       75.12970       26.31927     3229.57200     3548.05400      200.00000      200.00000     1909.29500     1747.71100     3453.49700     2477.01300      300.00000      300.00000     1654.23300     1603.41800      162.24490       52.09320     1786.22200     1926.81300      500.00000      500.00000        1.87624        0.50343        -999.25        -999.25        1.27870        0.32141        0.00016        0.00014        0.00013        0.00013       -9.94000        9.76800        5.51952        5.70970        4.65267        4.79206        3.39618        4.46792        4.60218        3.48118        5.18578        5.10462        5.24912        5.42594        5.96551        5.66601        5.90452        5.59402        6.68719        5.93014        5.14419        5.30302        0.24000       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.10000        -999.25      163.30790       19.82567      193.84690      410.09390      204.56370       21.50911      158.38240       26.19248      241.82300      389.18650        7.23658     5000.00000      522.36400      379.52950      182.76350       51.17572       10.31157     5000.00000      202.21470      380.83050      500.73010      387.80910      239.14300       28.66331        8.49937     5000.00000        6.66485     5000.00000        7.49971     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -0.94392       -0.29619        5.38581       -0.64004       11.08336        4.72046       -0.80185       -1.08182        6.04379       -1.00233       -2.34900       -0.67863        7.62330       -1.09369        7.47031       -1.03727       17.65228       -1.61666       -2.67999       -0.52315        -999.25        5.28000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2104166667 05:03:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.86430       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.08625        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84357        0.00160        0.00197        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2031.00000       12.00000     2027.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       11.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.18960       16.99040       77.99560       72.47440        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      377.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.19000       17.98000       18.38000        0.99000        6.66000       59.67000       41.83000       44.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.99000       87.92000       81.33000        7.79000       95.34000      292.00000      457.00000      222.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3664.52100     3375.44500     2362.74900     1649.15900     3012.61500     2992.74000       93.83026       35.48187     3202.75000     3544.33400      200.00000      200.00000     1921.16000     1747.41500     3642.08300     2463.66700      300.00000      300.00000     1647.62800     1602.83100      191.97050       65.50568     1773.01700     1926.83900      500.00000      500.00000        2.33450        0.71039        -999.25        -999.25        1.49479        0.41297        0.00017        0.00016        0.00012        0.00013       -9.94000        9.80100        5.60907        5.71870        4.90292        4.80200        3.75865        4.66968        4.60646        3.48639        5.15534        4.95359        5.24169        5.42362        5.72698        5.36077        5.66571        5.28533        6.21783        5.32545        5.13621        5.29378        0.24020       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      162.21960       19.76945      191.78680      409.67100      204.09180       21.46940      158.09620       25.18920      241.75560      389.34050        5.48104     5000.00000      521.82820      379.47150      178.98530       51.02526        7.90228     5000.00000      201.81830      380.78670      501.66780      388.44270      239.15680       28.79845        8.18099     5000.00000        7.51789     5000.00000        8.50322     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -0.39137       -0.29793        6.64041       -0.77654       12.80151        5.73656       -0.93954       -1.35428        6.20513       -1.48170       -2.27344       -0.68275        7.05055       -1.91783        6.90039       -1.86878       16.42838       -3.25346       -2.59876       -0.54200        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2107638889 05:03:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.03566       19.15972       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.83450        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.79227        0.00380        0.00228        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2027.00000       15.00000     2027.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       13.00000     2083.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.20000       13.00000       71.39900       76.20100        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      383.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        1.80000       18.00000       14.80000        1.80000        9.00000       60.40000       45.00000       42.60000        0.40000        0.20000        0.00000        0.20000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.60000       81.00000       84.80000        7.60000      112.00000      302.00000      456.00000      216.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3626.55300     3366.22500     2352.03400     1644.39300     2970.72400     2986.39500      101.63880       38.55804     3178.05500     3544.00800      200.00000      200.00000     1899.67700     1742.06400     3630.79300     2457.96700      300.00000      300.00000     1625.75700     1600.24800      200.48190       69.33350     1759.84900     1927.39700      500.00000      500.00000        2.73810        0.83553        -999.25        -999.25        1.68497        0.45542        0.00016        0.00015        0.00012        0.00012       -9.95000        9.81200        5.61629        5.72158        4.91598        4.80778        3.77116        4.67635        4.60858        3.49141        5.07631        4.89541        5.23613        5.41920        5.56621        5.24440        5.50647        5.16951        5.90031        5.09656        5.13372        5.29047        0.23300       18.53500        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.46000        -999.25      162.95420       19.98414      191.39690      409.59320      205.01130       21.66841      159.04800       25.14245      242.65030      389.45330        5.39293     5000.00000      522.68280      379.70730      178.59450       50.96156        7.82801     5000.00000      202.77460      380.98120      502.95100      388.70930      240.08730       28.91388        8.30526     5000.00000        7.76317     5000.00000        8.80003     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25       -0.27144       -0.27680        6.72163       -0.76662       12.80243        5.77619       -0.94242       -1.36836        6.14092       -1.56580       -2.23668       -0.68721        6.90304       -2.07501        6.75239       -2.02246       16.09708       -3.56687       -2.56297       -0.53946        -999.25        7.00800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2111111111 05:04:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.02754        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81847        0.00182        0.00360        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       13.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2083.00000       14.00000     2075.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.38940       14.99060       72.39600       70.07401        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      389.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.39000       18.18000       16.18000        0.59000        8.16000       68.33000       52.67000       42.17000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        8.59000       80.32000       77.33000        6.59000      107.00000      285.00000      447.00000      215.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3926.75700     3452.76600     1742.37000     1495.83100     3110.08500     2929.66900      261.45260       81.57043     3309.46700     3455.37500      200.00000      200.00000     1935.38500     1717.63000     3568.10700     2468.89700      300.00000      300.00000     1689.12300     1560.00100      244.41710       75.34454     1820.17700     1872.32000      500.00000      500.00000      500.00000      500.00000        -999.25        -999.25      700.00000      500.00000        0.00017        0.00015        0.00012        0.00013       -9.94000        9.82300        6.14534        6.06475        6.52364        5.48198        6.22595        6.05253        5.13854        4.35241        4.10166        3.69145        5.30222        5.47387        2.35475        2.37293        2.29156        2.28662       -0.58523       -0.68962        5.19289        5.32230        0.24820       18.52400        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.33000        -999.25      156.98630       18.10511      215.89520      417.81140      211.24760       22.36775      354.97590      208.08250      245.40310      389.66280        0.87053        1.85827      519.71810      378.94730      175.32240       50.45035        1.11407        2.64719      209.54260      382.08220      391.53310      227.91890      242.05480       29.34580      566.45150     5000.00000     5000.00000     5000.00000     5000.00000     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25        2.73184        0.84221       22.72635        4.33695       40.57278       20.54510        3.80247        7.36108        0.18576       -3.24999       -1.70503       -0.28557      -19.48753      -10.05371      -20.29669      -10.09072      -36.55719      -19.83635       -3.34836       -0.31695        -999.25        6.38400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2114583333 05:04:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.69278        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85075        0.00120        0.00338        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       11.00000     2035.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       15.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.46640       14.13360       65.66480       73.73520        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      395.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.80000       88.40000     1338.14000        3.20000       15.40000       16.80000        2.40000        7.20000       62.20000       46.20000       49.20000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.00000       74.80000       81.00000        5.40000      105.00000      293.00000      450.00000      217.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3681.27800     3371.47500     2300.14900     1651.24600     3054.03900     3002.26300       36.71082       15.53223     3242.10200     3550.44900      200.00000      200.00000     1933.10500     1748.86100     3566.25800     2457.51700      300.00000      300.00000     1663.99300     1604.99500      130.08150       38.13568     1790.09500     1925.81300        2.62825        2.37673        0.54364        0.23944        -999.25        -999.25        0.45170        0.17830        0.00017        0.00015        0.00012        0.00013       -9.94000        9.81200        5.59486        5.70129        4.90932        4.76862        3.80914        4.69957        4.58972        3.45369        6.37700        5.57248        5.27446        5.43950        8.12617        6.60790        8.05992        6.53432       10.98843        7.80196        5.15901        5.31339        0.24060       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.26000        -999.25      162.73600       19.84801      196.24360      410.99850      206.37380       21.77201      148.78860       30.44411      243.46330      389.48720        4.68576     5000.00000      522.31460      379.55500      181.76780       51.86473        6.54455     5000.00000      204.11400      381.13740      490.35730      385.21780      240.69860       28.98750        6.67521       20.72364        6.15959        6.68264        7.04138        7.38520        -999.25        -999.25        -999.25        -999.25        -999.25       -0.42139       -0.29299        7.45161       -0.54084       14.47572        6.56956       -0.68226       -0.86623        7.13121        0.78431       -2.25986       -0.63466        8.01393        2.34468        7.77401        2.39086       18.43130        5.22633       -2.76469       -0.49965        -999.25        6.04800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2118055556 05:05:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.41906        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87049        0.00230        0.00284        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2034.00000       12.00000     2031.00000        -999.25        0.00000        -999.25     1937.00000     2081.00000       15.00000     2095.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.12300       16.65700       69.67260       74.60741        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      401.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      222.80000       87.90000     1338.14000        2.39000       18.18000       18.38000        1.39000        7.33000       60.83000       43.33000       48.33000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        8.59000       77.53000       81.73000        6.39000      106.00000      298.00000      459.00000      216.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3654.17600     3373.69800     2294.37400     1651.77600     3017.11500     3000.31600       35.10498       14.99573     3170.98800     3545.60800      200.00000      200.00000     1918.04300     1749.36900     3580.39500     2463.10000      300.00000      300.00000     1643.79200     1603.56500      131.98390       37.45667     1750.61300     1922.19000        2.26368        2.03435        0.48933        0.22794        -999.25        -999.25        0.41219        0.17117        0.00017        0.00015        0.00012        0.00013       -9.95000        9.81200        5.59862        5.70449        4.94012        4.77896        3.86533        4.72872        4.59951        3.47062        6.51992        5.61509        5.27490        5.44161        8.38386        6.68419        8.31792        6.61181       11.50305        7.95123        5.16009        5.31789        0.23300       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.50000        -999.25      163.38850       20.03098      196.28710      411.07770      207.93590       22.21597      147.66160       26.40507      245.06750      390.08710        4.50972     5000.00000      523.03130      379.75750      181.47560       51.79700        6.27944     5000.00000      205.71370      381.57610      489.77690      385.12830      242.29670       29.58027        6.72330     5000.00000        6.49577       56.05350        7.47377       57.99689        -999.25        -999.25        -999.25        -999.25        -999.25       -0.35727       -0.27348        7.65817       -0.45142       14.81151        6.76290       -0.60521       -0.71927        7.09733       -0.16895       -2.22218       -0.63988        7.74849        0.36681        7.48668        0.41200       17.88464        1.27680       -2.77080       -0.50686        -999.25        7.20000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2121527778 05:05:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.92352        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82481        0.00150        0.00190        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2035.00000       16.00000     2028.00000        -999.25        0.00000        -999.25     1937.00000     2084.00000       13.00000     2090.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       11.86580       16.33420       75.06480       69.93520        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      407.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      222.30000       88.40000     1338.14000        3.00000       14.00000       17.60000        0.40000        8.60000       55.20000       40.60000       43.60000        0.60000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.20000       85.40000       78.40000        6.60000      104.00000      278.00000      445.00000      221.00000        1.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3625.72000     3370.67400     2279.76200     1650.05000     2986.56600     2999.02400       29.62677       14.08020     3134.80200     3544.01300      200.00000      200.00000     1903.76200     1748.14600     3560.47500     2458.73800      300.00000      300.00000     1626.72100     1602.14400      125.27310       35.75867     1729.82700     1921.13400        1.78041        1.83355        0.40665        0.21752        -999.25        -999.25        0.34645        0.16489        0.00016        0.00015        0.00012        0.00012       -9.95000        9.80100        5.59563        5.70278        4.94083        4.77353        3.87237        4.73206        4.59692        3.46430        6.77793        5.65154        5.27718        5.44557        8.89566        6.75750        8.83061        6.68357       12.52347        8.09545        5.16415        5.31875        0.24160       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.20000        -999.25      164.13670       20.25241      196.75290      411.24980      209.33850       22.54767      143.58130       29.81986      246.43350      390.43690        4.43471     5000.00000      523.83450      379.99270      181.83230       51.93063        6.18546     5000.00000      207.13070      381.91910      488.40330      385.40980      243.64730       29.94003        7.72585       26.31709        8.71882        8.47001       10.27432        9.37845        -999.25        -999.25        -999.25        -999.25        -999.25       -0.30215       -0.25973        7.75044       -0.42472       14.92058        6.83482       -0.57973       -0.68085        6.45514        0.62963       -2.20776       -0.62857        6.39492        1.93875        6.11820        1.98329       15.17799        4.41004       -2.78619       -0.49686        -999.25        5.76000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2125000000 05:06:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.79616        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82594        0.00371        0.00165        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000       14.00000     2038.00000        -999.25        0.00000        -999.25     1937.00000     2080.00000       14.00000     2084.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.18960       15.19040       65.87180       70.60820        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      413.00000       80.00000        0.00000        0.00000        0.19000        0.00000        0.00000        0.00000        0.19000        -999.25        -999.25        0.37648        0.40331        0.40331        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       88.40000     1338.14000        2.39000       17.18000       16.78000        1.19000        8.66000       59.67000       43.67000       42.83000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.19000       74.53000       77.73000        5.59000      101.00000      274.00000      426.00000      227.00000        0.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3624.63500     3373.63900     2285.33800     1651.41000     2982.81400     3000.45000       33.58887       14.91638     3119.86800     3543.00700      200.00000      200.00000     1903.20100     1749.14000     3570.25600     2463.92200      300.00000      300.00000     1623.98600     1602.81100      129.57860       37.62756     1721.34100     1920.35500        2.12531        1.89259        0.46900        0.22155        -999.25        -999.25        0.39617        0.16736        0.00017        0.00015        0.00012        0.00012       -9.95000        9.80100        5.59559        5.70548        4.94118        4.78099        3.87498        4.73428        4.60329        3.47544        6.58125        5.63993        5.28088        5.44608        8.49853        6.72860        8.43225        6.65494       11.72676        8.03685        5.16538        5.31981        0.23420       18.50200        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      164.22520       20.25074      196.46610      411.15600      209.35340       22.58034      146.53210       29.35482      246.55590      390.54030        4.46501     5000.00000      523.93250      379.99620      181.63280       51.82457        6.23787     5000.00000      207.14960      381.95410      489.59580      384.83530      243.80020       30.04437        7.05182       24.95293        7.15707        8.17878        8.27655        9.05691        -999.25        -999.25        -999.25        -999.25        -999.25       -0.29274       -0.25455        7.71284       -0.41528       14.83324        6.79448       -0.57169       -0.66854        6.87485        0.66126       -2.20383       -0.62620        7.28268        1.99434        7.01922        2.03816       16.93631        4.51955       -2.75574       -0.49591        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2128472222 05:06:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.55907        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86756        0.00226        0.00240        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2032.00000      120.00000     2068.00000        9.04134        0.00000        -999.25     1937.00000     2081.00000       41.00000     2048.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        9.04134        -999.25        -999.25        -999.25        -999.25        -999.25       17.06620       18.13380       69.06460       66.93539        -999.25        0.00000        0.06136        -999.25        -999.25        -999.25        -999.25      419.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      225.80000       88.90000     1338.14000        3.20000       19.80000       20.40000        1.80000        7.40000       65.40000       48.40000       47.40000        0.60000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      238.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.40000       79.40000       75.20000        6.20000      110.00000      295.00000      454.00000      226.00000        0.80000        1.00000        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        9.04134     3628.36500     3373.87700     2276.85200     1652.14100     2981.80400     2998.43200       25.55237       12.37396     3132.70400     3542.38900      200.00000      200.00000     1903.50900     1747.98100     3577.39400     2468.33200      300.00000      300.00000     1623.89400     1601.41200      123.70450       34.09363     1728.47000     1919.62400        1.39838        1.19680        0.33293        0.17712        -999.25        -999.25        0.28814        0.13874        0.00017        0.00015        0.00011        0.00012       -9.94000        9.81200        5.60312        5.71185        4.97227        4.79118        3.92464        4.76038        4.61116        3.48713        7.08552        5.83533        5.27843        5.44782        9.48403        7.11270        9.41886        7.03906       13.69909        8.80329        5.16515        5.32160        0.24000       18.53500        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.39000        -999.25      164.07300       20.24970      196.92910      411.30540      209.52480       22.62233      139.15190       29.35347      246.67630      390.53340        4.25629     5000.00000      523.81820      380.00910      181.60430       51.82448        5.91110     5000.00000      207.34520      382.00140      486.21350      383.77760      243.88980       30.02627        8.56794       16.44624       11.58090        6.08856       13.99053        6.76998        -999.25        -999.25        -999.25        -999.25        -999.25       -0.25473       -0.24063        7.98107       -0.33145       15.32478        7.05582       -0.49218       -0.51912        6.01037        0.96535       -2.17960       -0.62093        5.28207        2.52103        4.99111        2.55660       12.93837        5.57592       -2.78651       -0.50714        -999.25        6.67200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2131944444 05:07:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.00382        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86176        0.00170        0.00143        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2073.00000       12.00000     2056.00000        -999.25        0.00000        -999.25     1937.00000     2012.00000       10.00000     2013.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.78980       14.79020       67.81067       78.66933        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      425.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.79000       17.38000       17.18000        2.19000        7.83000       67.83000       52.33000       47.17000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.78000       78.93000       87.12000        5.79000      101.00000      292.00000      451.00000      225.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3621.20800     3376.49900     2287.52400     1653.52600     2974.66700     3001.32900       32.86743       15.96436     3132.66800     3548.91000      200.00000      200.00000     1900.43400     1750.27800     3581.24800     2468.65500      300.00000      300.00000     1620.29600     1603.57600      130.18650       38.51349     1728.30200     1923.52500        1.99953        2.64270        0.44992        0.25121        -999.25        -999.25        0.38075        0.18533        0.00017        0.00015        0.00012        0.00012       -9.96000        9.80100        5.60001        5.70719        4.95469        4.78545        3.89337        4.74358        4.60609        3.48099        6.64116        5.54361        5.27688        5.44448        8.61228        6.53442        8.54826        6.46163       11.95600        7.64923        5.16590        5.31994        0.24080       18.54600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1548.00000        0.93000        -999.25      164.18960       20.18195      196.45080      411.08440      209.44250       22.57214      146.46230       28.14735      246.81500      390.39930        4.41032     5000.00000      523.91830      379.91640      181.49700       51.76191        6.14257     5000.00000      207.27130      381.93480      488.95360      384.50100      244.05670       29.90058        6.77063       38.94491        6.73012       11.09203        7.78635       12.21947        -999.25        -999.25        -999.25        -999.25        -999.25       -0.27133       -0.26557        7.78103       -0.42526       14.95378        6.86825       -0.58171       -0.67753        7.06437        0.43516       -2.17125       -0.63729        7.57636        1.55424        7.29533        1.60222       17.50868        3.64631       -2.75832       -0.49871        -999.25        4.46400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2135416667 05:07:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.12816        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81628        0.00256        0.00298        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2057.00000       14.00000     2056.00000        -999.25        0.00000        -999.25     1937.00000     2015.00000       15.00000     2007.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.06640       16.53360       73.79720       70.80280        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      431.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.50592        -999.25        0.75792        0.75792     1675.98400        -999.25      225.80000       88.40000     1338.14000        1.80000       17.60000       17.80000        1.00000        6.80000       58.20000       43.20000       45.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.80000       82.80000       77.00000        3.40000      110.00000      280.00000      435.00000      225.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3614.86000     3369.85800     2285.02400     1653.05600     2968.22200     2998.56300       34.85901       15.77637     3103.43800     3541.72200      200.00000      200.00000     1898.36400     1747.92500     3560.73400     2462.53900      300.00000      300.00000     1616.77800     1602.27600      129.03140       38.45703     1712.96500     1920.16000        2.34957        2.47987        0.50188        0.24404        -999.25        -999.25        0.42197        0.18108        0.00017        0.00016        0.00012        0.00013       -9.94000        9.81200        5.59424        5.70178        4.93015        4.77209        3.85297        4.72195        4.59496        3.46191        6.48398        5.56090        5.27692        5.44352        8.31710        6.57865        8.25105        6.50514       11.36761        7.73938        5.16189        5.31754        0.24160       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.16000        -999.25      164.44040       20.34140      196.57680      411.14620      209.68460       22.71738      148.30130       27.53121      246.98050      390.69270        4.51923     5000.00000      524.14440      380.08030      181.86830       51.89925        6.31959     5000.00000      207.48640      382.08420      490.20640      385.81170      244.21090       30.18697        6.66825     5000.00000        6.35108       33.62964        7.31843       36.18502        -999.25        -999.25        -999.25        -999.25        -999.25       -0.29596       -0.26107        7.64666       -0.46067       14.70853        6.73274       -0.61733       -0.75305        7.13614       -0.06338       -2.19818       -0.63322        7.85991        0.59011        7.58671        0.63254       18.09488        1.71951       -2.76958       -0.50572        -999.25        5.56800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2138888889 05:08:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.34359        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83577        0.00136        0.00195        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1963.00000     2057.00000       13.00000     2047.00000        -999.25        0.00000        -999.25     1937.00000     2018.00000       16.00000     2008.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.58960       15.39040       78.80007       70.47993        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      437.00000       80.00000        0.00000        0.00000        0.19000        0.00000        0.00000        0.00000        0.19000        -999.25        -999.25        0.37648        0.40331        0.40331        -999.25        -999.25        -999.25        -999.25        -999.25     1675.98400        -999.25      222.30000       88.40000     1338.14000        2.39000       16.58000       16.98000        1.19000        9.16000       61.33000       42.33000       49.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.38000       88.92000       77.33000        3.59000      105.00000      307.00000      470.00000      223.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3587.75900     3370.52000     2279.21300     1653.08200     2936.85300     2998.44900       33.87421       15.35614     3063.56600     3541.93100      200.00000      200.00000     1884.29400     1747.75900     3569.43900     2466.33100      300.00000      300.00000     1599.73700     1601.52800      129.12690       37.83966     1690.55400     1919.81800        2.17541        2.23279        0.47831        0.23649        -999.25        -999.25        0.40334        0.17657        0.00016        0.00017        0.00012        0.00013       -9.92000        9.81200        5.59349        5.70431        4.95132        4.77967        3.89630        4.74336        4.60314        3.47514        6.55853        5.58955        5.27667        5.44725        8.44523        6.62706        8.38034        6.55272       11.62295        7.83330        5.16397        5.31960        0.23400       18.54600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.53000        -999.25      165.24670       20.56251      196.58470      411.18000      211.31760       23.12927      147.35420       28.27259      248.73940      391.18120        4.40334     5000.00000      525.01650      380.31460      181.66730       51.84993        6.14773     5000.00000      209.16180      382.50100      489.30390      385.02140      245.98440       30.67788        6.58151       49.92743        6.36137       13.03135        7.35212       14.43399        -999.25        -999.25        -999.25        -999.25        -999.25       -0.23015       -0.24793        7.78983       -0.41047       14.91736        6.86421       -0.57124       -0.66991        7.19840        0.34279       -2.15576       -0.62830        7.85185        1.35781        7.56473        1.39901       18.05026        3.25123       -2.75501       -0.50327        -999.25        7.34400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2142361111 05:08:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.00075        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.87406        0.00197        0.00250        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1976.00000     2046.00000      200.00000     2130.00000        -999.25      104.00000        -999.25     1936.00000     1811.00000      330.00000     1688.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.99960       17.20040       68.79880       69.20119        -999.25       16.00000        -999.25        -999.25        -999.25        -999.25        -999.25      443.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.98400        -999.25      221.80000       87.90000     1338.14000        2.79000       20.39000       19.19000        1.59000        6.19000       61.99000       46.19000       52.79000        0.00000        0.00000        0.00000        0.00000       32.00000        0.20000        -999.25        -999.25        -999.25       25.26324       25.26324       25.26324        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.79000       79.39000       78.59000        8.19000      105.00000      288.00000      446.00000      225.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        4.00000        -999.25        -999.25     3557.75900     3370.02200     2269.60200     1651.38400     2900.75800     2998.72600       35.85632       16.09283     3007.20900     3541.20400      200.00000      200.00000     1869.69200     1747.08700     3563.48500     2466.75500      300.00000      300.00000     1579.55800     1601.49500      132.45820       39.03839     1658.81900     1919.18800        2.31725        2.50077        0.50327        0.24711        -999.25        -999.25        0.42276        0.18301        0.00016        0.00016        0.00012        0.00013       -9.94000        9.81200        5.58813        5.70636        4.95769        4.78618        3.91851        4.75383        4.60911        3.48556        6.49733        5.55862        5.27952        5.44822        8.31042        6.55951        8.24578        6.48521       11.35026        7.69719        5.16729        5.32067        0.23980       18.59000        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.36000        -999.25      166.84970       20.91233      196.62550      411.27700      212.89000       23.51786      147.52070       28.32039      250.44800      391.65450        4.34126     5000.00000      526.69540      380.67880      181.67030       51.86374        6.10418     5000.00000      210.71990      382.88600      490.35360      385.15690      247.67090       31.14426        6.89447       50.36728        6.98319       13.58413        8.10970       15.06663        -999.25        -999.25        -999.25        -999.25        -999.25       -0.15433       -0.23355        7.86921       -0.35722       14.95523        6.89853       -0.52697       -0.58676        6.97993        0.33985       -2.17006       -0.63187        7.40116        1.31130        7.11014        1.35081       17.16707        3.16347       -2.77710       -0.51022        -999.25        6.52800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2145833333 05:09:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.93991        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85666        0.00173        0.00198        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1959.00000     2062.00000       36.00000     2038.00000        -999.25      320.00000        -999.25     1943.00000     2065.00000       18.00000     2056.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.25700       14.52300       72.67080       73.20921        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      449.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.98400        -999.25      222.30000       87.40000     1338.14000        1.19000       13.78000       16.38000        2.19000        7.33000       67.50000       47.50000       45.17000        0.79000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.19000       81.33000       79.33000        3.59000      103.00000      271.00000      426.00000      217.00000        0.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3557.65000     3370.64800     2263.25100     1652.33100     2896.91400     2996.28600       30.91095       14.22150     3005.98000     3539.54700      200.00000      200.00000     1868.95800     1746.84700     3572.50800     2469.85900      300.00000      300.00000     1577.27900     1600.52900      129.84590       36.80725     1658.09300     1917.79000        1.76478        1.60821        0.41052        0.20637        -999.25        -999.25        0.34953        0.15783        0.00016        0.00016        0.00012        0.00013       -9.96000        9.81200        5.59127        5.70917        4.98294        4.79171        3.96481        4.77803        4.61232        3.49150        6.78843        5.69983        5.28054        5.44640        8.86877        6.84091        8.80374        6.76866       12.46632        8.25976        5.16754        5.32293        0.24060       18.51300        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.46000        -999.25      166.84320       20.93529      196.94020      411.36650      213.17270       23.58741      143.56450       28.38336      250.66960      391.67910        4.15040     5000.00000      526.76680      380.71850      181.57410       51.84471        5.82288     5000.00000      211.03130      382.98310      488.43970      384.25850      247.89000       31.17676        7.50371       26.70918        8.73615        9.27983       10.37240       10.37490        -999.25        -999.25        -999.25        -999.25        -999.25       -0.07642       -0.21675        8.12594       -0.29726       15.36615        7.13063       -0.46163       -0.47826        6.58641        0.62110       -2.14140       -0.60432        6.38656        1.80085        6.07999        1.83051       15.12479        4.12485       -2.77956       -0.50235        -999.25        7.00800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2149305556 05:09:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.36985        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83600        0.00138        0.00224        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1959.00000     2043.00000       14.00000     2044.00000        -999.25        0.00000        -999.25     1943.00000     2057.00000        9.00000     2060.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26640       16.13360       71.99860       72.20140        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      455.00000       80.00000        0.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        0.29964        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.80000       88.40000     1338.14000        1.60000       15.60000       17.20000        0.80000        4.40000       70.40000       52.40000       53.40000        0.80000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.20000        0.20000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.60000       82.20000       81.00000        7.40000      110.00000      288.00000      450.00000      225.00000        0.20000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3557.56600     3366.83600     2268.42400     1653.70600     2902.50500     2995.67300       33.06152       14.59320     3014.62200     3538.96300      200.00000      200.00000     1869.50200     1745.39900     3564.34300     2466.86100      300.00000      300.00000     1580.78500     1600.62600      128.88400       38.08746     1662.76700     1918.15600        2.05324        1.55431        0.46128        0.20189        -999.25        -999.25        0.38968        0.15507        0.00017        0.00016        0.00012        0.00013       -9.94000        9.81200        5.58854        5.70655        4.96167        4.78143        3.92511        4.75686        4.60220        3.47373        6.61503        5.71245        5.27801        5.44409        8.54386        6.87600        8.48034        6.80335       11.81752        8.33263        5.16803        5.31984        0.23460       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.16000        -999.25      166.59850       20.91940      196.88640      411.33450      212.77570       23.50927      145.63930       29.16772      250.31100      391.58510        4.26651     5000.00000      526.46420      380.68650      181.76530       51.91769        5.99517     5000.00000      210.60490      382.88830      489.22370      385.33850      247.53330       31.08402        7.11429       32.79559        7.55923       10.33449        8.83756       11.46321        -999.25        -999.25        -999.25        -999.25        -999.25       -0.13423       -0.23294        7.96741       -0.35771       15.12108        6.98627       -0.52229       -0.58319        6.83314        0.51265       -2.17087       -0.62093        7.02513        1.64917        6.73425        1.68776       16.41568        3.82919       -2.77762       -0.50112        -999.25        5.56800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2152777778 05:10:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.89378        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82002        0.00301        0.00339        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1959.00000     2116.00000      103.00000     2092.00000        -999.25      104.00000        -999.25     1974.00000     2136.00000      236.00000     2285.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.31260       15.85740       71.25747       77.39253        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      461.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        0.31800        -999.25        0.35904        0.75792        0.75792     1675.10400        -999.25      221.80000       87.40000     1338.14000        2.99000       19.57000       17.38000        0.79000        9.83000       61.83000       43.00000       49.16000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       12.38000       81.11000       84.71000        4.79000      105.00000      282.00000      438.00000      216.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3551.07800     3367.08600     2266.36900     1653.91900     2895.92600     2995.78200       31.66595       14.91974     3008.49000     3540.04100      200.00000      200.00000     1865.95200     1745.99300     3563.30300     2467.12400      300.00000      300.00000     1577.18100     1599.93600      128.06880       37.98309     1659.22600     1918.90700        1.90757        1.78971        0.43531        0.21596        -999.25        -999.25        0.36904        0.16403        0.00017        0.00016        0.00011        0.00012       -9.92000        9.81200        5.58920        5.70424        4.96481        4.77859        3.93044        4.75972        4.60254        3.47353        6.69630        5.66042        5.27812        5.44815        8.70384        6.76880        8.64069        6.69375       12.13702        8.11658        5.16886        5.31909        0.23980       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.33000        -999.25      166.76100       20.93939      196.98880      411.35530      212.97280       23.52180      144.87470       28.30599      250.53650      391.60940        4.24839     5000.00000      526.62190      380.70450      181.80490       51.93630        5.95426     5000.00000      210.81580      382.91520      488.89170      384.70600      247.74390       31.11462        7.24536       36.49358        7.92742       11.21706        9.33961       12.48610        -999.25        -999.25        -999.25        -999.25        -999.25       -0.13911       -0.23492        7.99166       -0.36167       15.18385        7.01991       -0.51811       -0.58098        6.74760        0.46304       -2.15700       -0.60664        6.80850        1.53971        6.50317        1.57431       15.98302        3.59997       -2.79266       -0.49481        -999.25        6.38400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2156250000 05:10:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      107.09576        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83982        0.00214        0.00189        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1959.00000     2108.00000       97.00000     2033.00000        -999.25       96.00000        -999.25     1954.00000     1854.00000      167.00000     2022.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.26600       16.53400       70.79700       71.60300        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      467.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      221.40000       87.90000     1338.14000        3.79000       19.39000       18.99000        1.79000        8.39000       65.19000       49.39000       44.39000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.39000       81.19000       78.99000        4.39000       98.19000      280.00000      439.00000      233.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        4.00000        -999.25        -999.25     3537.77900     3367.06200     2274.65300     1653.77300     2875.71800     2995.31000       40.76996       18.50891     2984.37600     3538.35900      200.00000      200.00000     1859.40400     1745.58500     3571.09300     2465.40600      300.00000      300.00000     1566.76400     1599.98100      136.92200       42.26929     1646.69900     1917.91100        2.88959        4.89402        0.60045        0.29451        -999.25        -999.25        0.49109        0.21230        0.00017        0.00016        0.00012        0.00012       -9.97000        9.81200        5.58714        5.70620        4.95772        4.77782        3.91772        4.75203        4.59999        3.46825        6.28790        5.42237        5.27486        5.44654        7.89483        6.29664        7.83126        6.22258       10.52266        7.17288        5.16479        5.31947        0.23860       18.55700       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.93000        -999.25      167.15400       21.00699      196.35550      411.15660      213.28960       23.67922      150.21790       29.39223      250.90540      391.86330        4.36010     5000.00000      527.04280      380.76490      181.50680       51.88316        6.15378     5000.00000      211.13310      383.05240      491.88610      386.58780      248.11670       31.35312        6.50929       78.56681        6.19602       16.13133        7.17766       17.87088        -999.25        -999.25        -999.25        -999.25        -999.25       -0.11118       -0.24212        7.84492       -0.43483       14.84874        6.85948       -0.59775       -0.72657        7.25130        0.21768       -2.15642       -0.62680        7.98402        1.13307        7.68041        1.17005       18.33176        2.80446       -2.78865       -0.51020        -999.25        4.46400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2159722222 05:11:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.58617        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83600        0.00346        0.00258        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1943.00000     2229.00000      372.00000     1979.00000        -999.25      104.00000        -999.25     1914.00000     2553.00000     1535.00000     2152.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.44600       17.52400       70.79580       75.65420        -999.25       16.00000        -999.25        -999.25        -999.25        -999.25        -999.25      473.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.79000       21.57000       18.98000        0.79000        7.33000       67.33000       47.16000       44.33000        0.19000        0.00000        0.00000        0.00000       32.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000        8.39000       78.32000       82.31000        5.79000      113.00000      293.00000      454.00000      226.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        4.00000       46.00000        -999.25     3552.34800     3365.83300     2273.10100     1654.94800     2891.17200     2995.05300       36.54602       16.60309     3000.30200     3540.16600      200.00000      200.00000     1866.60300     1745.13700     3567.47900     2466.92800      300.00000      300.00000     1574.58900     1600.06600      132.14940       39.34448     1654.85100     1919.63500        2.43606        3.12798        0.52315        0.26456        -999.25        -999.25        0.43675        0.19358        0.00019        0.00015        0.00012        0.00013       -9.94000        9.81200        5.58927        5.70526        4.95706        4.77702        3.91485        4.75195        4.59905        3.46745        6.44928        5.50182        5.27813        5.44533        8.21740        6.45601        8.15386        6.38087       11.16450        7.49390        5.16812        5.31610        0.23800       18.43600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.26000        -999.25      166.78580       20.97672      196.68820      411.27180      213.00050       23.59922      148.98990       28.24986      250.72820      391.68400        4.32103     5000.00000      526.65160      380.73720      181.70570       51.92962        6.07780     5000.00000      210.83990      382.97670      490.68860      385.46220      247.95470       31.16703        6.47734       73.58452        6.21135       16.28108        7.18182       18.13865        -999.25        -999.25        -999.25        -999.25        -999.25       -0.13429       -0.23950        7.89549       -0.39958       14.98247        6.91951       -0.56167       -0.65786        7.27501        0.23281       -2.16063       -0.62251        7.97153        1.12405        7.67759        1.15549       18.30130        2.78767       -2.77350       -0.51698        -999.25        6.04800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2163194444 05:11:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.08486        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86774        0.00267        0.00168        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2032.00000       31.00000     2047.00000        -999.25       64.00000        -999.25     1946.00000     1980.00000       70.00000     2073.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.79960       16.80040       74.59740       78.80260        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      479.00000       80.00000        0.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.20000       17.60000       18.20000        1.00000        7.60000       68.80000       50.60000       43.60000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.20000        0.20000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       13.60000       85.60000       87.20000        5.80000      101.00000      283.00000      443.00000      227.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3501.88000     3368.32800     2245.01600     1651.78700     3994.79000     2995.63200       31.19019       14.26453     2913.92700     3536.66400      200.00000      200.00000     1840.94200     1745.36300     3563.21300     2471.63900      300.00000      300.00000     2175.44700     1599.41700      129.33650       37.52747     1606.08400     1915.72700        1.79011        1.45689        0.41855        0.19752        -999.25        -999.25        0.35545        0.15218        0.00019        0.00014        0.00012        0.00013       -9.94000        9.80100        5.58522        5.71057        5.00263        4.79629        4.01245        4.79993        4.61827        3.50062        6.77146        5.73970        5.27891        5.45053        8.81390        6.91355        8.75302        6.84037       12.35407        8.40184        5.17421        5.32521        0.23960       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.26000        -999.25      169.29100       21.50993      197.21110      411.51640      215.73350       24.34890      143.81760       28.24908      253.95190      392.68140        4.02346     5000.00000      529.34970      381.31440      181.66470       51.91326        5.67148     5000.00000      213.62860      383.72810      488.61440      385.24700      251.17160       32.16444        7.36885       48.49836        8.63699       14.63670       10.29643       16.33027        -999.25        -999.25        -999.25        -999.25        -999.25        0.05864       -0.19551        8.30818       -0.23649       15.54634        7.26363       -0.41971       -0.39681        6.66936        0.35253       -2.10484       -0.62078        6.43476        1.23169        6.10954        1.26229       15.20326        3.00205       -2.78029       -0.51693        -999.25        6.04800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2166666667 05:12:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      107.87823        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81096        0.00198        0.00211        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2051.00000       14.00000     2056.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2061.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.05660       17.32340       68.47179       69.00819        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      485.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.80000       87.90000     1338.14000        0.99000       14.98000       18.18000        0.79000        8.16000       70.00000       50.17000       44.50000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.19000       78.13000       77.13000        6.59000      101.00000      291.00000      449.00000      225.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3499.77100     3364.03800     2249.99700     1652.76400     4002.15400     2995.00300       34.49829       16.23993     2923.93600     3538.60200      200.00000      200.00000     1841.22600     1744.42800     3553.04200     2467.40200      300.00000      300.00000     2179.58200     1599.77300      130.77940       38.95233     1611.28000     1917.98600        2.16015        2.75731        0.48198        0.25531        -999.25        -999.25        0.40552        0.18792        0.00018        0.00015        0.00012        0.00013      -10.33000        9.81200        5.57865        5.70416        4.97579        4.78239        3.96837        4.77612        4.60570        3.48058        6.56538        5.53210        5.27841        5.44678        8.42459        6.50982        8.36483        6.43577       11.57484        7.59899        5.17594        5.31973        0.23480       18.55700       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.03000        -999.25      169.31050       21.50567      197.14410      411.49110      215.42170       24.26261      147.50870       28.79534      253.66130      392.50670        4.13936     5000.00000      529.31380      381.28670      181.85750       51.99490        5.84076     5000.00000      213.29840      383.66100      489.95200      385.72000      250.88390       31.98781        6.60202       48.33514        6.68658       14.07746        7.79016       15.87481        -999.25        -999.25        -999.25        -999.25        -999.25        0.00330       -0.21893        8.14141       -0.31233       15.28659        7.11531       -0.47426       -0.50378        7.18356        0.35368       -2.12326       -0.60163        7.60760        1.27263        7.29307        1.29270       17.55666        3.07531       -2.77731       -0.51884        -999.25        4.94400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2170138889 05:12:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      107.80078        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83283        0.00185        0.00207        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2052.00000       14.00000     2058.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       14.00000     2059.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.86600       16.93400       71.52980       74.07020        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      491.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.60000       14.80000       18.20000        0.60000        8.80000       66.80000       46.20000       44.80000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       14.40000       82.40000       81.40000        3.80000      104.00000      290.00000      454.00000      219.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3493.46200     3364.12500     2246.53700     1652.17800     3982.08300     2995.63500       36.75018       15.98114     2900.59400     3539.88900      200.00000      200.00000     1838.94800     1744.44000     3545.26200     2465.17400      300.00000      300.00000     2168.92900     1600.21800      132.07730       39.27429     1599.22600     1918.05700        2.44049        2.28380        0.52887        0.23820        -999.25        -999.25        0.44047        0.17743        0.00017        0.00013        0.00012        0.00012       -9.94000        9.81200        5.57374        5.70432        4.96954        4.78028        3.96269        4.77177        4.60322        3.47582        6.44754        5.58337        5.27730        5.44620        8.19149        6.61589        8.13008        6.54355       11.11137        7.81001        5.17154        5.32256        0.23760       18.52400        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.89000        -999.25      169.81240       21.62480      197.12970      411.51790      216.05890       24.41652      147.21120       28.45782      254.43390      392.72240        4.16255     5000.00000      529.82150      381.41840      181.91560       52.04159        5.88109     5000.00000      213.93770      383.81500      490.90910      385.33200      251.64510       32.21560        7.08466       47.27046        7.63696       13.71353        9.00117       15.38857        -999.25        -999.25        -999.25        -999.25        -999.25        0.00914       -0.20643        8.10900       -0.31295       15.21408        7.08105       -0.48110       -0.52374        6.85285        0.36135       -2.12112       -0.60155        6.97796        1.30091        6.65664        1.32699       16.30203        3.12579       -2.78876       -0.50675        -999.25        4.27200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2173611111 05:13:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      107.87979        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82420        0.00188        0.00244        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2052.00000       15.00000     2057.00000        -999.25        0.00000        -999.25     1944.00000     2072.00000       14.00000     2056.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       13.12300        9.65700       67.60500       78.86500        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      497.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      221.40000       87.40000     1338.14000        2.79000       15.58000       11.78000        1.79000        8.33000       70.83000       48.67000       45.33000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.99000       76.93000       86.52000        5.99000      108.00000      281.00000      439.00000      219.00000        0.00000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3489.44200     3362.77000     2249.35400     1651.87400     3976.31700     2995.57500       38.16986       18.12622     2891.32800     3536.93100      200.00000      200.00000     1837.48200     1744.28300     3537.50400     2461.64300      300.00000      300.00000     2165.84900     1600.46500      131.83780       41.54327     1594.23600     1916.54400        2.69387        4.73037        0.56911        0.29138        -999.25        -999.25        0.46886        0.20998        0.00017        0.00012        0.00012        0.00012       -9.94000        9.81200        5.57066        5.70160        4.95234        4.77320        3.93278        4.75599        4.59673        3.46497        6.35370        5.42837        5.27706        5.44468        8.01877        6.31234        7.95716        6.24056       10.76639        7.20387        5.17090        5.32216        0.23980       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.29000        -999.25      169.82500       21.63925      197.06980      411.42310      216.08900       24.41898      149.79300       28.61203      254.45990      392.80350        4.23589     5000.00000      529.84450      381.41640      182.07520       52.08522        6.01209     5000.00000      213.96210      383.82570      491.92700      386.02850      251.69570       32.28563        6.59853       87.28590        6.47449       18.03031        7.51859       20.41472        -999.25        -999.25        -999.25        -999.25        -999.25        0.01956       -0.22283        8.00849       -0.39652       14.99457        6.97247       -0.55235       -0.66215        7.18608        0.19529       -2.12685       -0.59333        7.76462        1.02906        7.45845        1.04548       17.86594        2.58353       -2.76419       -0.51784        -999.25        6.19200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2177083333 05:13:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.97112        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84056        0.00296        0.00313        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       14.00000     2053.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2062.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.20000       15.00000       69.26340       66.73660        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      503.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.40000       19.60000       17.40000        2.40000       10.00000       65.00000       47.20000       42.60000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       14.00000       80.00000       74.20000        4.20000      111.00000      295.00000      461.00000      224.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3501.97100     3369.31200     2246.02400     1652.32000     3986.46500     2998.18300       33.31146       15.70709     2907.43200     3539.58200      200.00000      200.00000     1842.48500     1746.78400     3556.01000     2470.44600      300.00000      300.00000     2171.13900     1601.03000      129.92830       39.21936     1602.65000     1917.27200        2.01674        1.97783        0.46065        0.22762        -999.25        -999.25        0.38883        0.17098        0.00017        0.00013        0.00012        0.00011       -9.94000        9.81200        5.57817        5.70604        4.98683        4.78973        3.99097        4.78720        4.61329        3.49362        6.63267        5.62384        5.27801        5.44918        8.54754        6.68638        8.48672        6.61395       11.82220        7.94809        5.17342        5.32537        0.23320       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.10000        -999.25      169.64120       21.56018      197.22820      411.50380      216.09540       24.41060      145.34270       30.24881      254.40170      392.77430        4.08251     5000.00000      529.68040      381.36090      181.82560       51.97236        5.75848     5000.00000      213.98880      383.78830      489.71830      385.01920      251.60690       32.28209        7.26061       17.99417        8.23255        6.65852        9.79685        7.36886        -999.25        -999.25        -999.25        -999.25        -999.25        0.03920       -0.19931        8.22219       -0.27486       15.40263        7.18647       -0.45693       -0.46861        6.73781        0.89074       -2.10661       -0.62227        6.64124        2.35129        6.30969        2.39501       15.62433        5.22965       -2.79472       -0.49220        -999.25        5.28000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2180555556 05:14:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.41882        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82555        0.00261        0.00177        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       13.00000     2049.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2066.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.18960       13.39040       69.73800       73.14201        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      509.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       87.90000     1338.14000        2.39000       20.18000       14.98000        1.19000        9.00000       61.50000       42.67000       45.50000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        1.00000        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       10.59000       78.33000       79.73000        4.59000      103.00000      280.00000      438.00000      220.00000        0.59000        -999.25        1.00000        -999.25        -999.25        1.00000        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3513.01100     3374.18900     2246.35000     1651.37800     3979.71300     3000.92300       33.45459       14.73297     2895.22400     3540.07600      200.00000      200.00000     1848.48300     1748.27900     3559.74200     2470.55200      300.00000      300.00000     2167.28400     1602.33500      131.91310       37.67731     1596.40100     1917.94600        1.96988        1.70843        0.45287        0.21309        -999.25        -999.25        0.38289        0.16214        0.00017        0.00012        0.00013        0.00012       -9.94000        9.81200        5.57728        5.71117        4.98991        4.79603        3.99882        4.79108        4.61746        3.49895        6.65860        5.67752        5.27872        5.45003        8.59429        6.78998        8.53181        6.71621       11.91665        8.15579        5.17080        5.32353        0.24920       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.33000        -999.25      169.64490       21.50072      197.22820      411.50600      216.26910       24.42720      145.63480       28.25819      254.55220      392.83500        4.07311     5000.00000      529.68290      381.30250      181.79400       51.97531        5.73934     5000.00000      214.16770      383.83260      489.58910      385.21310      251.75970       32.32315        7.08338       47.69032        7.84797       14.23154        9.29983       16.04568        -999.25        -999.25        -999.25        -999.25        -999.25        0.03798       -0.19826        8.23574       -0.28135       15.43420        7.20327       -0.45009       -0.46930        6.85370        0.35828       -2.10132       -0.59456        6.85382        1.26105        6.52074        1.28111       16.04572        3.04511       -2.79248       -0.51181        -999.25        6.38400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       27.30000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2184027778 05:14:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.51827        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82433        0.00179        0.00280        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2052.00000       14.00000     2040.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       12.00000     2058.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.79980       18.80020       66.26480       67.93520        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      515.00000       80.00000        0.00000        0.00000        0.20000        0.00000        0.20000        0.00000        0.40000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.40000       18.00000       19.80000        0.80000        6.20000       65.20000       45.80000       41.40000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.20000        0.20000        0.20000        0.20000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.00000       75.40000       75.20000        5.40000      103.00000      293.00000      445.00000      223.00000        1.20000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3497.67700     3368.93800     2242.35900     1652.65800     3976.09400     2996.28200       29.46991       14.48364     2890.53100     3536.50900      200.00000      200.00000     1839.64600     1746.04000     3554.45400     2472.69100      300.00000      300.00000     2165.28500     1599.87900      127.54790       37.49542     1593.84900     1915.87900        1.66027        1.58929        0.39226        0.20607        -999.25        -999.25        0.33469        0.15774        0.00017        0.00013        0.00013        0.00012       -9.95000        9.81200        5.58091        5.70878        4.99387        4.79466        4.00136        4.79328        4.61722        3.49974        6.86160        5.70421        5.27883        5.44991        8.99890        6.84321        8.93625        6.76980       12.72589        8.26201        5.17061        5.32413        0.23960       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.16000        -999.25      169.71680       21.60822      197.46080      411.56890      216.30520       24.51294      141.72340       28.30419      254.71550      392.89630        4.02791     5000.00000      529.77620      381.40710      181.93120       51.94618        5.68195     5000.00000      214.19540      383.91270      487.96330      384.95110      251.92170       32.40929        7.99951       37.13092       10.34385       12.35553       12.48933       13.75315        -999.25        -999.25        -999.25        -999.25        -999.25        0.05942       -0.20109        8.30162       -0.23604       15.52960        7.25423       -0.40620       -0.37727        6.30194        0.45545       -2.10974       -0.60025        5.70859        1.41984        5.37907        1.45516       13.76012        3.35311       -2.79378       -0.48697        -999.25        5.56800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2187500000 05:15:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.29598        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83432        0.00167        0.00324        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       13.00000     2052.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2059.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.85680       14.92320       72.87200       68.60800        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      521.00000       80.00000        0.00000        0.00000        0.19000        0.00000        0.00000        0.00000        0.19000        0.16921        0.29964        0.37648        0.40331        0.40331        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       89.40000     1338.14000        1.79000       19.78000       16.98000        2.19000        9.16000       71.17000       53.33000       42.83000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.40000        0.00000        0.00000        0.00000     1427.00000       11.39000       82.93000       77.33000        7.39000      103.00000      291.00000      458.00000      211.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       46.00000        -999.25     3456.74200     3362.94900     2239.57400     1649.43800     3915.81800     2997.90200       38.86993       17.32330     4010.32500     3541.12800      200.00000      200.00000     1821.15300     1745.42300     3516.46100     2456.27300      300.00000      300.00000     2132.76900     1600.43200      130.67290       39.79095     2210.44600     1918.10300        2.87777        4.55346        0.59853        0.28898        -999.25        -999.25        0.48916        0.20867        0.00017        0.00013        0.00013        0.00012       -9.94000        9.81200        5.56641        5.69639        4.94203        4.76448        3.91881        4.74807        4.59409        3.45882        6.29172        5.43510        5.27757        5.45161        7.90220        6.32448        7.84188        6.25086       10.53144        7.22307        5.17399        5.32539        0.23280       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1548.00000        1.36000        -999.25      170.74290       21.84378      197.26480      411.56840      217.97090       24.91500      150.54480       29.29408      256.12400      393.27940        4.31550     5000.00000      530.73840      381.62050      182.43330       52.25012        6.11355     5000.00000      215.86880      384.29720      492.49040      386.42570      253.34820       32.79794        6.57271       68.77459        6.34827       15.47570        7.39379       16.98328        -999.25        -999.25        -999.25        -999.25        -999.25       -0.00453       -0.22326        7.90272       -0.40049       14.83153        6.89111       -0.56835       -0.68170        7.20480        0.24937       -2.10213       -0.61782        7.86212        1.17446        7.53776        1.22132       18.05440        2.86840       -2.77585       -0.48148        -999.25        6.52800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2190972222 05:15:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      109.09990        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82101        0.00186        0.00343        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       14.00000     2052.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2068.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       13.13300       15.66700       72.26500       74.33500        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      527.00000       80.00000        0.00000        0.00000        0.20000        0.00000        0.00000        0.00000        0.20000        0.16921        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.80000       87.40000     1338.14000        3.00000       15.80000       18.00000        2.00000        7.60000       62.60000       48.40000       42.40000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.20000        0.20000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.50000        0.00000        0.00000        0.00000     1427.00000       11.40000       82.00000       82.40000        6.40000      102.00000      283.00000      445.00000      220.00000        1.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3440.72900     3361.36200     2224.64900     1648.94300     3893.78100     2995.97800       33.57391       16.50909     3975.02000     3535.54100      200.00000      200.00000     1813.42700     1743.56400     3513.63300     2459.11100      300.00000      300.00000     2119.61100     1599.67300      125.96770       38.33221     2190.45200     1914.90300        2.20522        3.93455        0.48990        0.28001        -999.25        -999.25        0.41202        0.20270        0.00017        0.00013        0.00013        0.00012       -9.94000        9.82300        5.56301        5.70155        4.96384        4.77503        3.96990        4.77395        4.60133        3.47145        6.54529        5.46096        5.28231        5.45015        8.38077        6.37119        8.31914        6.29868       11.48515        7.31681        5.17611        5.32618        0.24160       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.36000        -999.25      171.82250       22.13117      197.72610      411.73070      218.88710       25.17868      147.07380       29.56769      257.15620      393.74580        4.10839     5000.00000      531.94420      381.92870      182.50790       52.25830        5.83351     5000.00000      216.80710      384.61140      490.65880      385.93730      254.36500       33.24857        7.01070       33.40969        7.52838       11.00804        8.90707       12.45124        -999.25        -999.25        -999.25        -999.25        -999.25        0.12169       -0.20243        8.18519       -0.32046       15.21819        7.12152       -0.47346       -0.52762        6.90265        0.50368       -2.08002       -0.56726        7.04408        1.56418        6.70099        1.57790       16.41493        3.63041       -2.79118       -0.49719        -999.25        6.52800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2194444444 05:16:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      107.76021        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81152        0.00260        0.00123        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       13.00000     2054.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2056.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.45600       14.92400       69.07807       74.60193        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      533.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      221.40000       87.40000     1338.14000        2.79000       18.58000       16.38000        0.79000        8.66000       62.50000       44.83000       43.67000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.55000        0.00000        0.00000        0.00000     1427.00000       12.58000       79.73000       83.32000        6.79000      112.00000      307.00000      461.00000      218.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3441.05600     3363.22100     2224.79500     1648.48700     3887.05700     2997.74600       37.69379       17.27753     3951.09400     3536.74000      200.00000      200.00000     1814.89600     1744.57600     3516.28700     2459.35400      300.00000      300.00000     2116.53000     1600.64800      130.74800       40.59967     2177.88200     1915.93000        2.63342        3.38561        0.56428        0.27049        -999.25        -999.25        0.46548        0.19691        0.00017        0.00014        0.00013        0.00012       -9.94000        9.76800        5.55680        5.70131        4.96278        4.77653        3.97589        4.77479        4.60286        3.47471        6.37514        5.48769        5.27993        5.44998        8.03864        6.42272        7.97698        6.34944       10.80330        7.42082        5.17366        5.32447        0.23380       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.89000        -999.25      172.24790       22.17870      197.58550      411.67980      219.31720       25.18730      150.29340       28.58978      257.75940      393.85170        4.11913     5000.00000      532.36440      381.97530      182.39040       52.24445        5.84877     5000.00000      217.23640      384.61510      492.19570      387.15900      254.97010       33.34208        6.42115     5000.00000        6.31829       44.03705        7.38415       50.31917        -999.25        -999.25        -999.25        -999.25        -999.25        0.11650       -0.20336        8.16994       -0.33843       15.19508        7.10848       -0.49342       -0.56461        7.31718       -0.05791       -2.08080       -0.57216        7.88574        0.46005        7.54398        0.46999       18.09772        1.43082       -2.78932       -0.50963        -999.25        4.27200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2197916667 05:16:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       32.68178       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      108.27700        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81078        0.00289        0.00145        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2052.00000       14.00000     2053.00000        -999.25        0.00000        -999.25     1944.00000     2064.00000       10.00000     2067.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.93300       13.86700       75.99780       70.60220        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      539.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        0.38737        0.41436        0.41436        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      222.30000       88.40000     1338.14000        2.00000       18.60000       15.20000        1.00000        6.40000       70.40000       49.60000       41.60000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       12.60000       86.40000       78.80000        6.00000      104.00000      282.00000      443.00000      219.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3458.94000     3367.26800     2222.49600     1651.98300     3901.37500     2995.81500       28.03131       13.60718     3981.09200     3536.49300      200.00000      200.00000     1820.66700     1745.00900     3550.93100     2473.94100      300.00000      300.00000     2125.06400     1599.76700      125.81630       36.75049     2193.54800     1914.91700        1.53498        1.29234        0.37136        0.18545        -999.25        -999.25        0.31753        0.14402        0.00016        0.00014        0.00013        0.00012       -9.95000        9.81200        5.57425        5.70960        5.02369        4.79943        4.07002        4.82547        4.62121        3.50768        6.95680        5.79780        5.27691        5.44917        9.15803        7.02806        9.09959        6.95718       13.04187        8.62990        5.17710        5.32846        0.23960       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.03000        -999.25      171.59600       22.07321      197.89690      411.78600      219.18450       25.18020      140.98530       29.45385      257.71190      393.71180        3.82149     5000.00000      531.80590      381.89150      181.93640       52.04259        5.40002     5000.00000      217.11700      384.59740      487.66560      383.91780      254.90620       33.20298        7.96523       15.12849       10.93125        6.12220       13.38333        6.87958        -999.25        -999.25        -999.25        -999.25        -999.25        0.20992       -0.18170        8.61941       -0.16551       15.96053        7.51786       -0.33662       -0.25655        6.32064        1.04011       -2.06755       -0.58276        5.49591        2.51023        5.13932        2.52590       13.31963        5.53606       -2.80573       -0.50878        -999.25        4.94400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2201388889 05:17:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.88013       16.56217       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      112.77518        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.76797        0.00186        0.00159        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2051.00000       12.00000     2050.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       12.00000     2064.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.12260       16.85740       77.46160       70.60840        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      545.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      221.40000       87.90000     1338.14000        3.19000       14.58000       18.58000        0.99000        8.33000       61.83000       44.50000       46.00000        0.39000        0.19000        0.00000        0.19000        0.00000        0.20000       36.83715       36.83715       36.83715        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.19000        0.19000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000        9.99000       85.72000       77.13000        4.79000       99.34000      292.00000      451.00000      225.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3453.92000     3364.94800     2225.85900     1653.08400     3898.69900     2994.78500       31.92413       14.60907     3996.16600     3538.00700      200.00000      200.00000     1818.97200     1744.02300     3544.48100     2473.77300      300.00000      300.00000     2123.02200     1598.85400      128.13570       37.48932     2201.69200     1916.10600        1.88861        1.66896        0.44010        0.21094        -999.25        -999.25        0.37236        0.16072        0.00017        0.00014        0.00014        0.00012       -9.96000        9.80100        5.56973        5.70852        5.00523        4.79494        4.04110        4.81048        4.61824        3.50130        6.70806        5.68614        5.27931        5.45114        8.67336        6.80603        8.61405        6.73333       12.07102        8.18570        5.17774        5.32678        0.24920       18.54600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      171.63890       22.07060      197.82870      411.74770      219.04940       25.16929      144.24570       29.39726      257.56660      393.68230        3.90401     5000.00000      531.81840      381.89100      182.08220       52.05120        5.51885     5000.00000      216.98460      384.58160      489.28840      385.16690      254.74980       33.18013        7.35514       23.47503        8.89191        8.92914       10.72021       10.04534        -999.25        -999.25        -999.25        -999.25        -999.25        0.17953       -0.17958        8.48892       -0.18615       15.74651        7.40395       -0.36080       -0.30349        6.67794        0.69947       -2.06477       -0.58772        6.31266        1.85779        5.94916        1.87924       14.95728        4.23036       -2.81677       -0.50219        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2204861111 05:17:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.49752       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.80172        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82881        0.00191        0.00175        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       14.00000     2046.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2073.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.33300       16.66700       64.26500       75.93500        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      551.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.00000       21.00000       18.00000        1.00000        8.40000       68.80000       51.00000       46.20000        0.20000        0.00000        0.20000        0.20000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       11.80000       74.40000       84.40000        6.80000       96.80000      280.00000      439.00000      224.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3430.80900     3359.01000     2219.12500     1652.40500     3882.00800     2988.58900       27.80334       13.82263     3961.61200     3529.00300      200.00000      200.00000     1806.56500     1741.23100     3532.66700     2471.42700      300.00000      300.00000     2113.75000     1596.00000      124.22610       35.86609     2182.76200     1911.45100        1.55552        1.57406        0.37377        0.20478        -999.25        -999.25        0.31961        0.15682        0.00016        0.00014        0.00013        0.00013       -9.94000        9.81200        5.57086        5.70710        5.00456        4.79215        4.03842        4.80961        4.61493        3.49662        6.94059        5.70778        5.28006        5.44867        9.13909        6.85324        9.07918        6.78128       13.00231        8.28187        5.17731        5.32578        0.23460       18.54600       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.63000        -999.25      171.77360       22.21171      198.13570      411.89060      219.25730       25.38437      141.17790       29.70967      257.82790      393.96050        3.87951     5000.00000      531.94340      382.02550      182.30450       52.15771        5.48004     5000.00000      217.17980      384.79900      487.93780      384.36210      255.00660       33.44942        8.07086       16.00619       11.06622        6.43467       13.57899        7.23110        -999.25        -999.25        -999.25        -999.25        -999.25        0.16980       -0.18620        8.52716       -0.17350       15.83122        7.44069       -0.34369       -0.26712        6.26344        0.98903       -2.07752       -0.58542        5.44974        2.41477        5.09036        2.43062       13.24005        5.34761       -2.82127       -0.51109        -999.25        7.82400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2208333333 05:18:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.49752       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.96699        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82485        0.00203        0.00284        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2048.00000       14.00000     2045.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       14.00000     2066.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.25640       14.52360       79.66687       62.22313        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      557.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      223.80000       88.40000     1338.14000        1.59000       19.58000       15.58000        0.79000       10.50000       60.17000       44.67000       44.17000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       13.98000       90.52000       69.94000        4.59000      100.00000      291.00000      452.00000      209.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3449.07700     3364.02900     2215.28200     1652.49400     3883.97700     2991.42100       22.53967       11.81091     3961.68100     3529.21300      200.00000      200.00000     1814.70400     1743.00500     3543.78900     2475.14000      300.00000      300.00000     2114.61200     1596.98500      121.58390       34.07043     2182.25100     1911.35700        1.15976        0.97197        0.28704        0.15912        -999.25        -999.25        0.25196        0.12676        0.00015        0.00014        0.00013        0.00012       -9.94000        9.81200        5.57794        5.71122        5.03083        4.80082        4.08078        4.83277        4.62297        3.50920        7.36067        5.94236        5.28092        5.45153        9.95798        7.31420        9.89874        7.24127       14.63857        9.20188        5.17950        5.32672        0.23980       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.29000        -999.25      171.49440       22.13565      198.26670      411.93000      219.30790       25.34386      133.46960       28.65470      257.75260      393.93570        3.75693     5000.00000      531.72430      381.98170      182.12230       52.08498        5.30084     5000.00000      217.24610      384.75200      485.35350      384.04040      254.91930       33.43868       10.92583       19.45861       26.92013        7.90481       36.81096        8.84582        -999.25        -999.25        -999.25        -999.25        -999.25        0.22987       -0.15400        8.72491       -0.09167       16.14445        7.61625       -0.28122       -0.15501        5.06862        0.83047       -2.06180       -0.59191        2.88868        2.04999        2.51540        2.07611        8.11610        4.61426       -2.83334       -0.49702        -999.25        6.19200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2211805556 05:18:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.49752       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.75202        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84601        0.00193        0.00145        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       13.00000     2041.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2063.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.93280       14.86720       67.26460       74.93539        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      563.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.80000       17.20000       16.60000        1.20000        8.20000       67.60000       49.00000       43.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       13.40000       78.60000       84.20000        7.20000      105.00000      309.00000      458.00000      213.00000        1.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3423.30100     3363.35400     2219.77600     1652.02400     3860.68500     2992.55900       30.70587       14.51996     3931.96800     3533.48800      200.00000      200.00000     1803.33300     1743.66600     3541.23000     2470.55000      300.00000      300.00000     2101.71100     1597.51000      127.61170       37.08679     2166.19400     1913.22800        1.76414        1.72031        0.41687        0.21357        -999.25        -999.25        0.35404        0.16230        0.00015        0.00015        0.00012        0.00012       -9.97000        9.81200        5.56738        5.70619        5.01075        4.79010        4.05690        4.81842        4.61500        3.49555        6.78886        5.67497        5.28183        5.45199        8.82530        6.78642        8.76498        6.71427       12.37338        8.14508        5.17825        5.32874        0.23820       18.54600       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.39000        -999.25      172.30450       22.30152      197.78520      411.81190      220.23340       25.59787      144.05010       27.74064      258.89420      394.19110        3.88012     5000.00000      532.53490      382.12230      182.02690       52.13437        5.49210     5000.00000      218.19540      385.00570      488.89740      385.44750      256.08640       33.69281        7.25234       82.03357        8.66863       21.31104       10.45868       23.81668        -999.25        -999.25        -999.25        -999.25        -999.25        0.23033       -0.17926        8.52621       -0.19429       15.75827        7.42923       -0.37131       -0.32245        6.74311        0.20822       -2.03799       -0.59213        6.41928        0.88906        6.04686        0.91467       15.15265        2.29316       -2.80783       -0.49829        -999.25        6.67200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2215277778 05:19:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.32749       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      115.22883        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83029        0.00209        0.00209        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2048.00000       13.00000     2044.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       14.00000     2060.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.38960       17.39040       71.27120       71.40881        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      569.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.79000       19.78000       18.38000        0.59000        6.66000       66.50000       50.17000       43.17000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       11.59000       80.73000       78.73000        5.19000      111.00000      291.00000      456.00000      215.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3415.16300     3364.76300     2202.57800     1649.70200     3839.60800     2994.51300       30.42175       13.98163     3887.87300     3531.37900      200.00000      200.00000     1800.30800     1743.97600     3532.64800     2473.34000      300.00000      300.00000     2090.83400     1598.89800      127.61900       37.41669     2140.90200     1912.06900        1.71941        1.33828        0.41087        0.18951        -999.25        -999.25        0.34890        0.14668        0.00015        0.00014        0.00012        0.00011       -9.95000        9.79000        5.56129        5.70828        5.03004        4.80315        4.10338        4.83952        4.62606        3.51757        6.81955        5.78080        5.27935        5.45011        8.86631        6.98850        8.80926        6.91734       12.45462        8.55015        5.18230        5.32882        0.23860       18.51300       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.20000        -999.25      173.82500       22.55164      198.23370      411.97880      221.52870       25.78629      142.65000       30.61975      260.18480      394.54620        3.74207     5000.00000      534.12810      382.39180      182.13560       52.13009        5.29866     5000.00000      219.49510      385.21670      488.76880      385.38550      257.37030       34.03741        7.62760       15.85350       10.15083        6.61766       12.39838        7.46162        -999.25        -999.25        -999.25        -999.25        -999.25        0.30309       -0.15986        8.74964       -0.09979       16.09818        7.61845       -0.27525       -0.15130        6.51240        0.99753       -2.03366       -0.56962        5.78299        2.36260        5.40506        2.37169       13.88124        5.23422       -2.81451       -0.50879        -999.25        5.76000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2218750000 05:19:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.32749       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.37891        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82848        0.00207        0.00151        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2047.00000       15.00000     2047.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       14.00000     2076.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.59940       14.60060       71.33200       75.26801        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      575.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.80000       87.90000     1338.14000        3.60000       17.60000       17.00000        1.80000        8.40000       62.20000       44.40000       44.40000        0.20000        0.00000        0.20000        0.20000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.20000        0.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       11.20000       81.20000       83.80000        7.20000      107.00000      298.00000      465.00000      216.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3431.59200     3362.98700     2210.53100     1651.62000     3863.22500     2993.53900       30.32928       13.94440     3919.92900     3531.74500      200.00000      200.00000     1808.41400     1742.89500     3542.82500     2472.24100      300.00000      300.00000     2103.99900     1598.11500      128.43200       36.59058     2159.63500     1913.59200        1.69352        1.47012        0.40522        0.19879        -999.25        -999.25        0.34458        0.15321        0.00016        0.00015        0.00012        0.00012       -9.94000        9.81200        5.56396        5.70908        5.02919        4.79642        4.09706        4.83671        4.61964        3.50362        6.83774        5.73534        5.27809        5.45154        8.90571        6.90198        8.84712        6.82709       12.53622        8.37939        5.17796        5.32280        0.23960       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.39000        -999.25      173.02540       22.40977      198.20960      411.97270      220.67510       25.61393      143.10150       28.73235      259.36090      394.27830        3.73974     5000.00000      533.27720      382.24170      182.04660       52.17620        5.28909     5000.00000      218.60170      385.03060      489.03660      385.40410      256.53880       33.81785        7.55643       33.58852        9.94777       12.37203       12.07166       13.71591        -999.25        -999.25        -999.25        -999.25        -999.25        0.25182       -0.16805        8.75352       -0.12858       16.16299        7.62812       -0.30682       -0.20348        6.55467        0.50112       -2.07336       -0.58335        5.86299        1.41825        5.50110        1.45837       14.06491        3.32823       -2.82214       -0.46047        -999.25        6.67200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2222222222 05:20:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.32749       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.19132        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84505        0.00160        0.00218        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2047.00000       14.00000     2042.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2069.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.32300       14.85700       75.66747       70.81253        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      581.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       90.40000     1338.14000        2.19000       17.18000       16.38000        1.19000        8.00000       66.83000       46.83000       44.33000        0.59000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       12.98000       86.12000       78.73000        5.39000      100.00000      289.00000      449.00000      218.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3429.05000     3364.31800     2214.02100     1653.13300     3843.77200     2993.87700       32.48016       15.14069     3909.14000     3532.80300      200.00000      200.00000     1807.50600     1743.81200     3538.17100     2474.19000      300.00000      300.00000     2092.50900     1598.43300      129.69850       38.17322     2153.60400     1913.43900        1.89215        1.85182        0.44354        0.22149        -999.25        -999.25        0.37521        0.16725        0.00015        0.00015        0.00013        0.00012       -9.94000        9.81200        5.56188        5.70795        5.01415        4.79520        4.07194        4.82456        4.61862        3.50251        6.70585        5.64791        5.28181        5.45079        8.65179        6.72905        8.59151        6.65618       12.02633        8.03226        5.17831        5.32610        0.24100       18.51300       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.46000        -999.25      173.06430       22.39578      198.05760      411.87880      220.96240       25.64256      145.87080       28.46391      259.59790      394.33290        3.82115     5000.00000      533.29220      382.22960      182.11330       52.12581        5.39885     5000.00000      218.91400      385.04780      489.84740      385.64070      256.77780       33.83749        6.86155       47.69005        7.85632       15.79114        9.40252       17.64734        -999.25        -999.25        -999.25        -999.25        -999.25        0.22789       -0.16616        8.61996       -0.14608       15.94424        7.51901       -0.33096       -0.24700        7.00212        0.35829       -2.04837       -0.59474        6.84902        1.15415        6.47564        1.18252       16.02347        2.82317       -2.82013       -0.49537        -999.25        7.00800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2225694444 05:20:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.32749       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.84532        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85479        0.00207        0.00383        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       13.00000     2043.00000        -999.25        0.00000        -999.25     1944.00000     2064.00000        9.00000     2073.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.39980       13.40020       66.66441       78.73560        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      587.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.60000       17.80000       14.60000        1.00000       10.60000       62.20000       45.60000       48.60000        0.60000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       12.40000       76.80000       86.60000        5.60000      108.00000      277.00000      442.00000      200.00000        1.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3422.51600     3365.39000     2212.59300     1652.97100     3828.79900     2994.92400       31.62567       13.71521     3936.46900     3534.09300      200.00000      200.00000     1803.14100     1744.41000     3543.73100     2478.94100      300.00000      300.00000     2084.94400     1598.82000      129.86050       36.88416     2168.08100     1913.97400        1.79224        1.30547        0.42468        0.18732        -999.25        -999.25        0.35996        0.14538        0.00016        0.00015        0.00012        0.00012       -9.94000        9.80100        5.56632        5.70774        5.02771        4.80356        4.09118        4.83468        4.62755        3.52002        6.77004        5.79287        5.27937        5.45173        8.77296        7.00971        8.71506        6.93675       12.26875        8.59275        5.18063        5.32684        0.24020       18.44700        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.06000        -999.25      173.14930       22.42092      198.08060      411.90940      221.29830       25.64874      144.80370       29.26278      259.58300      394.35930        3.78082     5000.00000      533.39810      382.26120      182.03730       52.07378        5.34368     5000.00000      219.24850      385.06930      489.20620      385.29050      256.75550       33.86813        6.98519       24.44564        8.24654        9.72732        9.92648       10.91556        -999.25        -999.25        -999.25        -999.25        -999.25        0.24878       -0.15968        8.68551       -0.10373       16.04327        7.57338       -0.28419       -0.16436        6.91965        0.67388       -2.04985       -0.57943        6.63382        1.73358        6.25749        1.75637       15.59750        3.97231       -2.82752       -0.49122        -999.25        5.08800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2229166667 05:21:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       14.20537       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.34829        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84999        0.00226        0.00264        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       13.00000     2053.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2058.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.85620       13.52380       75.86140       62.40860        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      593.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.19000        0.19000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.35904        0.74702        0.74702     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.79000       19.18000       15.38000        1.39000        8.50000       65.50000       47.50000       45.50000        0.99000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.19000        0.19000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       10.99000       84.92000       69.53000        5.19000      101.00000      272.00000      432.00000      215.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3452.82200     3372.05100     2213.36000     1650.57200     3867.98800     3001.16900       30.13092       14.82941     3921.65400     3537.49500      200.00000      200.00000     1819.01400     1747.94500     3545.42900     2474.91700      300.00000      300.00000     2105.43000     1601.74300      127.44840       37.87903     2160.00600     1915.93000        1.69526        1.68870        0.40566        0.21356        -999.25        -999.25        0.34507        0.16248        0.00016        0.00014        0.00012        0.00013       -9.95000        9.81200        5.56677        5.70733        5.02774        4.80195        4.09233        4.83625        4.62726        3.51852        6.83651        5.68180        5.28289        5.45395        8.90260        6.78652        8.84277        6.71218       12.52644        8.14550        5.18029        5.32632        0.23920       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.96000        -999.25      172.87120       22.25712      198.20250      411.85170      220.82810       25.53103      142.48380       30.45799      259.52090      394.27770        3.75321     5000.00000      533.12820      382.07410      182.08260       52.09515        5.30437     5000.00000      218.77400      384.94050      488.80900      384.97460      256.69770       33.77912        7.72434       15.35639       10.43969        6.20381       12.77118        6.94078        -999.25        -999.25        -999.25        -999.25        -999.25        0.25702       -0.18299        8.73109       -0.15798       16.11993        7.61270       -0.33233       -0.24344        6.45602        1.02632       -2.05412       -0.59054        5.67251        2.48448        5.30048        2.50913       13.67485        5.48335       -2.82318       -0.49859        -999.25        4.60800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2232638889 05:21:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25       -0.05600       17.18682       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.90262        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82001        0.00265        0.00227        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       15.00000     2047.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2058.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.99980       16.80020       67.39900       71.20100        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      599.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      221.80000       87.90000     1338.14000        2.20000       20.00000       18.60000        1.60000        9.00000       70.60000       48.80000       44.80000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       10.40000       76.80000       79.60000        7.40000      106.00000      282.00000      433.00000      220.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3445.44600     3370.29800     2219.24000     1652.67800     3864.16200     2999.73300       34.55261       17.06329     3935.02600     3538.60400      200.00000      200.00000     1816.04900     1747.10500     3539.01600     2472.98900      300.00000      300.00000     2104.58000     1601.38900      130.87160       40.12787     2168.42300     1916.76900        2.11827        3.21782        0.48268        0.26976        -999.25        -999.25        0.40601        0.19653        0.00016        0.00014        0.00013        0.00013       -9.94000        9.81200        5.56236        5.70699        5.00632        4.79333        4.05357        4.81449        4.61769        3.50068        6.58449        5.49676        5.27780        5.45172        8.42070        6.42677        8.36131        6.35301       11.56729        7.42767        5.17607        5.32525        0.23260       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.93000        -999.25      172.96970       22.30057      197.96160      411.80620      220.73270       25.57410      146.82420       29.98886      259.56740      394.25710        3.85173     5000.00000      533.20870      382.12200      182.14020       52.13766        5.46369     5000.00000      218.66790      384.98230      490.68440      386.49050      256.75680       33.74929        6.87603       33.15073        7.75893       11.67116        9.24514       13.14232        -999.25        -999.25        -999.25        -999.25        -999.25        0.23907       -0.17853        8.57103       -0.19829       15.82143        7.45630       -0.37553       -0.33142        6.99234        0.50742       -2.06474       -0.59183        6.90552        1.48933        6.54509        1.51000       16.13989        3.49832       -2.81061       -0.50785        -999.25        4.46400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2236111111 05:22:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.14679       23.90915       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      118.95341        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82202        0.00290        0.00170        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2047.00000       13.00000     2047.00000        -999.25        0.00000        -999.25     1944.00000     2070.00000       14.00000     2054.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.32320       15.85680       64.94307       76.13693        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      605.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.80000       88.40000     1338.14000        2.39000       19.58000       17.98000        1.99000        9.83000       66.17000       49.17000       43.83000        0.79000        0.19000        0.00000        0.19000        0.00000        0.20000       36.83715       36.83715       36.83715       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.19000        0.19000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       14.78000       76.13000       83.72000        3.99000       99.34000      281.00000      438.00000      210.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3384.68800     3360.86800     2200.78800     1648.49300     3774.09900     2996.63800       45.49835       20.18402     3800.86900     3532.97300      200.00000      200.00000     1787.40500     1744.65100     3496.57300     2462.94900      300.00000      300.00000     2056.12900     1600.00100      138.32790       44.58588     2093.30800     1913.31600        3.73315        9.39962        0.73019        0.32962        -999.25        -999.25        0.58343        0.23147        0.00016        0.00014        0.00012        0.00014       -9.94000        9.82300        5.54592        5.69485        4.97848        4.77794        4.02129        4.79361        4.60765        3.48737        6.09790        5.35675        5.27526        5.45028        7.46680        6.15493        7.41114        6.08281        9.65829        6.88379        5.18100        5.32707        0.24640       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.20000        -999.25      175.37720       22.88904      197.89180      411.84700      223.42310       26.31057      154.67450       28.81123      262.44630      395.31740        3.98885     5000.00000      535.65210      382.70980      182.52710       52.30926        5.69020     5000.00000      221.39820      385.71810      495.33800      388.15700      259.66540       34.80067        5.94932     5000.00000        5.59108      297.83180        6.50981      298.36890        -999.25        -999.25        -999.25        -999.25        -999.25        0.27492       -0.17920        8.35959       -0.26408       15.36470        7.24685       -0.44130       -0.46230        7.69723       -0.23664       -2.02493       -0.59246        8.52122        0.06490        8.15573        0.08146       19.33655        0.65422       -2.78091       -0.51672        -999.25        5.76000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2239583333 05:22:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.56438       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.18200        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85396        0.00234        0.00218        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       12.00000     2047.00000        -999.25        0.00000        -999.25     1944.00000     2066.00000       14.00000     2054.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.19960       13.40040       69.99820       59.00180        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      611.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.40000       18.20000       15.00000        1.20000        8.40000       63.00000       41.40000       50.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       10.60000       78.80000       66.00000        5.20000      112.00000      290.00000      433.00000      211.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3396.59000     3361.79400     2208.25200     1652.58000     3809.53800     2994.81600       41.70532       19.07990     3848.61300     3533.20200      200.00000      200.00000     1794.24600     1744.47800     3494.86800     2466.37500      300.00000      300.00000     2074.69800     1599.15400      134.37320       42.60010     2120.22500     1913.68400        3.15433        7.24470        0.64885        0.31733        -999.25        -999.25        0.52563        0.22495        0.00017        0.00014        0.00012        0.00013       -9.94000        9.81200        5.54323        5.69812        4.95887        4.77584        3.98764        4.77688        4.60358        3.47793        6.21707        5.37728        5.27835        5.44960        7.71900        6.20093        7.66052        6.12860       10.16242        6.97669        5.17845        5.32597        0.23920       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.16000        -999.25      174.54480       22.67084      198.11840      411.84280      222.27320       26.02001      152.77850       29.58525      261.23720      394.91730        4.04151     5000.00000      534.71220      382.47450      182.76400       52.29038        5.73517     5000.00000      220.21680      385.41860      494.27820      386.82660      258.44440       34.40428        6.22440       59.39405        6.06583       16.42023        7.09547       18.45715        -999.25        -999.25        -999.25        -999.25        -999.25        0.16739       -0.19638        8.28167       -0.26738       15.35440        7.20695       -0.44048       -0.44761        7.46983        0.28867       -2.05643       -0.60140        8.09222        1.11581        7.73650        1.13868       18.50024        2.75865       -2.79285       -0.51302        -999.25        5.56800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2243055556 05:23:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.01623       23.62499       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.54035        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82501        0.00292        0.00332        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       15.00000     2049.00000        -999.25        0.00000        -999.25     1944.00000     2066.00000       10.00000     2059.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.79000       16.19000       68.01067       69.47933        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      617.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.79000       19.58000       17.98000        1.79000        7.83000       63.67000       46.33000       42.17000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000       13.18000       78.53000       77.33000        5.19000      111.00000      276.00000      430.00000      234.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3413.33100     3364.58900     2211.37400     1652.32200     3825.54200     2998.59500       40.11749       17.61505     3886.90000     3542.16400      200.00000      200.00000     1802.38100     1745.99200     3504.30300     2465.62200      300.00000      300.00000     2083.64900     1601.20600      131.82040       41.43860     2140.69500     1918.00600        2.97105        3.33664        0.62467        0.26948        -999.25        -999.25        0.50716        0.19607        0.00018        0.00014        0.00012        0.00012       -9.95000        9.80100        5.54664        5.69779        4.96725        4.77499        3.99879        4.78306        4.60280        3.47664        6.26200        5.49029        5.27737        5.44941        7.80466        6.42835        7.74793        6.35732       10.33298        7.43042        5.18097        5.32837        0.23240       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.56000        -999.25      174.21060       22.57826      198.27170      411.90580      222.06380       25.89766      151.57780       30.86509      261.04740      394.59800        3.97077     5000.00000      534.40190      382.38550      182.74170       52.33956        5.62973     5000.00000      220.01000      385.30320      493.45710      386.96250      258.26410       34.11546        6.28734       28.68111        6.29342        9.98648        7.36981       11.10660        -999.25        -999.25        -999.25        -999.25        -999.25        0.19133       -0.19273        8.38676       -0.25947       15.52997        7.30137       -0.43091       -0.43377        7.42013        0.58159       -2.05383       -0.59444        7.90548        1.69712        7.55325        1.73174       18.12070        3.90257       -2.78330       -0.48257        -999.25        7.48800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2246527778 05:23:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.80397       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      113.20122        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83197        0.00119        0.00331        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       13.00000     2059.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       14.00000     2059.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.19940       13.20060       71.93179       71.66821        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      623.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.80000       16.40000       14.80000        1.00000        7.60000       73.00000       53.20000       47.60000        0.60000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.00000        9.80000       80.20000       78.40000        5.20000       90.40000      289.00000      444.00000      225.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3392.55800     3370.60600     2202.67900     1649.42500     3763.56400     3001.48100       39.15497       18.37708     3855.63600     3539.05100      200.00000      200.00000     1791.00700     1747.72000     3522.35600     2470.67100      300.00000      300.00000     2049.80600     1602.18200      134.41350       42.22382     2124.57700     1916.62900        2.62843        4.21215        0.57528        0.28861        -999.25        -999.25        0.47275        0.20838        0.00018        0.00015        0.00012        0.00012       -9.94000        9.82300        5.54860        5.70472        5.00805        4.79593        4.07764        4.82307        4.62180        3.50965        6.37693        5.44887        5.27773        5.45248        7.99370        6.32637        7.93454        6.25310       10.71312        7.22562        5.17647        5.32698        0.24280       18.52400        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.26000        -999.25      174.91760       22.66508      198.22480      411.92970      223.48750       26.06848      151.86940       31.04319      261.84600      395.00890        3.80131     5000.00000      535.20890      382.48100      182.29050       52.20566        5.37715     5000.00000      221.48080      385.47920      493.10810      386.71970      259.05210       34.49583        5.94035       22.44663        5.90082        8.67723        6.92582        9.78812        -999.25        -999.25        -999.25        -999.25        -999.25        0.29124       -0.18403        8.65204       -0.17531       15.93425        7.54028       -0.34852       -0.27591        7.70494        0.72887       -2.00665       -0.58929        8.23492        1.90126        7.85381        1.91804       18.76129        4.32352       -2.79388       -0.51308        -999.25        6.04800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2250000000 05:24:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.80397       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.04213        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82463        0.00280        0.00186        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2052.00000       15.00000     2043.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       12.00000     2070.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.32340       16.25660       72.33427       72.34573        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      629.00000       80.00000        0.00000        0.00000        0.19000        0.00000        0.00000        0.00000        0.19000        -999.25        -999.25        0.37648        0.40331        0.40331        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      222.30000       87.90000     1338.14000        1.59000       18.98000       17.98000        1.79000        6.50000       64.67000       47.83000       42.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       13.18000       83.12000       80.73000        5.99000      107.00000      286.00000      448.00000      223.00000        0.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3382.46600     3360.72200     2191.65700     1648.55000     3762.00400     2990.58600       34.08203       16.22223     3749.38700     3521.10600      200.00000      200.00000     1785.76300     1743.25800     3497.89000     2465.50400      300.00000      300.00000     2048.54400     1596.71700      127.32760       38.68469     2064.51000     1905.97000        2.17823        2.82782        0.49313        0.25894        -999.25        -999.25        0.41387        0.18970        0.00018        0.00014        0.00012        0.00013       -9.94000        9.81200        5.54819        5.70142        4.99883        4.78714        4.06067        4.81492        4.61371        3.49607        6.55727        5.52526        5.27948        5.45057        8.36315        6.48844        8.30631        6.41827       11.44794        7.54857        5.18287        5.33126        0.23380       18.53500       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.73000        -999.25      175.18090       22.92557      198.85510      412.15130      223.70870       26.54997      148.74630       30.13916      262.81630      395.68350        3.76570     5000.00000      535.47710      382.75820      182.83470       52.38457        5.34399     5000.00000      221.65590      385.95760      491.13770      386.39900      259.97660       35.15474        6.29362       28.12658        6.64795       10.67557        7.85555       12.09745        -999.25        -999.25        -999.25        -999.25        -999.25        0.29622       -0.16739        8.71040       -0.14075       16.02042        7.57306       -0.32381       -0.23329        7.41522        0.59217       -2.05283       -0.59233        7.63558        1.60490        7.25465        1.61536       17.60860        3.74017       -2.83969       -0.52877        -999.25        3.50400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2253472222 05:24:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.80397       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      114.27567        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84719        0.00205        0.00196        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2051.00000       15.00000     2057.00000        -999.25        0.00000        -999.25     1944.00000     2070.00000       13.00000     2060.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.93360       20.46640       74.59700       68.20300        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      635.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.60000       14.80000       22.60000        2.40000        7.00000       67.00000       48.00000       45.20000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       13.80000       85.40000       76.00000        4.80000      100.00000      284.00000      444.00000      229.00000        0.80000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3337.39000     3358.50100     2181.58100     1644.36400     3692.78100     2990.58000       40.73151       18.45825     3648.58900     3518.87400      200.00000      200.00000     1763.70600     1742.69300     3479.38600     2457.22200      300.00000      300.00000     2011.06500     1596.51800      133.58580       42.01263     2008.74200     1904.96200        2.93785        4.88176        0.62663        0.29663        -999.25        -999.25        0.50844        0.21330        0.00018        0.00015        0.00012        0.00013       -9.94000        9.81200        5.53961        5.69849        4.98960        4.78111        4.05463        4.80952        4.60968        3.48893        6.27245        5.42281        5.27855        5.45163        7.79753        6.28609        7.74173        6.21492       10.31660        7.14379        5.18401        5.33035        0.23920       18.52400        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      176.72930       23.31877      198.62920      412.13960      225.63660       27.10314      152.99320       32.34562      264.99030      396.44200        3.85198     5000.00000      537.04880      383.14970      182.89960       52.50978        5.47520     5000.00000      223.63110      386.51810      494.02480      387.50340      262.17240       35.90434        5.93899       19.28739        5.79192        7.42859        6.80414        8.41968        -999.25        -999.25        -999.25        -999.25        -999.25        0.31949       -0.16905        8.57063       -0.21226       15.72961        7.44531       -0.39086       -0.37019        7.70611        0.83707       -2.00552       -0.58508        8.33273        2.15549        7.93904        2.15787       18.96835        4.84217       -2.81790       -0.53768        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2256944444 05:25:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.43175       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.89921        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84201        0.00203        0.00209        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2047.00000       15.00000     2051.00000        -999.25        0.00000        -999.25     1944.00000     2067.00000       15.00000     2059.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.32300       16.45700       71.47240       71.80760        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      641.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.59000       18.58000       18.38000        1.59000        7.00000       70.34000       52.17000       45.33000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       10.39000       80.93000       80.33000        7.59000      107.00000      285.00000      443.00000      207.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3341.44300     3357.25000     2187.38800     1642.78200     3684.30500     2988.17400       66.78619       28.20160     3664.18800     3521.63700      200.00000      200.00000     1766.52700     1740.86700     3493.25200     2462.06800      300.00000      300.00000     2010.08200     1596.84700      163.66610       55.75714     2021.08900     1908.29000        8.88256      500.00000        1.24726        0.50115        -999.25        -999.25        0.91463        0.32009        0.00018        0.00014        0.00012        0.00013       -9.96000        9.81200        5.53628        5.70436        4.99676        4.80044        4.06608        4.81049        4.62168        3.51440        5.63467        5.11898        5.26284        5.44285        6.52398        5.67018        6.46796        5.59924        7.78544        5.92054        5.16785        5.32201        0.24000       18.54600        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.96000        -999.25      177.13980       23.30788      197.40670      411.76350      225.17410       26.91764      161.09760       29.21351      264.78330      396.23340        3.85769     5000.00000      537.54160      383.14290      181.81310       52.15725        5.52251     5000.00000      223.17930      386.30130      501.08580      388.53000      262.09380       35.69608        5.67911     5000.00000        5.23032      284.41920        6.01922      281.51880        -999.25        -999.25        -999.25        -999.25        -999.25        0.40172       -0.16503        8.56158       -0.21323       15.59354        7.40051       -0.40947       -0.39379        7.93831       -0.22412       -1.99480       -0.61634        8.88920        0.06844        8.55431        0.08661       20.01176        0.68354       -2.68958       -0.53735        -999.25        4.60800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2260416667 05:25:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.02460       23.39232       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.02865        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84910        0.00191        0.00199        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2049.00000       13.00000     2053.00000        -999.25        0.00000        -999.25     1944.00000     2065.00000       11.00000     2059.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.19960       16.80040       64.33140       71.66860        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      647.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.60000       16.40000       18.60000        1.40000        7.80000       66.20000       48.60000       40.80000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.80000       74.20000       79.60000        6.00000      105.00000      283.00000      433.00000      220.00000        0.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3364.49000     3360.30500     2179.07000     1644.46000     3721.23200     2992.03300       53.65082       23.37250     3701.56100     3526.27600      200.00000      200.00000     1778.93900     1742.89800     3494.22000     2462.00600      300.00000      300.00000     2028.45800     1598.42700      148.99750       48.32489     2040.40200     1910.62400        4.83786      500.00000        0.89736        0.42148        -999.25        -999.25        0.69421        0.27861        0.00019        0.00014        0.00012        0.00013       -9.95000        9.81200        5.53516        5.70213        5.01178        4.79357        4.10158        4.82985        4.61724        3.50532        5.91899        5.21521        5.27041        5.44547        7.07056        5.86543        7.01352        5.79358        8.87205        6.30932        5.17338        5.32282        0.23420       18.52400        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.03000        -999.25      177.12450       23.25041      198.74680      412.09810      225.41100       26.85756      158.99140       30.17161      265.01960      396.04280        3.65351     5000.00000      537.47420      383.07410      182.40490       52.36537        5.16349     5000.00000      223.40080      386.26100      497.86590      387.80060      262.24970       35.50417        5.21891       71.64429        4.76124       20.58705        5.48265       23.52472        -999.25        -999.25        -999.25        -999.25        -999.25        0.34967       -0.17635        8.90056       -0.16339       16.34186        7.75779       -0.34410       -0.26726        8.39609        0.23926       -2.01024       -0.59660        9.42211        0.91682        9.05479        0.92451       21.12544        2.37105       -2.76987       -0.53858        -999.25        4.94400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2263888889 05:26:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.38113       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      116.43972        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84455        0.00217        0.00416        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       16.00000     2050.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2057.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.25660       14.12340       75.79539       68.87460        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      653.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.80000       88.40000     1338.14000        1.99000       16.18000       15.98000        1.79000        7.83000       71.50000       51.00000       41.00000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000        9.99000       84.52000       76.33000        6.19000      102.00000      301.00000      461.00000      216.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3370.41600     3348.60800     2174.05500     1639.82900     3738.16500     2990.55800       60.00336       25.68298     3728.33700     3527.89000      200.00000      200.00000     1787.24700     1740.33400     3390.93700     2436.53700      300.00000      300.00000     2037.88400     1598.28300      145.47970       50.27679     2055.50900     1910.86200       10.98797      500.00000        1.28357        0.52489        -999.25        -999.25        0.93674        0.33040        0.00018        0.00014        0.00012        0.00012       -9.94000        9.81200        5.50998        5.68463        4.87280        4.74841        3.86098        4.70305        4.57907        3.43949        5.56355        5.07829        5.26958        5.44197        6.48023        5.62784        6.42287        5.55919        7.69254        5.83444        5.17192        5.32572        0.23920       18.52400       -1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.36000        -999.25      177.18570       23.21913      199.61220      412.00580      224.89450       26.72586      163.48250       30.92728      264.21280      395.98380        4.18920     5000.00000      537.20510      382.98330      184.46740       52.72837        5.90741     5000.00000      222.81300      386.10530      502.25960      389.91140      261.51430       35.45766        5.52387     5000.00000        4.72084       88.22079        5.36531       93.65617        -999.25        -999.25        -999.25        -999.25        -999.25        0.01936       -0.23579        8.07212       -0.42965       15.14484        7.05891       -0.59262       -0.72260        8.08563       -0.22533       -2.08142       -0.62054        9.47092        0.23637        9.17487        0.26226       21.22299        1.01590       -2.69852       -0.52613        -999.25        6.52800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2267361111 05:26:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.38113       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.73624        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84611        0.00154        0.00307        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       14.00000     2054.00000        -999.25        0.00000        -999.25     1944.00000     2067.00000       13.00000     2064.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.06600       18.53400       70.73120       67.46880        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      659.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.38737        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.20000       18.60000       19.40000        0.20000        7.40000       65.00000       49.60000       44.80000        1.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.20000       80.80000       75.40000        5.80000      102.00000      280.00000      440.00000      213.00000        1.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3386.43500     3358.95800     2167.86600     1647.18100     3773.95700     2992.04000       41.58905       22.86652     3770.64100     3531.44600      200.00000      200.00000     1792.16400     1743.78100     3446.16600     2465.91200      300.00000      300.00000     2055.35400     1598.58900      132.45760       47.55615     2077.71400     1913.45600        3.22398      500.00000        0.66374        0.41237        -999.25        -999.25        0.53695        0.27399        0.00018        0.00014        0.00012        0.00012       -9.96000        9.81200        5.52730        5.69425        4.96618        4.78758        4.02608        4.79208        4.61476        3.50473        6.20149        5.22734        5.27821        5.44461        7.66827        5.89059        7.60893        5.81910       10.06196        6.36014        5.17659        5.32268        0.23800       18.55700        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.13000        -999.25      176.57760       23.08920      200.24470      412.01650      224.86510       26.64015      156.21490       29.66123      264.20740      395.73020        3.69829     5000.00000      536.77650      382.90180      183.85380       52.29541        5.18692     5000.00000      222.80910      386.04750      495.13770      388.68790      261.40340       35.20419        5.24024     5000.00000        4.79821       93.98429        5.52091      105.37800        -999.25        -999.25        -999.25        -999.25        -999.25        0.19891       -0.18740        8.82348       -0.17847       16.39093        7.73320       -0.35169       -0.27887        8.37340       -0.11111       -2.05602       -0.59266        9.37801        0.22207        9.01652        0.23408       21.07719        0.97330       -2.80399       -0.52600        -999.25        5.42400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2270833333 05:27:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.82608       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      117.97696        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83686        0.00198        0.00240        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       13.00000     2046.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       12.00000     2064.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.25620       14.12380       72.54408       61.35593        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      665.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.39000       19.18000       15.58000        0.99000        6.33000       68.17000       50.00000       44.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.78000       82.73000       68.94000        4.99000      103.00000      263.00000      427.00000      225.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3658.94400     3589.74700     2313.62500     2435.21900     3407.60000     2886.00700     1802.63000     1045.23100     3165.69200     3224.52500      200.00000      200.00000     2120.93600     2018.52100     3866.96500     3565.99100      300.00000      300.00000     2053.98000     1646.59400     2454.31000     1326.30400     1920.40200     1825.68500      500.00000      500.00000      500.00000      500.00000        -999.25        -999.25      700.00000      500.00000        0.00017        0.00014        0.00013        0.00012       -9.94000        9.81200        4.73656        5.00061        4.81115        4.31401        4.46155        4.59185        4.20281        3.31285        4.02440        3.82129        4.39705        4.87422        3.54846        3.50676        3.51217        3.52953        2.68046        2.06861        4.34153        4.94080        0.23560       18.53500        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.43000        -999.25      208.56030       32.41947      197.50650      388.88400      251.28230       30.82728      218.42310       49.99815      276.69240      399.59120        1.75495        9.90613      214.63660      392.50350      176.68570       27.52073        2.61055       36.22079      252.34000      389.57740      202.10690      411.16740      276.11970       37.86092        4.06526     5000.00000        5.79081     5000.00000        7.40423     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25        6.07634        0.08407       14.66806        1.01053       20.82080       12.19591        0.37294        1.36328        9.84746       -0.56485        1.05768       -1.24992        8.33374       -1.31461        7.53104       -1.57612       16.31618       -1.16930       -0.57272       -1.73029        -999.25        6.86400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2274305556 05:27:30/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.82608       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      118.33720        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.80877        0.00204        0.00147        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2052.00000       14.00000     2057.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       13.00000     2077.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.19980       15.40020       71.06480       72.93520        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      671.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.72163        -999.25        0.97601        0.97601     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.40000       20.40000       16.40000        0.80000       10.00000       64.80000       46.20000       39.60000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.00000       80.20000       80.20000        5.40000      101.00000      290.00000      456.00000      222.00000        1.20000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3678.01100     3586.12400     2334.20100     2445.51300     3429.13800     2883.49600     1844.23300     1056.69700     3162.16100     3213.86200      200.00000      200.00000     2130.29600     2015.45600     3888.41600     3577.82500      300.00000      300.00000     2067.04000     1645.03500     2485.48500     1333.09800     1917.73500     1819.66900      500.00000      500.00000      500.00000      500.00000        -999.25        -999.25      700.00000      500.00000        0.00017        0.00013        0.00013        0.00013       -9.94000        9.80100        4.74346        5.00504        4.80198        4.31323        4.43269        4.57906        4.20015        3.30498        3.99489        3.80706        4.39672        4.87488        3.50470        3.48171        3.46976        3.50410        2.59191        2.01823        4.34391        4.94070        0.23940       18.53500        0.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.86000        -999.25      207.95450       32.24436      197.28160      388.74630      250.24070       30.49868      217.21120       49.38290      275.68390      399.32830        1.79267       10.13817      214.16090      392.39050      176.91170       27.48682        2.65146       38.25351      251.59070      389.31460      201.83030      410.84370      275.47840       37.66577        4.19945     5000.00000        6.13896     5000.00000        7.83661     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25        6.20642        0.14614       14.46710        0.98872       20.36990       12.07605        0.35303        1.25949        9.64707       -0.63076        1.34996       -1.18407        8.03099       -1.42697        7.26572       -1.68750       15.38095       -1.46082       -0.20557       -1.66251        -999.25        4.12800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2277777778 05:28:00/20-Mar-2011        1.00000        -999.25       50.00000       43.21907       43.21907        0.21872        0.21872        -999.25        0.00000       23.82608       50.00000        1.00000       29.50000        0.29665       12.39137       -0.00967       10.00000       20.00000       20.00000       80.51042       20.00000       20.00000       50.00000      118.50162        -999.25        1.03000       -0.07210        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81146        0.00179        0.00203        0.00000        0.00000        -999.25        0.07275        0.00000        4.00000        -999.25        0.00000       29.49988       49.99942       19.69988       -0.07210     1962.00000     2050.00000       15.00000     2050.00000        -999.25        0.00000        -999.25     1944.00000     2070.00000       14.00000     2076.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.18940       14.99060       70.01047       84.46954        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      677.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.80000       87.90000     1338.14000        2.59000       20.18000       16.38000        0.79000        6.16000       61.33000       43.67000       45.67000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       13.38000       80.53000       92.12000        4.79000      104.00000      293.00000      457.00000      219.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3694.84700     3594.15800     2366.33400     2466.53800     3454.92300     2884.45800     1890.07900     1064.39600     3231.56800     3213.03800      200.00000      200.00000     2136.98700     2016.79300     3935.46700     3609.98300      300.00000      300.00000     2086.24400     1646.19500     2533.14100     1341.51500     1966.83000     1818.29400      500.00000      500.00000      500.00000      500.00000        -999.25        -999.25      700.00000      500.00000        0.00016        0.00013        0.00013        0.00013       -9.94000        9.81200        4.75589        5.01872        4.80797        4.32598        4.41841        4.57121        4.20445        3.30835        3.97161        3.80420        4.38147        4.87166        3.46898        3.47779        3.42618        3.50396        2.54359        2.00984        4.31293        4.94504        0.23440       18.55700        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.36000        -999.25      207.09960       31.95117      196.60020      388.41700      249.35910       30.18156      215.41170       48.78087      274.52560      399.08750        1.81671       10.60140      213.33210      392.11170      176.60930       27.28803        2.73239       48.39134      250.52710      388.94420      200.57570      410.36420      274.14960       37.37009        4.43077     5000.00000        6.60039     5000.00000        8.48270     5000.00000        -999.25        -999.25        -999.25        -999.25        -999.25        6.23250        0.16052       14.34265        0.94759       19.99091       11.84759        0.27805        1.12899        9.32511       -0.72065        1.16802       -1.23738        7.67041       -1.51526        6.91093       -1.77661       14.83597       -1.58329       -0.37595       -1.71743        -999.25        6.52800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       27.90000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.26999        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2281250000 05:28:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.11296       14.85553       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      118.44269        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19100.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81983        0.00165        0.00365        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2049.00000       13.00000     2051.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       12.00000     2061.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.06640       15.13360       68.06480       70.93520        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      683.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.50592        0.37017        0.75792        0.75792     1675.10400        -999.25      221.40000       88.40000     1338.14000        2.20000       18.00000       16.80000        1.40000        7.60000       62.80000       46.80000       42.40000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25       25.27360       25.27360       25.27360        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.40000       77.60000       78.60000        5.80000      101.00000      277.00000      444.00000      224.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     2893.79900     1807.21800      726.35100      541.92380     2776.31400      591.34770       72.23907       96.18805      606.08060      197.35570        0.43578        0.13193      645.51150      488.64870     2222.70400     1575.10600        0.34623        0.11103      724.59350      200.98720      182.00070      248.76280      171.67570       79.15894        0.31570        0.09696        0.31106        0.09524        -999.25        -999.25        0.29574        0.10239        0.00015        0.00014        0.00013        0.00013       -9.94000        9.81200       13.03129       11.36028       11.84116       10.93624        9.71470       11.10971        9.89484        9.26743       10.30930        9.10574       11.66748        9.37349        9.69258        8.47246        9.32852        7.74269        8.02602        8.25329       10.95643        7.93499        0.24560       18.54600        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.33000        -999.25      127.55880       12.33314      315.91560      428.72570      141.25110       17.12575       52.18271      100.05680      522.74240      411.95340        1.05195        0.72606      513.14150      385.16840      294.77980       61.52082        0.72069        0.59173      539.07530      394.47200      390.41590      449.88760      208.05800       78.05074        0.61397        0.51137        0.55768        0.38545        0.45948        0.26151        -999.25        -999.25        -999.25        -999.25        -999.25       25.58270       12.83525       20.26369        8.84570       21.13580       26.42164       11.13059        7.20492       29.67214       13.02826       37.82423       17.34620       31.72276       15.96062       35.48093       20.31488       21.76678       10.16927       45.31558       26.09737        -999.25        6.38400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2284722222 05:29:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       14.81367       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      118.31160        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83420        0.00256        0.00262        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2049.00000       14.00000     2051.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       12.00000     2071.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.59000       17.79000       75.60126       64.87873        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      689.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.39000       17.98000       19.18000        1.39000        6.33000       67.83000       50.83000       44.83000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.98000       85.52000       72.73000        5.79000      106.00000      287.00000      448.00000      216.00000        1.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     2983.25400     1826.17000      924.07750      557.91750     2980.56500      620.79220       96.72272       99.50928      692.79690      280.63750        0.52509        0.13372      757.07820      502.28880     2809.13900     1626.31800        0.44896        0.11607      939.57310      218.08960      252.22930      259.19460      246.21220      128.82970        0.40971        0.10180        0.40045        0.10907        -999.25        -999.25        0.39917        0.14343        0.00016        0.00014        0.00013        0.00013       -9.94000        9.81200       11.91099       11.21175       11.38227       10.90929        9.65730       10.39090        9.79853        9.29271        9.54971        8.98392       10.02736        9.08623        8.93958        8.13853        8.41034        6.96619        8.32534        8.31525        8.98593        6.76260        0.24200       18.53500        1.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.80000        -999.25      125.51610       10.19837      281.45370      413.69510      135.45830       14.86959        3.60664       85.68254      518.47060      412.71110        4.61296        4.83025      491.08720      374.18500      271.66670       51.24972        5.13359        2.17517      501.46310      383.76680      357.63680      438.61620      167.00300       70.53290        6.90032        1.38166        8.17197        0.81496        6.78889        0.47048        -999.25        -999.25        -999.25        -999.25        -999.25        5.57104        3.98662        7.53539        1.94170        9.78699        7.78947        4.42639        2.44535        6.97600        6.83812        6.00482        8.89717        6.67362       10.22801        7.94989       14.66901        5.96983        7.06636        8.53236       17.82181        -999.25        3.84000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2288194444 05:29:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       14.81367       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      118.54505        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84407        0.00218        0.00197        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2049.00000       12.00000     2047.00000        -999.25        0.00000        -999.25     1944.00000     2070.00000       13.00000     2063.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.39940       12.60060       71.79840       73.60160        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      695.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      222.30000       88.40000     1338.14000        3.00000       18.80000       14.40000        1.20000        8.00000       69.40000       51.40000       44.40000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.60000       81.80000       82.00000        6.80000      103.00000      292.00000      455.00000      217.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3002.74200     1825.19000     1060.39600      558.60260     2988.56800      605.76480      106.55300       99.89899      667.52110      223.23520        0.58847        0.13570      801.07730      502.62150     3225.30200     1630.19300        0.48230        0.11453      979.10460      210.22860      280.15350      258.51260      241.61560       95.95001        0.43215        0.10000        0.41299        0.10273        -999.25        -999.25        0.39918        0.12140        0.00015        0.00014        0.00013        0.00013       -9.94000        9.81200       11.47687       11.20134       11.14272       10.87999        9.66204       10.20108        9.82744        9.30272        9.40138        9.02523        9.69268        9.19225        8.85176        8.27955        8.41029        7.34009        8.39661        8.25841        8.82680        7.33435        0.23920       18.51300        2.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.46000        -999.25      125.07690       10.15877      260.29690      412.68260      134.87230       14.39507      348.34400       86.74860      515.56620      411.46110        9.72792        5.64920      486.10950      373.72520      251.98010       50.24781        9.43903        2.29408      497.35570      383.01970      342.62200      439.67880      161.56240       70.41370       11.83245        1.42395       12.41543        0.78790        8.69415        0.42202        -999.25        -999.25        -999.25        -999.25        -999.25        1.03259        3.56639        4.27681        1.68936        8.31685        5.03945        4.24790        2.43475        4.78585        6.70006        2.48349        8.62464        5.03536       10.44427        6.80423       15.58692        5.72205        7.06976        5.99623       18.95258        -999.25        7.00800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2291666667 05:30:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       14.81367       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      118.66196        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85231        0.00147        0.00390        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2051.00000       15.00000     2052.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       14.00000     2066.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.18960       16.59040       72.79480       73.47520        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      701.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      220.90000       88.40000     1338.14000        2.19000       16.98000       17.98000        0.99000        9.33000       62.83000       45.83000       42.67000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.39000       82.32000       81.13000        5.79000      102.00000      296.00000      453.00000      213.00000        1.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3000.04800     1830.69500     1013.94200      561.71840     3022.26500      636.27750      105.38700      100.64180      783.32060      320.10250        0.56563        0.13187      790.59420      505.57650     3086.72800     1640.40700        0.47652        0.11864      989.60050      228.34990      277.98400      261.83110      299.82390      153.72040        0.43039        0.10590        0.42884        0.11635        -999.25        -999.25        0.45183        0.16235        0.00014        0.00014        0.00013        0.00014       -9.94000        9.81200       11.58349       11.17658       11.22532       10.93722        9.66971       10.23276        9.75138        9.30866        9.41269        8.89265        9.69745        8.90091        8.74565        7.98914        8.05912        6.71374        8.42466        8.30486        8.34147        6.37115        0.25040       18.48000        3.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.26000        -999.25      125.23390       10.14562      267.34660      410.00300      135.90080       14.77231      349.80520       82.91115      525.18900      409.44520        7.66068        6.46470      487.43340      373.52730      258.56290       47.60265        7.78744        2.31270      499.31820      383.54450      343.96450      435.13520      172.98850       65.58936       10.00805        1.35127       10.16099        0.82744        6.74336        0.52421        -999.25        -999.25        -999.25        -999.25        -999.25        2.19956        3.38170        5.15200        1.49677        8.78372        5.79812        4.22142        2.40037        5.39921        6.94177        3.41744        8.77218        5.77901       10.13213        7.98254       13.79679        5.84073        7.77593        7.79950       16.14414        -999.25        6.04800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2295138889 05:30:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       14.81367       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      117.29756        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85030        0.00234        0.00226        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2048.00000       13.00000     2048.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2058.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.93300       17.46700       64.33080       70.26920        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      707.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        0.31800        0.50592        -999.25        0.97601        0.97601     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.00000       19.60000       18.80000        1.00000        9.00000       63.80000       49.20000       48.60000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       14.00000       75.80000       79.20000        6.40000      107.00000      290.00000      435.00000      223.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3000.29700     1826.59900     1056.75100      561.42120     3002.15000      624.71130      110.08760      100.82670      693.55410      299.03470        0.57653        0.13331      798.35390      504.31580     3217.82800     1640.10800        0.48422        0.11716      993.08500      221.63510      288.37340      261.39370      259.50440      140.27860        0.43967        0.10394        0.42930        0.11332        -999.25        -999.25        0.42980        0.15328        0.00015        0.00015        0.00012        0.00013       -9.94000        9.81200       11.49938       11.17881       11.18542       10.91542        9.67180       10.19064        9.77842        9.31167        9.35387        8.93574        9.60892        9.00082        8.74267        8.04975        8.19903        6.82612        8.36434        8.27439        8.53871        6.57460        0.23400       18.56800        3.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.39000        -999.25      125.09670       10.12501      260.99250      409.77060      134.80160       14.89544      344.26770       83.50153      517.13180      411.59740        9.02631        6.86176      486.45750      373.35620      252.77130       47.46031        9.50182        2.43306      497.05090      383.34840      338.26310      435.84520      162.56460       68.46726       12.07833        1.41467       12.62689        0.82195        9.16432        0.48870        -999.25        -999.25        -999.25        -999.25        -999.25        1.36079        3.23116        4.53373        1.41862        8.22125        5.01515        4.05895        2.31029        4.71549        6.72977        2.24927        8.45297        4.97724       10.17399        6.58150       14.36113        6.00464        7.65638        5.43279       16.86988        -999.25        6.67200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2298611111 05:31:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25       -0.03160       14.71242       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      114.77338        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.86033        0.00254        0.00205        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2047.00000       14.00000     2047.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2078.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.05580       14.52420       70.67787       68.21214        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      713.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      220.90000       88.40000     1338.14000        2.99000       17.18000       15.78000        0.39000        7.50000       65.34000       48.17000       47.50000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.38000       80.93000       76.33000        5.99000      106.00000      280.00000      440.00000      234.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3002.40400     1827.24300     1108.64200      567.55310     2996.52100      617.57110      119.56210       99.08112      671.38400      287.34280        0.58270        0.13296      803.31820      504.85870     3372.13000     1662.93200        0.49074        0.11639      999.63870      218.81100      318.30720      263.89920      252.14390      136.83750        0.44030        0.10081        0.42263        0.10913        -999.25        -999.25        0.42012        0.15202        0.00015        0.00014        0.00013        0.00013       -9.95000        9.81200       11.45163       11.17253       11.16320       10.92067        9.66226       10.15558        9.79258        9.33736        9.34995        9.00657        9.53549        9.01236        8.78660        8.13724        8.26356        6.84249        8.50506        8.50895        8.50645        6.44391        0.23960       18.48000        4.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.26000        -999.25      125.05730       10.07679      253.68230      402.76600      134.66140       14.84037      329.32530       74.03782      516.16290      412.88340       10.07667        9.62455      485.95200      372.94250      245.95450       40.89973       11.21309        2.81064      496.02040      382.83160      323.76620      426.66560      160.35920       69.54308       14.99333        1.55127       15.99753        0.86405       11.58038        0.50013        -999.25        -999.25        -999.25        -999.25        -999.25        0.89472        2.86574        4.16004        1.03798        7.72786        4.42937        3.63014        1.86626        4.03564        6.31684        1.35902        7.99124        4.22280        9.86393        5.65392       14.17685        5.55914        7.37220        4.19626       16.65972        -999.25        6.04800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2302083333 05:31:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.02527       27.84444       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      108.98675        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19200.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.80420        0.00189        0.00305        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2048.00000       11.00000     2050.00000        -999.25        0.00000        -999.25     1944.00000     2070.00000       14.00000     2078.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.59920       14.60080       73.86460       71.73540        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      719.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.80000       88.40000     1338.14000        2.80000       16.60000       15.80000        0.40000        8.20000       64.20000       45.40000       46.40000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.00000       83.80000       79.60000        5.80000      110.00000      288.00000      435.00000      212.00000        0.40000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3960.22200     1815.61700      709.56730      557.48170     2943.47200      623.74910       81.32233      107.20370      796.53020      267.50730        0.35937        0.13248      847.88910      499.43150     2228.17800     1605.84100        0.33846        0.12291      817.91870      226.39830      202.71210      263.75640      268.51780      120.95310        0.34199        0.11567        0.37465        0.12353        -999.25        -999.25        0.41705        0.14867        0.00016        0.00014        0.00013        0.00013       -9.94000        9.81200       13.38761       11.21097       12.35674       10.92794        9.93913       11.17488        9.67582        9.18944       10.07000        8.69251       11.12300        8.80273        9.13218        7.85291        8.28445        6.88821        7.93340        7.81987        9.44458        6.89438        0.26720       18.52400        3.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.96000        -999.25      130.03810       10.30268      315.53120      416.92260      138.69510       13.54198       31.35864       86.21828      514.05350      405.27410        0.56087        2.38417      524.65060      375.68060      294.23610       53.91183        0.72061        1.96536      527.17700      381.35180      382.86040      439.77390      174.03620       57.32201        1.08064        1.56409        1.86398        1.15636        3.31271        0.86330        -999.25        -999.25        -999.25        -999.25        -999.25       34.61255        5.37793       29.45131        3.53972       21.29507       26.42315        4.78507        3.01075       21.72365        6.28030       28.48187        7.80980       16.41969        8.20172       12.18260       10.29946        8.49826        6.44442       19.98271       12.04790        -999.25        4.60800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2305555556 05:32:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.17679        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83059        0.00171        0.00127        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2050.00000       12.00000     2048.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2061.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.72280       17.25720       71.47807       67.81193        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      725.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      220.90000       87.90000     1338.14000        2.99000       22.18000       19.18000        1.39000        8.33000       57.17000       42.33000       44.67000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.18000       81.73000       76.13000        6.39000       96.17000      292.00000      447.00000      227.00000        0.19000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3976.41200     1814.65200      693.86110      547.98550     2745.03100      598.27420       73.06122       99.47601      612.81590      209.83280        0.38284        0.13306      849.28010      492.02640     2156.41000     1590.55200        0.32662        0.11200      714.31550      204.00050      187.31320      253.90140      176.15080       84.04541        0.30706        0.09867        0.30607        0.09747        -999.25        -999.25        0.29800        0.10414        0.00017        0.00014        0.00013        0.00013       -9.95000        9.80100       13.40881       11.33610       12.18513       10.91920        9.84918       11.27775        9.87584        9.25557       10.39365        9.06014       11.69314        9.34538        9.74292        8.41131        9.30227        7.70169        8.17763        8.13893       10.82891        7.94719        0.23240       18.52400        3.00000        -999.25        -999.25       29.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.20000        -999.25      130.62580       11.00474      324.11680      423.47820      141.06610       14.35250       48.54330       93.20145      518.45900      406.43620        0.49883        1.21642      527.03470      381.18350      296.86060       59.96842        0.50852        1.04149      538.57420      387.59080      391.36440      447.48590      196.20070       66.91699        0.60545        0.92697        0.73194        0.69338        0.74492        0.45736        -999.25        -999.25        -999.25        -999.25        -999.25       36.40895       10.17873       31.52261        6.03274       27.25620       32.10937        7.59194        3.50982       29.89722        8.93710       37.50812       13.23829       27.45631       11.30262       27.58559       14.90253       17.17892        5.71555       37.74167       20.48074        -999.25        5.76000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2309027778 05:32:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.49924        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83603        0.00182        0.00158        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2050.00000       17.00000     2050.00000        -999.25        0.00000        -999.25     1944.00000     2067.00000       14.00000     2061.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.46640       16.93360       62.53140       69.86861        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      731.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      220.90000       87.90000     1338.14000        2.20000       17.40000       18.60000        1.40000        9.40000       63.80000       46.60000       37.40000        0.40000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.80000       72.40000       77.80000        6.00000      103.00000      279.00000      432.00000      217.00000        1.00000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     2843.93700     1818.47300      719.18700      550.40890     2812.84800      599.12930       77.45087       98.30902      631.93660      209.64690        0.39413        0.13338      613.50620      494.08630     2202.91100     1601.12500        0.34224        0.11169      749.03990      204.20440      196.43430      254.98230      188.02580       84.91791        0.32320        0.09711        0.32357        0.09578        -999.25        -999.25        0.31947        0.10433        0.00016        0.00014        0.00013        0.00013       -9.94000        9.81200       13.32202       11.31808       12.10708       10.91437        9.72310       11.14293        9.88188        9.27480       10.23852        9.10166       11.49282        9.34911        9.57099        8.45759        9.08061        7.69740        8.08382        8.27833       10.52912        7.84978        0.24680       18.54600        4.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.39000        -999.25      129.59950       10.58152      319.07010      420.60000      139.03440       13.89992       39.21545       89.57918      516.59060      408.46040        0.58459        1.77608      523.63890      378.63860      296.42320       58.21046        0.65414        1.48691      531.29740      384.68120      389.06150      444.26090      186.02230       66.56931        0.87966        1.24703        1.24652        0.85943        1.47618        0.54159        -999.25        -999.25        -999.25        -999.25        -999.25       34.03937        8.05709       28.75204        4.49563       22.64688       27.90104        5.88711        2.38952       24.36608        7.32917       32.26299       10.78123       20.55506        9.89674       19.15192       13.53923       10.15396        5.31825       29.43170       18.10886        -999.25        6.67200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2312500000 05:33:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      111.13743        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82460        0.00262        0.00330        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2051.00000       14.00000     2052.00000        -999.25        0.00000        -999.25     1944.00000     2067.00000       15.00000     2062.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.45620       14.52380       73.00047       76.46953        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      737.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.19000       16.18000       15.78000        0.79000        9.00000       66.33000       48.50000       42.83000        0.79000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.98000       83.12000       83.72000        4.39000      109.00000      281.00000      437.00000      216.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     2973.38300     1823.21200      878.41060      553.00810     2949.47600      604.17570       90.52521       97.05627      655.97140      231.45750        0.50632        0.13450      735.84900      499.49920     2665.70800     1615.61800        0.42848        0.11262      896.71170      207.69990      235.22030      255.08030      221.39130       99.37775        0.38912        0.09708        0.37690        0.09901        -999.25        -999.25        0.36758        0.11861        0.00017        0.00015        0.00014        0.00013       -9.94000       10.08700       12.12924       11.24605       11.45984       10.89766        9.64230       10.51659        9.86390        9.31215        9.69540        9.10239       10.34184        9.27454        9.11472        8.36978        8.65252        7.39381        8.29411        8.39306        9.43449        7.34364        0.24020       18.54600        4.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.20000        -999.25      125.76460       10.21880      289.31530      416.29350      135.55130       14.38605       13.13951       87.95242      515.49020      412.39950        3.41718        3.79978      494.33580      374.95180      278.83550       53.95886        3.71280        2.06112      504.74010      383.51120      367.60190      441.32020      166.65160       71.48945        5.00442        1.38832        6.28676        0.79517        5.63012        0.43396        -999.25        -999.25        -999.25        -999.25        -999.25        8.57114        4.73295        9.33587        2.38909       10.47980        9.68190        4.61461        2.33463        8.63314        6.81591        9.18883        9.12515        7.91079       10.38499        8.90961       15.34607        5.53761        6.63226       11.16147       19.08994        -999.25        5.76000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2315972222 05:33:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.60464        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82176        0.00074        0.00236        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2042.00000       20.00000     2050.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       14.00000     2061.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.79980       18.00020       72.93060       66.46940        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      743.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      223.80000       88.90000     1338.14000        2.20000       18.80000       19.80000        1.60000        9.40000       60.00000       43.60000       48.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.60000       82.80000       73.60000        4.40000       95.40000      289.00000      446.00000      223.00000        1.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     2994.79700     1824.06000      975.22740      557.40300     2976.62600      603.50130      100.29480       98.25928      660.15140      221.74770        0.55816        0.13564      779.78030      501.74350     2963.89600     1627.96600        0.46548        0.11370      955.48310      208.49150      262.76460      257.14170      235.02870       94.30267        0.41997        0.09825        0.40368        0.09933        -999.25        -999.25        0.39264        0.11587        0.00016        0.00015        0.00013        0.00014       -9.94000        9.80100       11.68790       11.21115       11.25321       10.88086        9.65514       10.29472        9.84318        9.30952        9.48062        9.07109        9.87003        9.23180        8.91659        8.36131        8.45828        7.44825        8.36577        8.35598        8.97045        7.42670        0.23940       18.52400        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.13000        -999.25      125.27290       10.12480      273.46310      413.03400      134.91250       14.11996      357.45580       85.68890      514.20760      411.38570        6.55149        5.14627      488.38610      373.78780      264.38890       50.77642        6.87644        2.46335      499.02510      382.09170      352.16320      438.85860      160.75170       69.38877        9.29389        1.56793       11.32188        0.85563        9.13889        0.45650        -999.25        -999.25        -999.25        -999.25        -999.25        3.11319        3.66304        5.80863        1.83650        9.07413        6.34552        4.02028        2.25761        5.68234        6.26946        4.11260        7.97178        5.36484        9.92392        6.59307       14.91822        5.29254        6.83025        6.54405       18.00303        -999.25        5.42400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2319444444 05:34:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.58590        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82850        0.00208        0.00198        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2053.00000       14.00000     2043.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       12.00000     2067.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.45700       17.52300       70.21067       77.26933        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      749.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        0.99000       16.78000       19.18000        1.99000        6.33000       61.33000       47.50000       42.50000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.38000       79.93000       84.32000        4.39000      104.00000      286.00000      444.00000      214.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     2966.66300     1821.58800      855.12120      552.28520     2933.83300      599.70730       87.51007       97.51129      646.33700      213.85220        0.49580        0.13465      722.47920      497.53270     2591.93800     1611.34500        0.41591        0.11173      871.17650      204.62310      226.63390      254.84590      210.70400       88.08868        0.37673        0.09643        0.36278        0.09599        -999.25        -999.25        0.34848        0.10759        0.00016        0.00015        0.00012        0.00013       -9.95000        9.80100       12.26886       11.27257       11.50818       10.89544        9.63194       10.59750        9.88100        9.30051        9.78799        9.11991       10.54659        9.33969        9.22683        8.45182        8.81287        7.62338        8.26534        8.34445        9.73572        7.70387        0.23880       18.42500        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.96000        -999.25      125.92780       10.30462      293.33580      417.85590      135.78160       13.94153       19.04631       88.73408      514.78630      409.95220        3.01074        3.16170      496.44060      375.77440      282.59220       55.60150        3.06590        1.92417      507.78900      383.47640      373.67520      443.01790      169.14220       68.69564        3.92625        1.40174        4.83827        0.85302        4.25977        0.47883        -999.25        -999.25        -999.25        -999.25        -999.25       10.51278        5.46973       10.21935        2.79912       10.74359       11.00385        4.86110        2.25437       10.06677        6.77167       12.00742        9.53485        9.33083        9.94275       10.51762       14.52574        5.37114        5.71616       14.35599       18.74346        -999.25        4.60800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2322916667 05:34:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.24842        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.80106        0.00295        0.00322        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2052.00000       14.00000     2054.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       14.00000     2061.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.66640       12.13360       75.59800       67.80200        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      755.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       88.40000     1338.14000        2.40000       17.80000       14.00000        1.60000        8.20000       68.60000       51.80000       47.40000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.60000       85.20000       75.40000        5.60000      101.00000      274.00000      443.00000      217.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     2904.27000     1816.37300      756.17490      546.68120     2843.66700      594.32400       76.75842       96.12946      620.56340      201.36570        0.43192        0.13406      649.18000      492.85890     2291.31400     1590.40100        0.36200        0.11054      769.81810      200.78280      198.41250      250.49710      183.31970       80.10742        0.32904        0.09532        0.31707        0.09300        -999.25        -999.25        0.30318        0.09941        0.00018        0.00015        0.00012        0.00013       -9.94000        9.81200       13.01344       11.32965       11.86446       10.90416        9.62925       10.98310        9.90430        9.27545       10.18481        9.15038       11.34981        9.42594        9.63336        8.53621        9.24569        7.81585        8.24886        8.31893       10.59154        8.00625        0.23360       18.54600        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      127.66020       10.80509      311.63920      423.15490      137.92170       14.17554       37.50349       94.69816      516.22720      407.98830        0.98151        1.45381      514.09300      380.22320      294.88420       59.87466        0.99183        1.08581      525.99190      387.74320      388.15940      448.19960      187.22150       71.09032        1.18724        0.88039        1.37258        0.59129        1.24738        0.35461        -999.25        -999.25        -999.25        -999.25        -999.25       26.43281        9.41809       21.14937        5.26514       16.75500       22.00527        7.36935        3.28028       20.59427        9.24015       28.07024       13.56769       19.49257       12.43176       20.96708       17.17759        9.34407        6.49851       30.99426       23.10198        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2326388889 05:35:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.28889        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81361        0.00310        0.00166        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2055.00000       12.00000     2055.00000        -999.25        0.00000        -999.25     1944.00000     2070.00000       13.00000     2058.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.12280       17.25720       69.87747       77.80254        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      761.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      220.90000       88.40000     1338.14000        2.19000       16.78000       18.38000        0.59000        6.00000       65.50000       47.00000       45.00000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.38000       79.73000       85.12000        4.79000      107.00000      289.00000      446.00000      220.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     2978.10000     1823.36000      894.46780      555.32200     2954.34600      603.10210       92.64130       98.12347      654.15250      221.58910        0.51348        0.13514      743.73500      500.49960     2715.12200     1620.24000        0.43594        0.11359      909.85530      208.16800      241.61680      256.52650      223.82420       93.37524        0.39567        0.09827        0.38232        0.09868        -999.25        -999.25        0.37320        0.11326        0.00019        0.00015        0.00012        0.00013       -9.94000        9.81200       12.05042       11.22937       11.42983       10.88817        9.64449       10.46996        9.84525        9.30069        9.64800        9.07056       10.22978        9.23954        9.07312        8.37876        8.60742        7.50163        8.32645        8.34719        9.31544        7.50633        0.23920       18.49100        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.39000        -999.25      125.66920       10.19099      286.60420      415.46740      135.34480       14.11153        9.95630       87.20178      514.72180      411.16510        3.80400        4.16576      493.05040      374.55620      276.42020       53.17322        4.22223        2.19929      503.12520      382.78200      364.61150      440.72630      164.39460       69.39848        5.82395        1.47600        7.45427        0.84806        6.65239        0.46649        -999.25        -999.25        -999.25        -999.25        -999.25        7.38125        4.36526        8.64768        2.20679       10.18402        8.88442        4.38880        2.29422        7.80677        6.53926        7.78035        8.67045        7.09012        9.97878        8.04884       14.73893        5.34485        6.47546        9.67279       18.23338        -999.25        6.67200        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2329861111 05:35:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      109.94292        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85129        0.00219        0.00275        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2053.00000       14.00000     2055.00000        -999.25        0.00000        -999.25     1944.00000     2068.00000       14.00000     2057.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       20.93300       20.06700       73.99740       63.40260        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      767.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       88.40000     1338.14000        2.20000       22.80000       21.60000        1.20000        7.20000       64.80000       46.60000       45.80000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       13.60000       85.00000       71.80000        5.80000      106.00000      274.00000      437.00000      233.00000        1.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     2997.33500     1826.55300      999.31980      557.51770     2990.92500      618.87790      101.36690      100.29510      684.52730      276.08180        0.56949        0.13391      787.66630      502.14750     3038.38500     1626.21600        0.47155        0.11538      967.22050      216.52310      264.97160      258.39600      246.32780      125.62010        0.42549        0.10199        0.41071        0.10998        -999.25        -999.25        0.40132        0.14335        0.00019        0.00015        0.00012        0.00012       -9.94000        9.81200       11.60786       11.21602       11.21109       10.90639        9.65877       10.26042        9.81138        9.29839        9.44438        8.97945        9.80560        9.12201        8.86741        8.11915        8.39485        6.96741        8.34607        8.22012        8.87755        6.83957        0.24620       18.52400        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.10000        -999.25      125.20440       10.20813      269.62330      414.17670      135.16350       15.11601      356.42620       88.47980      518.31800      413.43720        7.61812        5.38832      487.48280      374.10640      260.75570       51.67653        7.53626        2.08596      498.89540      384.57470      350.45320      441.09880      165.76980       72.67125        9.46680        1.27729       10.01477        0.73774        7.13513        0.41445        -999.25        -999.25        -999.25        -999.25        -999.25        2.27841        3.89828        5.17441        1.76247        8.86755        5.93839        4.57207        2.50013        5.61052        7.21124        3.73200        9.45867        5.83688       10.87880        7.70931       15.74519        5.97302        7.38105        7.45184       19.23409        -999.25        5.28000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2333333333 05:36:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      109.98274        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83344        0.00229        0.00270        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2055.00000       14.00000     2052.00000        -999.25        0.00000        -999.25     1944.00000     2069.00000       13.00000     2056.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       12.25620       16.72380       69.01047       68.67953        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      773.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       88.40000     1338.14000        2.99000       14.78000       18.78000        1.59000        7.66000       62.50000       47.67000       46.00000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.78000       78.93000       75.73000        4.19000      101.00000      275.00000      429.00000      227.00000        0.99000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     2970.76100     1821.95800      862.39650      551.65440     2938.47000      602.33120       86.87225       98.13324      650.25790      221.00430        0.50612        0.13446      729.34780      497.32450     2613.14900     1606.79300        0.41982        0.11235      875.19740      206.09130      226.24050      254.09610      210.48400       91.22162        0.37695        0.09777        0.35875        0.09785        -999.25        -999.25        0.33979        0.10977        0.00018        0.00015        0.00013        0.00012       -9.94000        9.81200       12.19866       11.27797       11.46071       10.89821        9.62915       10.57198        9.86898        9.28586        9.78626        9.08395       10.52031        9.31552        9.25989        8.40091        8.88987        7.57566        8.31379        8.26364        9.79733        7.68606        0.23240       18.52400        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.33000        -999.25      125.84700       10.38549      292.20360      419.12310      135.92420       14.41786       19.40363       90.95844      516.45560      410.67360        3.35054        2.86597      495.40160      376.47490      281.66250       56.71463        3.24480        1.67356      507.65720      385.15200      373.81020      445.02430      171.92850       70.74819        4.00912        1.21379        4.57524        0.75953        3.63726        0.43461        -999.25        -999.25        -999.25        -999.25        -999.25        9.55464        6.08937        9.46808        3.04110       10.54108       10.59447        5.39289        2.40851        9.93453        7.46434       11.73305       10.73412        9.65259       10.68436       11.53499       15.33328        5.59342        5.93417       15.47284       20.07461        -999.25        6.38400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2336805556 05:36:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      109.90608        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82996        0.00223        0.00247        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2052.00000       14.00000     2065.00000        -999.25        0.00000        -999.25     1944.00000     2066.00000       14.00000     2056.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.86560       16.93440       75.26520       69.73479        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      779.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        -999.25        0.75792        0.75792     1675.10400        -999.25      220.90000       90.40000     1338.14000        4.00000       21.80000       18.80000        0.80000        9.00000       63.00000       43.80000       43.80000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000        9.80000       83.60000       76.60000        5.40000      108.00000      288.00000      460.00000      220.00000        1.20000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3976.38200     1814.29200      693.09230      544.91390     2734.66900      594.11710       71.33392       96.26465      588.15700      209.75250        0.38594        0.13294      850.69150      490.51300     2151.92900     1586.35600        0.32676        0.10950      709.45650      199.80900      185.73940      250.20170      166.02260       84.28101        0.30260        0.09476        0.29561        0.09380        -999.25        -999.25        0.28306        0.10294        0.00017        0.00015        0.00013        0.00013       -9.94000        9.81200       13.39432       11.36113       12.16343       10.92097        9.84074       11.27651        9.92498        9.28146       10.43839        9.16587       11.71958        9.46514        9.85619        8.51311        9.48113        7.72979        8.31216        8.29647       10.98652        7.91955        0.24460       18.51300        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.20000        -999.25      130.65720       11.33756      324.59010      425.03090      141.17300       15.18228       50.00728       95.03871      519.77920      410.96720        0.49399        1.03719      527.24580      382.53990      297.05360       60.63551        0.50047        0.85163      539.08950      390.14290      391.40910      448.34400      200.15920       75.49437        0.58257        0.74829        0.66375        0.53253        0.62774        0.32624        -999.25        -999.25        -999.25        -999.25        -999.25       36.58855       11.20236       31.69534        6.81263       27.53650       32.39653        8.72119        4.39534       30.52633       10.26443       37.91656       14.96063       28.92766       13.23439       30.17191       17.99636       18.59819        6.69469       40.38007       24.52721        -999.25        5.76000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2340277778 05:37:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.54421        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.81737        0.00193        0.00259        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     1998.00000       72.00000     2037.00000        -999.25       64.00000        -999.25     1931.00000     2198.00000      169.00000     2023.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.52280       16.85720       69.34447       67.34553        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      785.00000       80.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        -999.25        -999.25        0.41436        0.41436        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        2.79000       18.78000       18.58000        1.19000       10.00000       67.33000       49.17000       47.83000        0.39000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.18000       79.33000       75.13000        5.59000      100.00000      295.00000      453.00000      216.00000        0.79000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     3011.10000     1828.62500     1238.32100      565.70070     3006.07500      623.49150      123.92270      100.79590      696.32170      286.06050        0.61011        0.13399      818.24920      505.92410     3756.83300     1651.46300        0.50294        0.11791     1010.72300      221.84480      331.15110      261.85970      264.40160      134.39850        0.44541        0.10437        0.42636        0.11335        -999.25        -999.25        0.42584        0.15287        0.00017        0.00015        0.00014        0.00013       -9.94000        9.80100       11.31679       11.16078       11.06786       10.90518        9.63977       10.09359        9.76460        9.30564        9.31837        8.92617        9.46735        8.97563        8.76191        8.04918        8.22516        6.83148        8.53751        8.29252        8.41092        6.56127        0.24000       18.53500        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.43000        -999.25      124.94530       10.13158      236.57780      406.93820      135.01660       15.11176      323.25250       82.10756      519.76870      413.16010       16.13894        8.15963      484.74460      373.15590      229.94180       44.65965       14.91285        2.45615      496.20530      383.71680      317.62600      434.19190      165.18180       70.61310       16.87504        1.37435       14.53584        0.78268        9.03081        0.45804        -999.25        -999.25        -999.25        -999.25        -999.25       -0.20072        3.02431        2.83512        1.20961        6.63602        3.56701        4.02940        2.27858        3.69436        6.86269        1.18869        8.60504        4.51812       10.48744        6.64283       14.89012        5.62653        7.91567        5.41310       17.45303        -999.25        6.86400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2343750000 05:37:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      111.08796        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82839        0.00184        0.00311        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     2028.00000       13.00000     2030.00000        -999.25       64.00000        -999.25     1933.00000     2025.00000       29.00000     2042.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       18.26580       16.33420       71.33241       67.66759        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      791.00000       78.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.16921        0.29964        -999.25        0.41436        0.41436        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      220.90000       87.90000     1338.14000        3.60000       21.00000       18.20000        1.00000        8.20000       67.00000       48.20000       44.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000        9.40000       79.80000       75.20000        6.60000       99.20000      276.00000      442.00000      224.00000        0.60000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     3006.81300     1825.91500     1099.04000      560.10380     2988.90500      607.46190      110.01800       99.35699      661.50180      237.44230        0.59553        0.13516      806.63880      503.28030     3339.77600     1635.82800        0.48812        0.11501      986.19290      211.83500      290.96740      258.62270      241.80510      105.82580        0.43531        0.10028        0.41464        0.10554        -999.25        -999.25        0.40240        0.13260        0.00017        0.00015        0.00013        0.00013       -9.92000        9.81200       11.42855       11.19341       11.11792       10.88783        9.65408       10.16960        9.81833        9.30938        9.38130        9.01872        9.63100        9.15043        8.84047        8.21582        8.38710        7.13975        8.44761        8.30937        8.74131        7.01933        0.23900       18.51300        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.60000        -999.25      125.01700       10.14435      255.13000      411.15590      134.78770       14.67239      342.40370       85.71862      515.50600      414.04200       11.16474        6.18026      485.61010      373.55190      247.31100       48.75826       10.82214        2.34035      496.75010      383.26970      336.76820      437.94640      160.91420       73.08037       13.38519        1.37731       13.66218        0.74532        9.46140        0.40229        -999.25        -999.25        -999.25        -999.25        -999.25        0.59308        3.40759        3.82849        1.55852        7.81894        4.55036        4.18279        2.39760        4.37921        6.85271        1.96246        8.59730        4.71480       10.81012        6.45015       16.00936        5.63547        7.77221        5.40816       19.03841        -999.25        7.68000        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2347222222 05:38:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      109.65440        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83048        0.00236        0.00242        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1962.00000     1997.00000       13.00000     2005.00000        -999.25        0.00000        -999.25     1933.00000     2055.00000       11.00000     2045.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       15.58980       15.39020       72.66180       64.40820        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      797.00000      100.00000        0.00000        0.19000        0.00000        0.00000        0.00000        0.00000        0.19000        -999.25        0.28889        -999.25        0.40331        0.40331        -999.25        -999.25        0.37017        0.75792        0.75792     1675.10400        -999.25      222.30000       88.40000     1338.14000        1.59000       16.98000       16.58000        0.99000        8.50000       61.17000       43.33000       44.67000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       10.99000       82.12000       72.33000        6.39000      100.00000      293.00000      443.00000      226.00000        0.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     2868.04200     1811.12900      712.06390      543.59620     2757.79800      592.96840       71.12488       97.84851      593.15610      203.72160        0.41067        0.13177      626.29760      489.32950     2188.05100     1581.46100        0.33854        0.11039      719.68350      200.92190      185.15140      249.94200      167.17590       82.10297        0.30745        0.09739        0.29651        0.09733        -999.25        -999.25        0.28131        0.10635        0.00017        0.00017        0.00013        0.00013       -9.92000        9.81200       13.21609       11.36696       11.99757       10.93870        9.75077       11.17418        9.90726        9.27564       10.38980        9.09420       11.66842        9.40008        9.84572        8.41496        9.50294        7.65118        8.31011        8.14570       10.99991        7.89357        0.23900       18.52400        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.73000        -999.25      128.79510       11.74838      320.41800      426.84010      140.72330       15.83897       51.13303       97.65383      521.12990      410.21240        0.68090        0.87992      520.37060      383.71540      296.64130       61.16330        0.61032        0.70828      537.59200      392.14810      391.66740      449.55020      203.55370       75.61188        0.62929        0.61537        0.63515        0.45579        0.54752        0.29538        -999.25        -999.25        -999.25        -999.25        -999.25       31.57549       11.96701       26.31760        7.68975       23.77670       29.00142        9.89021        5.67682       29.27935       11.61127       36.86877       16.30910       29.61038       14.49404       32.40041       19.01790       19.46564        8.10363       42.42383       25.39945        -999.25        3.50400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2350694444 05:38:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.34771        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.84356        0.00329        0.00264        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     2002.00000     1569.00000      230.00000     1593.00000        -999.25      616.00000        -999.25     1905.00000     2380.00000      253.00000     2120.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.66660       15.13340       67.59800       66.20200        -999.25       16.00000        -999.25        -999.25        -999.25        -999.25        -999.25      803.00000      100.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       87.90000     1338.14000        1.39000       17.99000       16.39000        1.19000        9.39000       65.79000       47.59000       43.19000        0.39000        0.00000        0.00000        0.00000       32.00000        0.20000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.19000       77.79000       74.39000        6.19000      112.00000      291.00000      443.00000      219.00000        0.39000        -999.25        1.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       31.00000        4.00000        -999.25        -999.25     2955.30400     1820.97300      830.62930      553.34010     2923.93500      601.75510       86.31744       98.87604      648.93460      216.21150        0.47345        0.13465      702.15000      497.55280     2514.58500     1612.08600        0.40307        0.11255      853.31940      206.15260      222.60250      256.24790      211.03210       89.43756        0.36853        0.09788        0.35977        0.09798        -999.25        -999.25        0.35312        0.11012        0.00017        0.00018        0.00013        0.00012       -9.94000        9.81200       12.48345       11.26929       11.62611       10.89545        9.62118       10.68340        9.86512        9.28792        9.85139        9.08095       10.69712        9.30462        9.25145        8.39734        8.77288        7.56810        8.22863        8.27138        9.75705        7.66718        0.24020       18.54600        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.46000        -999.25      126.25180       10.28892      297.74580      417.69030      136.05710       13.91442       22.00390       87.70096      514.85840      409.16540        2.15296        2.97857      500.82390      375.82410      286.62820       55.41570        2.40870        1.95715      510.58420      383.09900      376.32300      442.14870      169.95380       66.70988        3.18279        1.46891        4.11049        0.92223        4.20522        0.53522        -999.25        -999.25        -999.25        -999.25        -999.25       14.57210        5.53515       12.82089        2.94585       11.11755       12.83559        4.80000        2.27458       11.49756        6.56062       14.52711        9.18461       10.30050        9.47347       10.59714       13.63207        5.68094        5.55225       15.09538       17.54444        -999.25        7.00800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2354166667 05:39:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.74847        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.85177        0.00267        0.00218        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1785.00000     3023.00000      925.00000     1779.00000        -999.25      616.00000        -999.25     2215.00000      640.00000      640.00000     2827.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       19.17960       13.99040       65.66846       73.99153        -999.25       16.00000        -999.25        -999.25        -999.25        -999.25        -999.25      809.00000      100.00000        0.00000        0.19000        0.00000        0.00000        0.00000        0.00000        0.19000        0.16921        0.28889        0.37648        0.40331        0.40331        -999.25        -999.25        -999.25        -999.25        -999.25     1675.10400        -999.25      221.40000       88.40000     1338.14000        2.19000       20.97000       15.38000        0.99000        6.33000       64.83000       46.99000       43.16000        0.39000        0.00000        0.00000        0.00000       32.00000        0.20000        -999.25        -999.25        -999.25       25.26324       25.26324       25.26324        -999.25     1024.00000       18.60000      239.00000        0.19000        0.19000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       11.78000       75.92000       82.71000        7.19000      102.00000      287.00000      440.00000      214.00000        1.59000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        4.00000       53.00000        -999.25     3001.03900     1825.09300     1052.55500      563.66330     2992.15500      613.65230      110.98820      100.51670      675.93900      273.28580        0.57541        0.13407      795.65250      503.78850     3196.79100     1647.07000        0.48327        0.11632      985.94600      216.32450      292.44110      263.11890      251.44040      126.42300        0.43586        0.10175        0.42223        0.10919        -999.25        -999.25        0.42152        0.14482        0.00017        0.00017        0.00012        0.00012       -9.94000        9.81200       11.53096       11.18073       11.18948       10.90407        9.64939       10.19576        9.79387        9.31385        9.37784        8.98502        9.64262        9.05634        8.78922        8.13588        8.25411        6.94510        8.41524        8.35828        8.58945        6.69582        0.23900       18.50200        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        0.96000        -999.25      125.11590       10.07471      261.82720      407.64860      134.71380       14.55308      341.62300       79.58957      514.91830      413.01130        8.50513        7.18109      486.66380      373.16580      253.53650       45.55051        9.39503        2.68191      496.80300      382.39200      336.06560      432.60760      159.34520       69.77925       12.72756        1.59251       14.80191        0.89400       11.61277        0.50480        -999.25        -999.25        -999.25        -999.25        -999.25        1.54787        3.09110        4.74881        1.36098        8.29076        5.05664        3.76432        2.09808        4.54101        6.20110        2.08917        7.83895        4.46214        9.65779        5.64351       14.10096        5.55740        6.98196        4.42693       16.76793        -999.25        4.60800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.10000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2357638889 05:39:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      109.94856        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.79526        0.00149        0.00151        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1848.00000     1787.00000      727.00000     1320.00000        -999.25      616.00000        -999.25     2254.00000     1330.00000     1330.00000     2403.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.79960       13.40040       75.26480       68.53519        -999.25       16.00000        -999.25        -999.25        -999.25        -999.25        -999.25      815.00000      100.00000        0.39000        0.19000        0.00000        0.00000        0.00000        0.00000        0.59000        0.38775        0.28889        -999.25        0.84518        0.84518        0.30720        0.49513        -999.25        0.74702        0.74702     1675.10400        -999.25      222.80000       88.90000     1338.14000        2.19000       18.59000       14.79000        0.99000        8.59000       65.59000       47.19000       46.99000        0.19000        0.00000        0.00000        0.00000       32.00000        0.20000       36.83715       36.83715       36.83715       25.67764       25.67764       25.67764        2.00000     1024.00000       18.60000      239.00000        0.59000        0.59000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000        9.79000       83.19000       74.59000        4.19000      108.00000      286.00000      446.00000      215.00000        1.19000        -999.25        1.00000        -999.25        -999.25        1.00000        -999.25        -999.25        -999.25       31.00000        4.00000        -999.25        -999.25     2933.13700     1820.03600      794.12510      551.66600     2897.62300      602.14050       82.70966       97.89093      643.98800      226.60920        0.44949        0.13439      674.09450      496.40140     2400.73800     1606.57700        0.38285        0.11212      816.44010      205.69790      213.20010      254.71100      201.57140       93.99139        0.35021        0.09713        0.34132        0.09733        -999.25        -999.25        0.33390        0.11041        0.00016        0.00016        0.00012        0.00011       -9.94000        9.81200       12.77223       11.28494       11.76036       10.89930        9.60912       10.82587        9.87351        9.28451        9.99999        9.10115       11.00235        9.32936        9.40873        8.41504        8.94352        7.56173        8.22462        8.30611       10.08898        7.64379        0.26360       18.52400        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1542.00000        0.96000        -999.25      126.84790       10.41205      304.47490      419.09200      136.73640       14.24403       28.01989       89.37382      515.80620      410.83210        1.40047        2.46831      507.72720      376.90020      291.63100       56.81065        1.57214        1.72810      517.11740      384.32500      382.17710      443.65180      176.17310       69.56277        2.07825        1.31990        2.73276        0.83449        2.89595        0.48740        -999.25        -999.25        -999.25        -999.25        -999.25       20.87934        6.48819       16.95103        3.43995       12.84387       16.73901        5.26576        2.28139       14.89651        7.05296       20.38094       10.08098       13.16277       10.07902       13.16826       14.38255        5.84279        5.72202       20.36691       18.73068        -999.25        4.60800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2361111111 05:40:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.89982        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.82917        0.00371        0.00253        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1939.00000     2085.00000       45.00000     2074.00000        -999.25      576.00000        -999.25     2197.00000     1977.00000       42.00000     2002.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       14.85640       15.32360       72.47787       77.80213        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      821.00000      100.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.39000        0.39000        -999.25        -999.25        -999.25        -999.25        -999.25        0.31800        -999.25        0.58155        0.96510        0.96510     1675.10400        -999.25      222.30000       87.40000     1338.14000        1.79000       16.38000       16.58000        0.99000        7.50000       64.50000       45.50000       43.67000        0.19000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730        -999.25        -999.25        -999.25        -999.25     1024.00000       18.60000      239.00000        0.00000        0.00000        0.39000        0.39000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       12.38000       82.73000       85.92000        5.99000      107.00000      280.00000      444.00000      219.00000        0.79000        -999.25        1.00000        -999.25        -999.25        -999.25        1.00000        -999.25        -999.25       31.00000        0.00000       53.00000        -999.25     2997.05800     1824.49700      987.05470      557.32760     2975.67400      605.40280      100.38180       98.52356      658.70240      228.06920        0.56549        0.13504      783.66150      501.65590     2996.93300     1628.77700        0.46859        0.11368      957.06570      209.47570      264.26850      257.86900      234.63650       97.71210        0.42000        0.09845        0.40148        0.10006        -999.25        -999.25        0.38970        0.11809        0.00015        0.00016        0.00012        0.00011       -9.94000        9.81200       11.65133       11.21474       11.22586       10.88970        9.64672       10.27708        9.84343        9.31502        9.48044        9.06598        9.85287        9.21822        8.93218        8.34243        8.48015        7.40399        8.40781        8.35718        8.96587        7.36237        0.23220       18.44700        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.06000        -999.25      125.22970       10.12768      271.86150      412.88990      134.94420       14.24488      356.66900       84.91405      514.92170      411.54420        7.04475        5.30841      487.96350      373.82230      262.95870       50.69081        7.25768        2.44502      498.81160      382.39540      351.11740      438.45980      161.60920       69.41292        9.53769        1.57478       11.00964        0.88083        8.52056        0.47536        -999.25        -999.25        -999.25        -999.25        -999.25        2.73386        3.69461        5.49976        1.78621        8.90280        6.10373        4.04358        2.19906        5.58171        6.25022        3.86743        8.15054        5.46898        9.74705        6.89151       14.58484        5.55167        6.45428        6.68750       17.86876        -999.25        5.08800        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2364583333 05:40:30/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.31775        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.83025        0.00128        0.00382        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1939.00000     2035.00000       45.00000     2067.00000        -999.25      512.00000        -999.25     2197.00000     1979.00000       26.00000     1968.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       17.73300       15.06700       74.06520       74.33479        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      827.00000      100.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        -999.25        0.29964        -999.25        0.41436        0.41436        -999.25        0.50592        -999.25        0.75792        0.75792     1675.10400        -999.25      226.70000       88.40000     1338.14000        1.80000       19.20000       16.20000        0.80000        8.60000       71.20000       52.60000       47.00000        0.20000        0.00000        0.00000        0.00000        0.00000        0.20000       36.84730       36.84730       36.84730       25.27360       25.27360       25.27360        3.00000        0.00000       18.60000      239.00000        0.00000        0.00000        0.00000        0.00000        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000        9.80000       82.40000       81.20000        5.40000      105.00000      284.00000      441.00000      227.00000        0.80000        -999.25        1.00000        -999.25        -999.25        1.00000        -999.25        -999.25        -999.25       31.00000        0.00000        -999.25        -999.25     2973.26900     1822.31100      874.96950      554.89750     2948.02900      601.71810       90.68604       97.99194      655.33290      219.24470        0.50325        0.13516      733.45090      499.54380     2654.33500     1618.29100        0.42659        0.11316      893.60440      207.00780      234.87700      256.78740      221.11910       90.92621        0.38842        0.09758        0.37781        0.09675        -999.25        -999.25        0.36991        0.10826        0.00016        0.00016        0.00012        0.00011       -9.94000        9.81200       12.15726       11.24098       11.47286       10.88782        9.63926       10.52854        9.85340        9.29688        9.70055        9.08902       10.36773        9.26813        9.10770        8.43076        8.63366        7.60858        8.26600        8.36767        9.43672        7.64480        0.24460       18.54600        3.00000        -999.25        -999.25       30.00000        -999.25        -999.25        -999.25        -999.25        -999.25    -1543.00000        1.23000        -999.25      125.77210       10.19678      289.88340      415.82360      135.53680       13.83479       14.23903       85.99693      514.35270      409.63640        3.41929        3.70396      494.47210      374.84870      279.41250       53.65475        3.64269        2.24831      505.11120      382.17250      368.52640      440.22780      165.33400       66.96517        4.79736        1.60575        6.11653        0.94747        5.78283        0.52463        -999.25        -999.25        -999.25        -999.25        -999.25        8.70008        4.65195        9.33176        2.44231       10.47092        9.80607        4.31463        2.16886        8.86745        6.16499        9.57434        8.33776        8.04964        9.31629        8.76558       13.79047        5.71266        5.76915       10.98123       17.32876        -999.25        5.90400        0.00000        0.00000        0.00000        1.00000        1.00000        1.00000        0.00000        -999.25        0.00000       28.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.55950        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25
 40622.2368055556 05:41:00/20-Mar-2011        1.00000        -999.25       50.00000       46.57329       46.57329        0.21872        0.21872        -999.25        0.00000       28.35036       50.00000        1.00000       31.78950        0.29665       12.39137       -0.01123       10.00000       20.00000       20.00000       80.55215       20.00000       20.00000       50.00000      110.24277        -999.25        1.03000       -0.08373        1.00000        0.00000        0.00000        0.21872    19000.00000        2.00000        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        0.00000        0.00000        0.00000        0.00000       15.80148        0.00222        0.00255        0.00000        0.00000        -999.25        0.08448        0.00000        4.00000        -999.25        0.00000       31.78935       49.99942       21.98935       -0.08373     1939.00000     2065.00000       24.00000     2051.00000        -999.25        0.00000        -999.25     2197.00000     1991.00000       24.00000     1983.00000        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25        -999.25       16.58960       16.59040       73.72820       74.54180        -999.25        0.00000        -999.25        -999.25        -999.25        -999.25        -999.25      833.00000      100.00000        0.19000        0.00000        0.00000        0.19000        0.00000        0.19000        0.59000        0.15771        0.29964        0.38737        0.40331        0.40331        0.30720        -999.25        0.35904        0.96510        0.96510     1675.10400        -999.25      221.80000       87.40000     1338.14000        2.39000       18.58000       18.18000        1.19000        7.50000       59.33000       44.17000       42.83000        0.59000        0.00000        0.19000        0.19000        0.00000        0.20000        -999.25        -999.25        -999.25       25.26324       25.26324       25.26324        5.00000        0.00000       18.60000      239.00000        0.19000        0.19000        0.39000        0.39000        -999.25        -999.25        0.00000        0.00000        0.19000        0.19000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.00000        0.60000        0.00000        0.00000        0.00000     1427.88000       10.79000       82.72000       81.73000        5.39000      105.00000      284.00000      433.00000      218.00000        0.19000        -999.25        1.00000        -999.25        -999.25        1.00000        1.00000        -999.25        -999.25       31.000